/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.MongoJSLexerTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSLookAheadLexer;", "Lcom/intellij/lexer/LookAheadLexer;", "baseLexer", "Lcom/intellij/lexer/Lexer;", "types", "Lcom/intellij/sql/dialects/mongo/js/MongoJSLexerTypes;", "<init>", "(Lcom/intellij/lexer/Lexer;Lcom/intellij/sql/dialects/mongo/js/MongoJSLexerTypes;)V", "lookAhead", "", "isSqlTopKeyword", "", "type", "Lcom/intellij/psi/tree/IElementType;", "text", "", "isSpaceOrComment", "tryProcessSqlPrefix", "isInitial", "lookAheadSqlSource", "intellij.database.dialects.mongo"})
public class MongoJSLookAheadLexer
extends LookAheadLexer {
    @NotNull
    private final MongoJSLexerTypes types;

    public MongoJSLookAheadLexer(@NotNull Lexer baseLexer, @NotNull MongoJSLexerTypes types) {
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        super(baseLexer);
        this.types = types;
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        if (this.lookAheadSqlSource(baseLexer)) {
            return;
        }
        super.lookAhead(baseLexer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSqlTopKeyword(IElementType type, String text) {
        if (!Intrinsics.areEqual((Object)type, (Object)this.types.getIdentifier())) return false;
        String string = text.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)string, (Object)"SELECT")) return false;
        return true;
    }

    private final boolean isSpaceOrComment(IElementType type) {
        return Intrinsics.areEqual((Object)type, (Object)this.types.getWhiteSpace()) || this.types.getComments().contains(type);
    }

    private final boolean tryProcessSqlPrefix(Lexer baseLexer, boolean isInitial) {
        int initialCacheSize = this.getCacheSize();
        if (!isInitial) {
            this.addToken(baseLexer.getTokenStart(), this.types.getSqlSource());
        }
        IElementType iElementType = baseLexer.getTokenType();
        String string = baseLexer.getTokenText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
        if (!this.isSqlTopKeyword(iElementType, string)) {
            return false;
        }
        this.advanceLexer(baseLexer);
        while (this.isSpaceOrComment(baseLexer.getTokenType())) {
            this.advanceLexer(baseLexer);
        }
        if (this.types.getBlockedFirstTypesAfterSqlTopKeyword().contains(baseLexer.getTokenType())) {
            return false;
        }
        this.resetCacheSize(initialCacheSize);
        return true;
    }

    private final boolean lookAheadSqlSource(Lexer baseLexer) {
        boolean isInitial = true;
        while (this.tryProcessSqlPrefix(baseLexer, isInitial)) {
            isInitial = false;
            while (baseLexer.getTokenType() != null && !Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.types.getSemicolon())) {
                if (Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.types.getIdentifier()) && Intrinsics.areEqual((Object)baseLexer.getTokenText(), (Object)"db")) {
                    int dbStartOffset = baseLexer.getTokenStart();
                    int dbEndOffset = baseLexer.getTokenEnd();
                    baseLexer.advance();
                    if (!Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.types.getDot())) continue;
                    this.addToken(dbStartOffset, this.types.getSqlSource());
                    this.addToken(dbEndOffset, this.types.getIdentifier());
                    return true;
                }
                baseLexer.advance();
            }
            if (!Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.types.getSemicolon())) continue;
            baseLexer.advance();
            while (this.isSpaceOrComment(baseLexer.getTokenType())) {
                baseLexer.advance();
            }
        }
        return !isInitial;
    }
}

