/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redis;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlTokens;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.io.Reader;

public class _RedisLexer
implements FlexLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0};
    static final char[] ZZ_CMAP_Z = _RedisLexer.zzUnpackCMap("\u0001\u0000\u0087@");
    static final char[] ZZ_CMAP_Y = _RedisLexer.zzUnpackCMap("\u0001\u0000\u0001\u0001~\u0002");
    static final char[] ZZ_CMAP_A = _RedisLexer.zzUnpackCMap("\t\u0000\u0001\u0003\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0001\u0012\u0000\u0001\u0003\u0001\u0000\u0001\u0006\u0004\u0000\u0001\u00054\u0000\u0001\u0004C\u0000\u0001\u0003\u00df\u0000");
    private static final int[] ZZ_ACTION = _RedisLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0002\u0002\u0001\u0003\u0001\u0001\u0003\u0004\u0001\u0005\u0001\u0004\u0002\u0005";
    private static final int[] ZZ_ROWMAP = _RedisLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0007\u0000\u000e\u0000\u0015\u0000\u001c\u0000#\u0000*\u00001\u00008\u0000\u0015\u0000?\u0000*\u00001";
    private static final int[] ZZ_TRANS = _RedisLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\u0002\u0003\u0000\u0001\u0006\u0004\u0000\u0001\u0004\u000e\u0000\u0001\u0005\u0003\u0000\u0001\u0002\u0003\u0000\u0001\u0006\u0002\u0002\u0001\u0007\u0002\u0000\u0001\u0007\u0001\t\u0001\n\u0001\u0007\u0001\b\u0002\u0000\u0001\b\u0001\u000b\u0001\b\u0001\n\u0001\u0007\u0002\u0000\u0001\u0007\u0001\t\u0001\f\u0001\u0007\u0001\b\u0002\u0000\u0001\b\u0001\u000b\u0001\b\u0001\r";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _RedisLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0002\u0001\u0001\t\u0005\u0001\u0001\t\u0003\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private final IntArrayList myStateStack = new IntArrayList(2);

    public static int ZZ_CMAP(int ch) {
        return ZZ_CMAP_A[ZZ_CMAP_Y[ZZ_CMAP_Z[ch >> 13] | ch >> 7 & 0x3F] << 7 | ch & 0x7F];
    }

    private static int[] zzUnpackAction() {
        int[] result2 = new int[13];
        int offset = 0;
        offset = _RedisLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            char value = packed.charAt(i2++);
            do {
                result2[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result2 = new int[13];
        int offset = 0;
        offset = _RedisLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int high = packed.charAt(i2++) << 16;
            result2[j++] = high | packed.charAt(i2++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result2 = new int[70];
        int offset = 0;
        offset = _RedisLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            int value = packed.charAt(i2++);
            do {
                result2[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result2 = new int[13];
        int offset = 0;
        offset = _RedisLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            char value = packed.charAt(i2++);
            do {
                result2[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private void pushState(int state) {
        this.myStateStack.push(this.yystate());
        this.yybegin(state);
    }

    private void popState() {
        this.yybegin(this.myStateStack.pop());
    }

    public _RedisLexer() {
        this(null);
        this.pushState(0);
    }

    public _RedisLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        int size = 0;
        int length = packed.length();
        for (int i2 = 0; i2 < length; i2 += 2) {
            size += packed.charAt(i2);
        }
        char[] map2 = new char[size];
        int i3 = 0;
        int j = 0;
        while (i3 < packed.length()) {
            int count = packed.charAt(i3++);
            char value = packed.charAt(i3++);
            do {
                map2[j++] = value;
            } while (--count > 0);
        }
        return map2;
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    public void reset(CharSequence buffer, int start2, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start2;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.myStateStack.clear();
        }
    }

    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block12: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _RedisLexer.ZZ_CMAP(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.yybegin(0);
                    return SqlTokens.SQL_IDENT;
                }
                case 6: {
                    continue block12;
                }
                case 2: {
                    this.yybegin(0);
                    return SqlTokens.SQL_EOL;
                }
                case 7: {
                    continue block12;
                }
                case 3: {
                    this.yybegin(0);
                    return SqlTokens.SQL_WHITE_SPACE;
                }
                case 8: {
                    continue block12;
                }
                case 4: {
                    this.yybegin(0);
                    return SqlTokens.SQL_UNCLOSED_TOKEN;
                }
                case 9: {
                    continue block12;
                }
                case 5: {
                    this.yybegin(0);
                    return SqlTokens.SQL_IDENT_DELIMITED;
                }
                case 10: {
                    continue block12;
                }
            }
            this.zzScanError(1);
        }
    }
}

