/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sybase;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.sybase.AseDdlParsing;
import com.intellij.sql.dialects.sybase.AseDialect;
import com.intellij.sql.dialects.sybase.AseDmlParsing;
import com.intellij.sql.dialects.sybase.AseElementTypes;
import com.intellij.sql.dialects.sybase.AseExpressionParsing;
import com.intellij.sql.dialects.sybase.AseGeneratedParser;
import com.intellij.sql.dialects.sybase.AseOptionalKeywords;
import com.intellij.sql.dialects.sybase.AsePlParsing;
import com.intellij.sql.psi.SqlReferenceElementType;
import org.jetbrains.annotations.Nullable;

public class AseParser
extends SqlParser {
    public AseParser() {
        super(AseDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    public void parseScriptDefault(PsiBuilder builder) {
        SqlGeneratedParserUtil.parseAsTree(builder, 0, SQL_DUMMY_BLOCK, false, new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder builder, int level) {
                return AseParser.this.parseBatchBlock(builder, AseElementTypes.Misc.ASE_BATCH_BLOCK, (b, l) -> GeneratedParserUtilBase.consumeToken((PsiBuilder)b, (IElementType)AseOptionalKeywords.ASE_GO), (b, l) -> b.getTokenType() != AseOptionalKeywords.ASE_GO);
            }
        }, GeneratedParserUtilBase.TRUE_CONDITION);
    }

    @Override
    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return AseGeneratedParser.parse_root_(root, builder, level);
    }

    @Override
    public boolean parseReferenceExpression(PsiBuilder builder, SqlReferenceElementType refType) {
        if (refType == SQL_PROCEDURE_REFERENCE) {
            return AsePlParsing.procedure_ref(builder, 0);
        }
        return super.parseReferenceExpression(builder, refType);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        boolean result2 = AseGeneratedParser.statement(builder, level);
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_SEMICOLON)) {
            this.statementSeparatorParsed(builder);
        }
        return result2;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, AseExpressionParsing::evaluable_expression);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return AseGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return AseDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return AseDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = AseExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error(DatabaseBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        return result2;
    }

    @Override
    protected boolean allowNoStatementSeparator() {
        return true;
    }

    @Override
    public boolean parseJdbcFunctionCallExpression(PsiBuilder builder, int level) {
        return AseExpressionParsing.possible_no_paren_function_call(builder, level);
    }

    @Override
    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType resultType) {
        String tokenText = builder.getTokenText();
        if (this.getLanguage().getSupportedFunctions().contains(tokenText)) {
            return false;
        }
        return super.parseParameterReferenceInner(builder, resultType);
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, AseExpressionParsing::parenthesized_values_expr, AseDmlParsing::top_query_expression, AseParser::parseTopQueryExpressionTail, AseExpressionParsing::row_element_list, (b, l) -> AseExpressionParsing.root_expr_0(b, l, -1) && AseExpressionParsing.row_element_list_separator(b, l) && AseExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, AseDmlParsing::parenthesized_aliased_join_expression, AseDmlParsing::top_query_expression, AseParser::parseTopQueryExpressionTail, (b, l) -> AseDmlParsing.join_expression(b, l, -1), (b, l) -> AseDmlParsing.join_expression_0(b, l, -1));
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return AseGeneratedParser.table_opt_column_list(builder, level);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        AseDmlParsing.query_expression_0(builder, level, -1);
        return AseDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

