/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.io.File;
import java.util.Objects;
import org.eclipse.aether.repository.ArtifactRepository;

public final class LocalRepository
implements ArtifactRepository {
    private final File basedir;
    private final String type;

    public LocalRepository(String basedir) {
        this(basedir != null ? new File(basedir) : null, "");
    }

    public LocalRepository(File basedir) {
        this(basedir, "");
    }

    public LocalRepository(File basedir, String type) {
        this.basedir = basedir;
        this.type = type != null ? type : "";
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    @Override
    public String getId() {
        return "local";
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String toString() {
        return this.getBasedir() + " (" + this.getContentType() + ")";
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null || !this.getClass().equals(obj2.getClass())) {
            return false;
        }
        LocalRepository that = (LocalRepository)obj2;
        return Objects.equals(this.basedir, that.basedir) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + LocalRepository.hash(this.basedir);
        hash = hash * 31 + LocalRepository.hash(this.type);
        return hash;
    }

    private static int hash(Object obj2) {
        return obj2 != null ? obj2.hashCode() : 0;
    }
}

