/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;

public class CoordinateList
extends ArrayList<Coordinate> {
    private static final long serialVersionUID = -1626110935756089896L;
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public CoordinateList() {
    }

    public CoordinateList(Coordinate[] coord) {
        this.ensureCapacity(coord.length);
        this.add(coord, true);
    }

    public CoordinateList(Coordinate[] coord, boolean allowRepeated) {
        this.ensureCapacity(coord.length);
        this.add(coord, allowRepeated);
    }

    public Coordinate getCoordinate(int i2) {
        return (Coordinate)this.get(i2);
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated, int start2, int end) {
        int inc = 1;
        if (start2 > end) {
            inc = -1;
        }
        for (int i2 = start2; i2 != end; i2 += inc) {
            this.add(coord[i2], allowRepeated);
        }
        return true;
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated, boolean direction) {
        if (direction) {
            for (int i2 = 0; i2 < coord.length; ++i2) {
                this.add(coord[i2], allowRepeated);
            }
        } else {
            for (int i3 = coord.length - 1; i3 >= 0; --i3) {
                this.add(coord[i3], allowRepeated);
            }
        }
        return true;
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated) {
        this.add(coord, allowRepeated, true);
        return true;
    }

    public boolean add(Object obj2, boolean allowRepeated) {
        this.add((Coordinate)obj2, allowRepeated);
        return true;
    }

    public void add(Coordinate coord, boolean allowRepeated) {
        Coordinate last;
        if (!allowRepeated && this.size() >= 1 && (last = (Coordinate)this.get(this.size() - 1)).equals2D(coord)) {
            return;
        }
        super.add(coord);
    }

    public void add(int i2, Coordinate coord, boolean allowRepeated) {
        int size;
        if (!allowRepeated && (size = this.size()) > 0) {
            Coordinate next;
            Coordinate prev2;
            if (i2 > 0 && (prev2 = (Coordinate)this.get(i2 - 1)).equals2D(coord)) {
                return;
            }
            if (i2 < size && (next = (Coordinate)this.get(i2)).equals2D(coord)) {
                return;
            }
        }
        super.add(i2, coord);
    }

    public boolean addAll(Collection<? extends Coordinate> coll, boolean allowRepeated) {
        boolean isChanged = false;
        Iterator<? extends Coordinate> i2 = coll.iterator();
        while (i2.hasNext()) {
            this.add(i2.next(), allowRepeated);
            isChanged = true;
        }
        return isChanged;
    }

    public void closeRing() {
        if (this.size() > 0) {
            Coordinate duplicate2 = ((Coordinate)this.get(0)).copy();
            this.add(duplicate2, false);
        }
    }

    public Coordinate[] toCoordinateArray() {
        return this.toArray(coordArrayType);
    }

    public Coordinate[] toCoordinateArray(boolean isForward) {
        if (isForward) {
            return this.toArray(coordArrayType);
        }
        int size = this.size();
        Coordinate[] pts = new Coordinate[size];
        for (int i2 = 0; i2 < size; ++i2) {
            pts[i2] = (Coordinate)this.get(size - i2 - 1);
        }
        return pts;
    }

    @Override
    public Object clone() {
        CoordinateList clone = (CoordinateList)super.clone();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            clone.add(i2, (Coordinate)((Coordinate)this.get(i2)).clone());
        }
        return clone;
    }
}

