/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.formatter;

import com.google.common.collect.ImmutableList;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.jinja.template.formatter.BlockIndex;
import com.intellij.jinja.template.formatter.MutableBlock;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableBlockWrapper
implements MutableBlock,
BlockEx {
    private final Block myOriginalBlock;
    private List<Block> mySubBlocks;
    private Indent myIndent;
    private Wrap myWrap;
    private TextRange myTextRange;

    public MutableBlockWrapper(@NotNull Block originalBlock) {
        if (originalBlock == null) {
            MutableBlockWrapper.$$$reportNull$$$0(0);
        }
        this.mySubBlocks = null;
        this.myIndent = null;
        this.myWrap = null;
        this.myTextRange = null;
        this.myOriginalBlock = originalBlock;
        this.myIndent = originalBlock.getIndent();
    }

    public MutableBlockWrapper(@NotNull Block originalBlock, @Nullable List<? extends Block> subBlocks) {
        if (originalBlock == null) {
            MutableBlockWrapper.$$$reportNull$$$0(1);
        }
        this.mySubBlocks = null;
        this.myIndent = null;
        this.myWrap = null;
        this.myTextRange = null;
        this.myOriginalBlock = originalBlock;
        this.mySubBlocks = ImmutableList.copyOf(subBlocks);
        this.myIndent = originalBlock.getIndent();
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myTextRange == null) {
            List<Block> subBlocks = this.getSubBlocks();
            this.myTextRange = !subBlocks.isEmpty() ? new TextRange(subBlocks.get(0).getTextRange().getStartOffset(), subBlocks.get(subBlocks.size() - 1).getTextRange().getEndOffset()) : this.myOriginalBlock.getTextRange();
        }
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            MutableBlockWrapper.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks != null) {
            List<Block> list2 = this.mySubBlocks;
            if (list2 == null) {
                MutableBlockWrapper.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List list3 = this.myOriginalBlock.getSubBlocks();
        if (list3 == null) {
            MutableBlockWrapper.$$$reportNull$$$0(4);
        }
        return list3;
    }

    public Wrap getWrap() {
        if (this.myWrap != null) {
            return this.myWrap;
        }
        return this.myOriginalBlock.getWrap();
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public Alignment getAlignment() {
        return this.myOriginalBlock.getAlignment();
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            MutableBlockWrapper.$$$reportNull$$$0(5);
        }
        Block origBlock1 = MutableBlockWrapper.getOriginal(child1);
        Block origBlock2 = MutableBlockWrapper.getOriginal(child2);
        return this.myOriginalBlock.getSpacing(origBlock1, origBlock2);
    }

    private static Block getOriginal(Block child1) {
        Block origBlock1 = child1 instanceof MutableBlockWrapper ? ((MutableBlockWrapper)child1).getOriginalBlock() : child1;
        return origBlock1;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Alignment alignment = this.myOriginalBlock.getChildAttributes(newChildIndex).getAlignment();
        return new ChildAttributes(Indent.getNoneIndent(), alignment);
    }

    public boolean isIncomplete() {
        return this.myOriginalBlock.isIncomplete();
    }

    public boolean isLeaf() {
        return this.myOriginalBlock.isLeaf();
    }

    @Override
    public void setSubBlocks(List<Block> subBlocks) {
        this.mySubBlocks = subBlocks;
    }

    @Override
    public void setIndent(Indent indent) {
        this.myIndent = indent;
    }

    @Override
    public void setWrap(Wrap wrap2) {
        this.myWrap = wrap2;
    }

    @Override
    public void dropCaches() {
        this.myTextRange = null;
    }

    public static MutableBlockWrapper substitute(@NotNull Block block, @NotNull BlockIndex index) {
        if (block == null) {
            MutableBlockWrapper.$$$reportNull$$$0(6);
        }
        if (index == null) {
            MutableBlockWrapper.$$$reportNull$$$0(7);
        }
        MutableBlockWrapper wrapper = new MutableBlockWrapper(block);
        index.replace(block, wrapper);
        index.updateParent(wrapper, index.getParent(block));
        index.updateParent(block, null);
        return wrapper;
    }

    public static MutableBlock adapt(Block block, BlockIndex index) {
        if (block instanceof MutableBlock) {
            return (MutableBlock)block;
        }
        return MutableBlockWrapper.substitute(block, index);
    }

    public Block getOriginalBlock() {
        return this.myOriginalBlock;
    }

    @Nullable
    public Language getLanguage() {
        if (this.myOriginalBlock instanceof BlockEx) {
            return ((BlockEx)this.myOriginalBlock).getLanguage();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/template/formatter/MutableBlockWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/template/formatter/MutableBlockWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

