/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.debugger.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.python.PythonHelpersLocator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0017J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0003J\b\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/pro/debugger/utils/PythonProHelpersLocator;", "Lcom/jetbrains/python/PythonHelpersLocator;", "<init>", "()V", "getRoot", "Ljava/nio/file/Path;", "getHelpersRoot", "moduleName", "", "relativePath", "assertHelpersProLayout", "root", "getExpectedHelpersProRootLocation", "Companion", "intellij.python"})
public final class PythonProHelpersLocator
implements PythonHelpersLocator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXPECTED_PRO_HELPER_PACKAGE = "jupyter_debug";

    @Nullable
    public Path getRoot() {
        return this.assertHelpersProLayout(this.getExpectedHelpersProRootLocation()).normalize();
    }

    @RequiresBackgroundThread
    @NotNull
    public Path getHelpersRoot(@NotNull String moduleName, @NotNull String relativePath) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        if (Intrinsics.areEqual((Object)moduleName, (Object)"intellij.python.helpers")) {
            path2 = super.getHelpersRoot(moduleName, relativePath);
        } else {
            String string = PathUtil.getJarPathForClass(PythonProHelpersLocator.class);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJarPathForClass(...)");
            path2 = this.findRootByJarPath(string, moduleName, relativePath);
        }
        return path2;
    }

    @RequiresBackgroundThread
    private final Path assertHelpersProLayout(Path root) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        PythonHelpersLocator.Companion.getLOG().assertTrue(Files.exists(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length)), (Object)("Helpers pro root does not exist " + root));
        Logger logger2 = PythonHelpersLocator.Companion.getLOG();
        Path path2 = root.resolve(EXPECTED_PRO_HELPER_PACKAGE);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        logger2.assertTrue(Files.exists(path3, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)), (Object)("No 'jupyter_debug' inside " + root));
        return root;
    }

    private final Path getExpectedHelpersProRootLocation() {
        return this.getHelpersRoot("intellij.python.helpers.pro", "/../python/helpers-pro");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/pro/debugger/utils/PythonProHelpersLocator$Companion;", "", "<init>", "()V", "EXPECTED_PRO_HELPER_PACKAGE", "", "intellij.python"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

