/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.lines;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.python.profiler.PythonProfilerBundle;
import com.intellij.python.profiler.lines.HideProfileInfoAction;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileLineMarkerRenderer
implements ActiveGutterRenderer,
LineMarkerRendererWithErrorStripe {
    private static final int THICKNESS = 8;
    private final int myLineNumer;
    private final TreeMap<Integer, LineData> myLines;
    private final Function<? super Integer, Integer> myNewToOldConverter;
    private final boolean mySubCoverageActive;

    protected ProfileLineMarkerRenderer(int lineNumer, TreeMap<Integer, LineData> lines, Function<? super Integer, Integer> newToOldConverter, boolean subCoverageActive) {
        this.myLineNumer = lineNumer;
        this.myLines = lines;
        this.myNewToOldConverter = newToOldConverter;
        this.mySubCoverageActive = subCoverageActive;
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        if (editor == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(0);
        }
        if (g == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(1);
        }
        if (r == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(2);
        }
        if (this.myLines.isEmpty()) {
            return;
        }
        TextAttributes attrs = ProfileLineMarkerRenderer.getTextAttributes(this.myLineNumer, this.myLines, editor);
        Color bgColor = attrs.getBackgroundColor();
        if (bgColor == null) {
            bgColor = attrs.getForegroundColor();
        }
        if ((editor.getSettings().isLineNumbersShown() || editor.getGutter().isAnnotationsShown()) && bgColor != null) {
            bgColor = ColorUtil.toAlpha((Color)bgColor, (int)150);
        }
        if (bgColor != null) {
            g.setColor(bgColor);
        }
        g.fillRect(r.x, r.y, r.width, r.height);
        LineData lineData = this.getLineData(editor.xyToLogicalPosition((Point)new Point((int)0, (int)r.y)).line);
        if (lineData != null && lineData.isCoveredByOneTest()) {
            AllIcons.Gutter.Unique.paintIcon(editor.getComponent(), g, r.x, r.y);
        }
    }

    private static TextAttributes getTextAttributes(int line2, TreeMap<Integer, LineData> lines, Editor editor) {
        TextAttributes attrs = editor.getColorsScheme().getAttributes(ProfileLineMarkerRenderer.getAttributesKey());
        int maxHits = 1;
        for (LineData d : lines.values()) {
            if (maxHits >= d.getHits()) continue;
            maxHits = d.getHits();
        }
        attrs = attrs.clone();
        attrs.setBackgroundColor(ProfileLineMarkerRenderer.colorIntensity(lines.get(line2).getHits(), maxHits));
        return attrs;
    }

    private static Color colorIntensity(int hits, int totalHits) {
        double power = 1.0 - 1.0 * (double)hits / (double)totalHits;
        double H = power * 0.15;
        double S = 0.8;
        double B = 1.0;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    public static ProfileLineMarkerRenderer getRenderer(int lineNumber, TreeMap<Integer, LineData> lines, Function<? super Integer, Integer> newToOldConverter, boolean subCoverageActive) {
        return new ProfileLineMarkerRenderer(lineNumber, lines, newToOldConverter, subCoverageActive);
    }

    private static TextAttributesKey getAttributesKey() {
        return CodeInsightColors.LINE_FULL_COVERAGE;
    }

    public boolean canDoAction(@NotNull MouseEvent e) {
        Component component2;
        if (e == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(3);
        }
        if ((component2 = e.getComponent()) instanceof EditorGutterComponentEx) {
            EditorGutterComponentEx gutter = (EditorGutterComponentEx)component2;
            return e.getX() > gutter.getLineMarkerAreaOffset() && e.getX() < gutter.getIconAreaOffset();
        }
        return false;
    }

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        if (editor == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(4);
        }
        if (e == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(5);
        }
        e.consume();
        JComponent comp = (JComponent)e.getComponent();
        JRootPane rootPane = comp.getRootPane();
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        Point point2 = SwingUtilities.convertPoint(comp, 8, e.getY(), layeredPane);
        this.showHint(editor, point2, editor.xyToLogicalPosition((Point)e.getPoint()).line);
    }

    private void showHint(Editor editor, Point point2, int lineNumber) {
        EditorImpl uEditor;
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createActionsToolbar(editor, lineNumber), "North");
        LineData lineData = this.getLineData(lineNumber);
        if (lineData != null && lineData.getStatus() != 0) {
            EditorFactory factory2 = EditorFactory.getInstance();
            Document doc = factory2.createDocument((CharSequence)this.getReport(editor, lineNumber));
            doc.setReadOnly(true);
            uEditor = (EditorImpl)factory2.createEditor(doc, editor.getProject());
            panel.add((Component)EditorFragmentComponent.createEditorFragmentComponent((Editor)uEditor, (int)0, (int)doc.getLineCount(), (boolean)false, (boolean)false), "Center");
        } else {
            uEditor = null;
        }
        LightweightHint hint = new LightweightHint(panel){

            public void hide() {
                if (uEditor != null) {
                    EditorFactory.getInstance().releaseEditor((Editor)uEditor);
                }
                super.hide();
            }
        };
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point2, 58, -1, false, new HintHint(editor, point2));
    }

    private String getReport(Editor editor, int lineNumber) {
        LineData lineData = this.getLineData(lineNumber);
        Document document = editor.getDocument();
        Project project = editor.getProject();
        assert (project != null);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        assert (psiFile != null);
        return this.generateBriefReport(lineData);
    }

    private String generateBriefReport(LineData data) {
        int totalHits = 0;
        for (LineData d : this.myLines.values()) {
            totalHits += d.getHits();
        }
        int hits = data.getHits();
        return "Line " + data.getLineNumber() + ": " + 100 * hits / totalHits + "% (" + hits + " of " + totalHits + ") hits";
    }

    protected JComponent createActionsToolbar(Editor editor, int lineNumber) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new HideProfileInfoAction());
        LineData lineData = this.getLineData(lineNumber);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)group2, true);
        JComponent toolbarComponent = toolbar.getComponent();
        Color background = ((EditorEx)editor).getBackgroundColor();
        Color foreground = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        toolbarComponent.setBackground(background);
        toolbarComponent.setBorder((Border)new ColoredSideBorder(foreground, foreground, lineData == null || lineData.getStatus() == 0 || this.mySubCoverageActive ? foreground : null, foreground, 1));
        return toolbarComponent;
    }

    @Nullable
    public LineData getLineData(int lineNumber) {
        return this.myLines != null ? this.myLines.get(this.myNewToOldConverter != null ? this.myNewToOldConverter.apply((Integer)lineNumber) : lineNumber) : null;
    }

    public Color getErrorStripeColor(Editor editor) {
        return ProfileLineMarkerRenderer.getTextAttributes(this.myLineNumer, this.myLines, editor).getErrorStripeColor();
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.LEFT;
        if (position == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(6);
        }
        return position;
    }

    @NotNull
    public String getAccessibleName() {
        String string = PythonProfilerBundle.message("python.profile.line.marker.accessible.name", new Object[0]);
        if (string == null) {
            ProfileLineMarkerRenderer.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/profiler/lines/ProfileLineMarkerRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/profiler/lines/ProfileLineMarkerRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

