/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.templateLanguages;

import com.intellij.execution.ExecutionException;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.template.lang.core.templateLanguages.PyTemplatesCoreUtil;
import com.intellij.template.lang.core.templateLanguages.PythonTemplateLanguage;
import com.intellij.template.lang.core.templateLanguages.TemplateSettingsHolder;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTemplatesUtil
extends PyTemplatesCoreUtil {
    private PyTemplatesUtil() {
    }

    @NotNull
    @ApiStatus.Internal
    public static Collection<String> getPackagesToInstall(@NotNull PythonTemplateLanguage language, @NotNull Sdk sdk, @NotNull String prefix) {
        if (language == null) {
            PyTemplatesUtil.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyTemplatesUtil.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            PyTemplatesUtil.$$$reportNull$$$0(2);
        }
        List packages = PyPackageUtil.refreshAndGetPackagesModally((Sdk)sdk);
        String languageName = language.getTemplateLanguageName().toLowerCase(Locale.ENGLISH);
        HashSet<String> packageNames = new HashSet<String>(Collections.singleton(languageName));
        String binding = prefix + languageName;
        if (TemplatesService.ALL_TEMPLATE_BINDINGS.contains(binding)) {
            packageNames.add(binding);
        }
        List<String> list2 = packageNames.stream().filter(p -> PyPsiPackageUtil.findPackage((List)packages, (String)p) == null).toList();
        if (list2 == null) {
            PyTemplatesUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    public static ValidationResult checkInstalled(@Nullable Sdk sdk, @Nullable PythonTemplateLanguage language, @NotNull String prefix) {
        if (prefix == null) {
            PyTemplatesUtil.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            return ValidationResult.OK;
        }
        if (language == null) {
            return null;
        }
        Iterator<String> iterator2 = PyTemplatesUtil.getPackagesToInstall(language, sdk, prefix).iterator();
        if (iterator2.hasNext()) {
            String pyPackage = iterator2.next();
            return new ValidationResult(PyBundle.message((String)"python.package.installation.notification.message", (Object[])new Object[]{pyPackage}));
        }
        return null;
    }

    public static void installTemplateEngine(@NotNull TemplateSettingsHolder settings, @NotNull Sdk sdk, @NotNull Project project, @NotNull String prefix) {
        PythonTemplateLanguage language;
        if (settings == null) {
            PyTemplatesUtil.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            PyTemplatesUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PyTemplatesUtil.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            PyTemplatesUtil.$$$reportNull$$$0(8);
        }
        if ((language = settings.getTemplateLanguage()) == null) {
            return;
        }
        PyPackageManager packageManager = PyPackageManager.getInstance((Sdk)sdk);
        for (String pyPackage : PyTemplatesUtil.getPackagesToInstall(language, sdk, prefix)) {
            PyTemplatesUtil.installPackage(packageManager, project, pyPackage);
        }
    }

    private static void installPackage(final PyPackageManager packageManager, Project project, final String packageToInstall) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PythonProBundle.message((String)"python.template.installing.progress", (Object[])new Object[]{packageToInstall}), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(PythonProBundle.message((String)"python.template.installing.title", (Object[])new Object[]{packageToInstall}));
                try {
                    packageManager.install(packageToInstall);
                    packageManager.refresh();
                }
                catch (ExecutionException e) {
                    ApplicationManager.getApplication().invokeLater(() -> PackagesNotificationPanel.showError((String)PythonProBundle.message((String)"python.package.installation.failed.title", (Object[])new Object[]{packageToInstall}), (PackageManagementService.ErrorDescription)PackageManagementService.ErrorDescription.fromMessage((String)e.toString())));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/python/templateLanguages/PyTemplatesUtil$1", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/templateLanguages/PyTemplatesUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/templateLanguages/PyTemplatesUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesToInstall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesToInstall";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkInstalled";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installTemplateEngine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

