/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.wsl.PyWSLProcessHandler;
import com.intellij.python.wsl.PyWSLSocketProvider;
import com.intellij.python.wsl.PythonWslBundle;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.PathMappingSettings;
import com.intellij.wsl.remoteSdk.WSLCredentialsHolder;
import com.intellij.wsl.remoteSdk.WSLCredentialsType;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.Result;
import com.jetbrains.python.extensions.ProgressManagerExtKt;
import com.jetbrains.python.remote.PyRemoteCommandLinePatcherKt;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001d\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00040\u0001*\u00020\rH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0003*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0003H\u0000\u001a@\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\t2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001e\u001a\u00020\tH\u0000\u001a\u001a\u0010\u001f\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\rH\u0000\u001aY\u0010'\u001a\u001f\u0012\u0004\u0012\u00020\u0003\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\"\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b#0!0\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0001\u0010(\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\r2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*2\b\b\u0002\u0010\u001e\u001a\u00020\tH\u0002\u001a@\u0010+\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\t2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001e\u001a\u00020\tH\u0002\"+\u0010\u0000\u001a\u0015\u0012\u0004\u0012\u00020\u0002\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0018\u00010\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\"\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0018\u0010\b\u001a\u00020\t*\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0013\"\u0018\u0010\b\u001a\u00020\t*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0014\"5\u0010 \u001a\u001f\u0012\u0004\u0012\u00020\u0003\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\"\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b#0!0\u0001*\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u0017\u0010-\u001a\u0004\u0018\u00010\u0002*\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00061"}, d2={"distribution", "Lcom/jetbrains/python/Result;", "Lcom/intellij/execution/wsl/WSLDistribution;", "", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/openapi/projectRoots/Sdk;", "getDistribution", "(Lcom/intellij/openapi/projectRoots/Sdk;)Lcom/jetbrains/python/Result;", "isWsl", "", "(Lcom/intellij/openapi/projectRoots/Sdk;)Z", "wslCredentials", "Lcom/intellij/wsl/remoteSdk/WSLCredentialsHolder;", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "getWslCredentials", "(Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;)Lcom/intellij/wsl/remoteSdk/WSLCredentialsHolder;", "toRemotePath", "localPath", "Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;", "(Lcom/jetbrains/python/target/PyTargetAwareAdditionalData;)Z", "(Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;)Z", "startWslProcess", "Lcom/intellij/python/wsl/PyWSLProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sdkAdditionalData", "sudo", "remoteWorkDir", "patchExe", "isWsl1", "result", "Lkotlin/Pair;", "", "Lorg/jetbrains/annotations/NonNls;", "Lcom/intellij/execution/process/ProcessOutput;", "getResult", "(Lcom/intellij/execution/process/ProcessOutput;)Lcom/jetbrains/python/Result;", "getWslOutput", "title", "command", "", "startWslProcessImpl", "sdkData", "distroThisModuleResidesOn", "Lcom/intellij/openapi/module/Module;", "getDistroThisModuleResidesOn", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/execution/wsl/WSLDistribution;", "intellij.python.wsl"})
@SourceDebugExtension(value={"SMAP\nPyWSLUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyWSLUtils.kt\ncom/intellij/python/wsl/PyWSLUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1557#2:170\n1628#2,3:171\n216#3,2:174\n1#4:176\n*S KotlinDebug\n*F\n+ 1 PyWSLUtils.kt\ncom/intellij/python/wsl/PyWSLUtilsKt\n*L\n142#1:170\n142#1:171,3\n144#1:174,2\n*E\n"})
public final class PyWSLUtilsKt {
    @Nullable
    public static final Result<WSLDistribution, String> getDistribution(@NotNull Sdk $this$distribution) {
        Intrinsics.checkNotNullParameter((Object)$this$distribution, (String)"<this>");
        SdkAdditionalData sdkAdditionalData = $this$distribution.getSdkAdditionalData();
        PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase = sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase ? (PyRemoteSdkAdditionalDataBase)sdkAdditionalData : null;
        return pyRemoteSdkAdditionalDataBase != null ? PyWSLUtilsKt.getDistribution(pyRemoteSdkAdditionalDataBase) : null;
    }

    public static final boolean isWsl(@NotNull Sdk $this$isWsl) {
        Intrinsics.checkNotNullParameter((Object)$this$isWsl, (String)"<this>");
        SdkAdditionalData data = $this$isWsl.getSdkAdditionalData();
        return data instanceof PyRemoteSdkAdditionalData ? PyWSLUtilsKt.isWsl((PyRemoteSdkAdditionalDataBase)data) : (data instanceof PyTargetAwareAdditionalData ? PyWSLUtilsKt.isWsl((PyTargetAwareAdditionalData)data) : false);
    }

    @Nullable
    public static final WSLCredentialsHolder getWslCredentials(@NotNull PyRemoteSdkAdditionalDataBase $this$wslCredentials) {
        Intrinsics.checkNotNullParameter((Object)$this$wslCredentials, (String)"<this>");
        Object object = $this$wslCredentials.connectionCredentials().getCredentials();
        return object instanceof WSLCredentialsHolder ? (WSLCredentialsHolder)object : null;
    }

    @NotNull
    public static final Result<WSLDistribution, String> getDistribution(@NotNull PyRemoteSdkAdditionalDataBase $this$getDistribution) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)$this$getDistribution, (String)"<this>");
        WSLCredentialsHolder wSLCredentialsHolder = PyWSLUtilsKt.getWslCredentials($this$getDistribution);
        if (wSLCredentialsHolder != null) {
            WSLCredentialsHolder it = wSLCredentialsHolder;
            boolean bl = false;
            result2 = (Result)new Result.Success((Object)it.getDistribution());
        } else {
            result2 = (Result)new Result.Failure((Object)PythonWslBundle.message("wsl.remote.type.expected", new Object[0]));
        }
        return result2;
    }

    @NotNull
    public static final String toRemotePath(@NotNull WSLDistribution $this$toRemotePath, @NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toRemotePath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        char[] cArray = new char[]{File.pathSeparatorChar};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)localPath, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)":", null, null, (int)0, null, arg_0 -> PyWSLUtilsKt.toRemotePath$lambda$1($this$toRemotePath, arg_0), (int)30, null);
    }

    public static final boolean isWsl(@NotNull PyTargetAwareAdditionalData $this$isWsl) {
        Intrinsics.checkNotNullParameter((Object)$this$isWsl, (String)"<this>");
        return $this$isWsl.getTargetEnvironmentConfiguration() instanceof WslTargetEnvironmentConfiguration;
    }

    public static final boolean isWsl(@NotNull PyRemoteSdkAdditionalDataBase $this$isWsl) {
        Intrinsics.checkNotNullParameter((Object)$this$isWsl, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isWsl.getRemoteConnectionType(), (Object)WSLCredentialsType.getInstance());
    }

    @NotNull
    public static final PyWSLProcessHandler startWslProcess(@Nullable Project project, @NotNull GeneralCommandLine commandLine, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, boolean sudo, @Nullable String remoteWorkDir, boolean patchExe) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)sdkAdditionalData, (String)"sdkAdditionalData");
        return PyWSLUtilsKt.startWslProcessImpl(project, commandLine, sdkAdditionalData, sudo, remoteWorkDir, patchExe);
    }

    public static /* synthetic */ PyWSLProcessHandler startWslProcess$default(Project project, GeneralCommandLine generalCommandLine, PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase, boolean bl, String string, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return PyWSLUtilsKt.startWslProcess(project, generalCommandLine, pyRemoteSdkAdditionalDataBase, bl, string, bl2);
    }

    public static final boolean isWsl1(@Nullable Project project, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData) {
        Intrinsics.checkNotNullParameter((Object)sdkAdditionalData, (String)"sdkAdditionalData");
        String string = PythonWslBundle.message("wsl.obtain_version", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new String[]{"uname", "-v"};
        String string2 = (String)PyWSLUtilsKt.getWslOutput$default(project, string, sdkAdditionalData, CollectionsKt.listOf((Object[])objectArray), false, 16, null).getSuccessOrNull();
        return string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"Microsoft", (boolean)false, (int)2, null) : true;
    }

    private static final Result<String, Pair<Integer, String>> getResult(ProcessOutput $this$result) {
        return $this$result.getExitCode() == 0 ? (Result)new Result.Success((Object)$this$result.getStdout()) : (Result)new Result.Failure((Object)new Pair((Object)$this$result.getExitCode(), (Object)$this$result.getStderr()));
    }

    private static final Result<String, Pair<Integer, String>> getWslOutput(Project project, @NlsContexts.DialogTitle String title, PyRemoteSdkAdditionalDataBase sdkAdditionalData, List<String> command, boolean patchExe) {
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        return (Result)ProgressManagerExtKt.runUnderProgress((ProgressManager)progressManager, (String)title, () -> PyWSLUtilsKt.getWslOutput$lambda$2(project, command, sdkAdditionalData, patchExe));
    }

    static /* synthetic */ Result getWslOutput$default(Project project, String string, PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase, List list2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return PyWSLUtilsKt.getWslOutput(project, string, pyRemoteSdkAdditionalDataBase, list2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final PyWSLProcessHandler startWslProcessImpl(Project project, GeneralCommandLine commandLine, PyRemoteSdkAdditionalDataBase sdkData, boolean sudo, String remoteWorkDir, boolean patchExe) {
        void $this$startWslProcessImpl_u24lambda_u249;
        String string;
        File it;
        Object object;
        Iterator iterator2;
        ParametersList parametersList;
        Object params;
        Result<WSLDistribution, String> it2 = PyWSLUtilsKt.getDistribution(sdkData);
        boolean bl = false;
        Result<WSLDistribution, String> result2 = it2;
        if (!(result2 instanceof Result.Success)) {
            if (result2 instanceof Result.Failure) {
                throw new ExecutionException((String)((Result.Failure)it2).getError());
            }
            throw new NoWhenBranchMatchedException();
        }
        WSLDistribution distribution = (WSLDistribution)((Result.Success)it2).getResult();
        PyRemotePathMapper pyRemotePathMapper = PyRemotePathMapper.fromSettings((PathMappingSettings)sdkData.getPathMappings(), (PyRemotePathMapper.PyPathMappingType)PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
        Intrinsics.checkNotNullExpressionValue((Object)pyRemotePathMapper, (String)"fromSettings(...)");
        PyRemotePathMapper mapper = pyRemotePathMapper;
        PyWSLSocketProvider socketProvider = new PyWSLSocketProvider(project, sdkData);
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        String string2 = PythonWslBundle.message("wsl.prepare", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        ProgressManagerExtKt.runUnderProgress((ProgressManager)progressManager, (String)string2, () -> PyWSLUtilsKt.startWslProcessImpl$lambda$4(distribution, commandLine, sdkData, socketProvider, mapper));
        if (patchExe) {
            commandLine.setExePath(sdkData.getInterpreterPath());
        }
        for (ParamsGroup group2 : commandLine.getParametersList().getParamsGroups()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            params = new ArrayList(group2.getParameters());
            group2.getParametersList().clearAll();
            Iterable iterable = (Iterable)params;
            parametersList = group2.getParametersList();
            boolean $i$f$map = false;
            void var14_21 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it3;
                Object item$iv$iv = iterator2.next();
                String string3 = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it3);
                object.add(PyWSLUtilsKt.toRemotePath(distribution, (String)it3));
            }
            parametersList.addAll((List)destination$iv$iv);
        }
        Map map2 = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironment(...)");
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach22 = false;
        params = $this$forEach$iv.entrySet().iterator();
        while (params.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $i$f$map = element$iv = (Map.Entry)params.next();
            boolean bl3 = false;
            String k = (String)$i$f$map.getKey();
            String v = (String)$i$f$map.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)commandLine.getEnvironment(), (String)"getEnvironment(...)");
            Intrinsics.checkNotNull((Object)v);
            String string4 = PyWSLUtilsKt.toRemotePath(distribution, v);
            iterator2.put(k, string4);
        }
        File file = commandLine.getWorkDirectory();
        if (file != null) {
            it = file;
            boolean bl4 = false;
            String string5 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
            if (StringsKt.startsWith$default((String)string5, (String)"/", (boolean)false, (int)2, null)) {
                String string6 = distribution.getWindowsPath(it.getPath());
                if (string6 == null) {
                    string6 = it.getPath();
                }
                commandLine.setWorkDirectory(new File(string6));
            }
        }
        if ((string = remoteWorkDir) == null) {
            Object object2 = commandLine.getWorkDirectory();
            if (object2 != null && (object2 = ((File)object2).toString()) != null) {
                Object it4 = object2;
                boolean bl5 = false;
                string = PyWSLUtilsKt.toRemotePath(distribution, (String)it4);
            } else {
                string = null;
            }
        }
        String effectiveRemoteWorkDir = string;
        WSLCommandLineOptions $i$f$forEach22 = new WSLCommandLineOptions();
        it = $i$f$forEach22;
        Project project2 = project;
        object = commandLine;
        parametersList = distribution;
        boolean bl6 = false;
        $this$startWslProcessImpl_u24lambda_u249.setSudo(sudo);
        $this$startWslProcessImpl_u24lambda_u249.setRemoteWorkingDirectory(effectiveRemoteWorkDir);
        Unit unit = Unit.INSTANCE;
        parametersList.patchCommandLine((GeneralCommandLine)object, project2, $i$f$forEach22);
        PathMappingSettings pathMappingSettings = sdkData.getPathMappings();
        Intrinsics.checkNotNullExpressionValue((Object)pathMappingSettings, (String)"getPathMappings(...)");
        PyWSLProcessHandler pyWSLProcessHandler = new PyWSLProcessHandler(commandLine, socketProvider, distribution, pathMappingSettings);
        PyRemoteInterpreterUtil.closeOnProcessTermination((ProcessHandler)((ProcessHandler)pyWSLProcessHandler), (Closeable)((Closeable)((Object)socketProvider)));
        ProcessHandler processHandler = distribution.patchProcessHandler(commandLine, (ProcessHandler)pyWSLProcessHandler);
        Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"patchProcessHandler(...)");
        return (PyWSLProcessHandler)processHandler;
    }

    static /* synthetic */ PyWSLProcessHandler startWslProcessImpl$default(Project project, GeneralCommandLine generalCommandLine, PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalDataBase, boolean bl, String string, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return PyWSLUtilsKt.startWslProcessImpl(project, generalCommandLine, pyRemoteSdkAdditionalDataBase, bl, string, bl2);
    }

    @Nullable
    public static final WSLDistribution getDistroThisModuleResidesOn(@NotNull Module $this$distroThisModuleResidesOn) {
        Intrinsics.checkNotNullParameter((Object)$this$distroThisModuleResidesOn, (String)"<this>");
        VirtualFile[] virtualFileArray = BasePySdkExtKt.getRootManager((Module)$this$distroThisModuleResidesOn).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        return (WSLDistribution)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])virtualFileArray), PyWSLUtilsKt::_get_distroThisModuleResidesOn_$lambda$10));
    }

    private static final CharSequence toRemotePath$lambda$1(WSLDistribution $this_toRemotePath, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $this_toRemotePath.getWslPath(it);
        return string != null ? (CharSequence)string : (CharSequence)it;
    }

    private static final Result getWslOutput$lambda$2(Project $project, List $command, PyRemoteSdkAdditionalDataBase $sdkAdditionalData, boolean $patchExe) {
        ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)PyWSLUtilsKt.startWslProcessImpl$default($project, new GeneralCommandLine($command), $sdkAdditionalData, false, null, $patchExe, 16, null)).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return PyWSLUtilsKt.getResult(processOutput);
    }

    private static final Unit startWslProcessImpl$lambda$4(WSLDistribution $distribution, GeneralCommandLine $commandLine, PyRemoteSdkAdditionalDataBase $sdkData, PyWSLSocketProvider $socketProvider, PyRemotePathMapper $mapper) {
        try {
            String helpersPath = PyWSLUtilsKt.toRemotePath($distribution, ((Object)PythonHelpersLocator.Companion.getCommunityHelpersRoot().toAbsolutePath()).toString());
            String string = $sdkData.getInterpreterPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInterpreterPath(...)");
            PyRemoteCommandLinePatcherKt.patchRemoteCommandLineIfNeeded((GeneralCommandLine)$commandLine, (String)string, (String)helpersPath, (PyRemoteSocketToLocalHostProvider)$socketProvider, (PyRemotePathMapper)$mapper);
        }
        catch (RemoteSdkException ex) {
            Logger.getInstance(PyWSLProcessHandler.class).warn((Throwable)ex);
        }
        return Unit.INSTANCE;
    }

    private static final WSLDistribution _get_distroThisModuleResidesOn_$lambda$10(VirtualFile it) {
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        WslPath wslPath = WslPath.Companion.parseWindowsUncPath(string);
        return wslPath != null ? wslPath.getDistribution() : null;
    }
}

