/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.colorspace;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.colorspace.LUV;
import org.jetbrains.letsPlot.commons.colorspace.XYZ;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u00a8\u0006\u0006"}, d2={"luvFromXyz", "Lorg/jetbrains/letsPlot/commons/colorspace/LUV;", "xyz", "Lorg/jetbrains/letsPlot/commons/colorspace/XYZ;", "xyzFromLuv", "luv", "commons"})
public final class LUVKt {
    @NotNull
    public static final XYZ xyzFromLuv(@NotNull LUV luv) {
        Intrinsics.checkNotNullParameter((Object)luv, (String)"luv");
        if (luv.getL() == 0.0) {
            return new XYZ(0.0, 0.0, 0.0);
        }
        double l = (luv.getL() + 16.0) / 116.0;
        double preY = Math.pow(l, 3) > 0.008856 ? Math.pow(l, 3) : (l - 0.13793103448275862) / 7.787;
        double refDen = 1921.696;
        double refU = 380.188 / refDen;
        double refV = 900.0 / refDen;
        double u = luv.getU() / (13.0 * luv.getL()) + refU;
        double v = luv.getV() / (13.0 * luv.getL()) + refV;
        double y2 = preY * 100.0;
        double x2 = -(9.0 * y2 * u) / ((u - 4.0) * v - u * v);
        double z = (9.0 * y2 - 15.0 * v * y2 - v * x2) / (3.0 * v);
        return new XYZ(x2, y2, z);
    }

    @NotNull
    public static final LUV luvFromXyz(@NotNull XYZ xyz) {
        Intrinsics.checkNotNullParameter((Object)xyz, (String)"xyz");
        double inputDen = xyz.getX() + 15.0 * xyz.getY() + 3.0 * xyz.getZ();
        double preU = inputDen == 0.0 ? 0.0 : (double)4 * xyz.getX() / inputDen;
        double preV = inputDen == 0.0 ? 0.0 : (double)9 * xyz.getY() / inputDen;
        double y2 = xyz.getY() / 100.0;
        double preL = y2 > 0.008856 ? Math.cbrt(y2) : 7.787 * y2 + 0.13793103448275862;
        double refDen = 1921.696;
        double refU = 380.188 / refDen;
        double refV = 900.0 / refDen;
        double l = 116.0 * preL - 16.0;
        double u = 13.0 * l * (preU - refU);
        double v = 13.0 * l * (preV - refV);
        return new LUV(RangesKt.coerceIn((double)l, (double)0.0, (double)100.0), u, v);
    }
}

