/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.event.MouseEventPeer;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.commons.values.SomeFig;
import org.jetbrains.letsPlot.core.interact.event.ToolEventDispatcher;
import org.jetbrains.letsPlot.core.interact.event.UnsupportedToolEventDispatcher;
import org.jetbrains.letsPlot.core.plot.builder.PlotInteractor;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgComponent;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgRoot;
import org.jetbrains.letsPlot.core.plot.builder.interact.PlotToolEventDispatcher;
import org.jetbrains.letsPlot.core.plot.builder.interact.toolbox.PlotToolbox;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotContainer;", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "svgRoot", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgRoot;", "(Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgRoot;)V", "isLiveMap", "", "()Z", "liveMapFigures", "", "Lorg/jetbrains/letsPlot/commons/values/SomeFig;", "getLiveMapFigures", "()Ljava/util/List;", "mouseEventPeer", "Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;", "getMouseEventPeer", "()Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;", "plot", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgComponent;", "registrations", "Lorg/jetbrains/letsPlot/commons/registration/CompositeRegistration;", "svg", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "getSvg", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "getSvgRoot", "()Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgRoot;", "toolEventDispatcher", "Lorg/jetbrains/letsPlot/core/interact/event/ToolEventDispatcher;", "getToolEventDispatcher", "()Lorg/jetbrains/letsPlot/core/interact/event/ToolEventDispatcher;", "dispose", "", "Companion", "plot-builder"})
public final class PlotContainer
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotSvgRoot svgRoot;
    @NotNull
    private final PlotSvgComponent plot;
    @NotNull
    private CompositeRegistration registrations;
    @NotNull
    private final ToolEventDispatcher toolEventDispatcher;

    public PlotContainer(@NotNull PlotSvgRoot svgRoot) {
        Intrinsics.checkNotNullParameter((Object)svgRoot, (String)"svgRoot");
        this.svgRoot = svgRoot;
        this.plot = this.svgRoot.getPlot();
        this.registrations = new CompositeRegistration(new Registration[0]);
        if (this.plot.getInteractionsEnabled()) {
            PlotInteractor plotInteractor = new PlotInteractor(this.svgRoot.getDecorationLayer(), this.getMouseEventPeer(), this.plot.getFigureSize(), this.plot.getFlippedAxis(), this.plot.getTheme(), this.plot.getPlotContext());
            this.plot.setInteractor$plot_builder(plotInteractor);
            this.toolEventDispatcher = new PlotToolEventDispatcher(plotInteractor);
        } else {
            this.toolEventDispatcher = new UnsupportedToolEventDispatcher();
        }
        this.svgRoot.ensureContentBuilt();
    }

    @NotNull
    public final PlotSvgRoot getSvgRoot() {
        return this.svgRoot;
    }

    @NotNull
    public final SvgSvgElement getSvg() {
        return this.svgRoot.getSvg();
    }

    @NotNull
    public final List<SomeFig> getLiveMapFigures() {
        return this.svgRoot.getLiveMapFigures();
    }

    public final boolean isLiveMap() {
        return this.svgRoot.isLiveMap();
    }

    @NotNull
    public final MouseEventPeer getMouseEventPeer() {
        return this.plot.getMouseEventPeer();
    }

    @NotNull
    public final ToolEventDispatcher getToolEventDispatcher() {
        return this.toolEventDispatcher;
    }

    @Override
    public void dispose() {
        this.registrations.remove();
        this.svgRoot.clearContent();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PlotContainer$Companion;", "", "()V", "addViewToolbox", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "plotInteractor", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;", "toolEventDispatcher", "Lorg/jetbrains/letsPlot/core/interact/event/ToolEventDispatcher;", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        private final Registration addViewToolbox(PlotInteractor plotInteractor, ToolEventDispatcher toolEventDispatcher2) {
            return Registration.Companion.from((Disposable)new PlotToolbox(plotInteractor, toolEventDispatcher2));
        }

        public static final /* synthetic */ Registration access$addViewToolbox(Companion $this, PlotInteractor plotInteractor, ToolEventDispatcher toolEventDispatcher2) {
            return $this.addViewToolbox(plotInteractor, toolEventDispatcher2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

