/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.interact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.DebounceKt;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.interact.DrawRectFeedback;
import org.jetbrains.letsPlot.core.interact.PanGeomFeedback;
import org.jetbrains.letsPlot.core.interact.ToolFeedback;
import org.jetbrains.letsPlot.core.interact.WheelZoomFeedback;
import org.jetbrains.letsPlot.core.interact.event.ToolEventDispatcher;
import org.jetbrains.letsPlot.core.plot.builder.PlotInteractor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000  2\u00020\u0001:\u0002 !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fH\u0002J*\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f0\u0014H\u0016J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f0\u00140\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J$\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00072\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fH\u0002J(\u0010\u001e\u001a\u00020\u000e2\u001e\u0010\u001f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\u000bH\u0016R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/interact/PlotToolEventDispatcher;", "Lorg/jetbrains/letsPlot/core/interact/event/ToolEventDispatcher;", "plotInteractor", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;", "(Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;)V", "interactionsByOrigin", "", "", "", "Lorg/jetbrains/letsPlot/core/plot/builder/interact/PlotToolEventDispatcher$InteractionInfo;", "toolEventCallback", "Lkotlin/Function1;", "", "", "", "activateInteraction", "origin", "interactionSpec", "activateInteractions", "interactionSpecList", "", "completeInteraction", "interactionName", "dataBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "deactivateAllSilently", "deactivateInteractions", "deactivateOverlappingInteractions", "originBeingActivated", "interactionSpecBeingActivated", "initToolEventCallback", "callback", "Companion", "InteractionInfo", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotToolEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotToolEventDispatcher.kt\norg/jetbrains/letsPlot/core/plot/builder/interact/PlotToolEventDispatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,169:1\n1#2:170\n1855#3,2:171\n1855#3,2:180\n1238#3,2:184\n1549#3:186\n1620#3,3:187\n1241#3:190\n766#3:191\n857#3,2:192\n1855#3,2:194\n372#4,7:173\n453#4:182\n403#4:183\n*S KotlinDebug\n*F\n+ 1 PlotToolEventDispatcher.kt\norg/jetbrains/letsPlot/core/plot/builder/interact/PlotToolEventDispatcher\n*L\n45#1:171,2\n126#1:180,2\n139#1:184,2\n140#1:186\n140#1:187,3\n139#1:190\n155#1:191\n155#1:192,2\n156#1:194,2\n91#1:173,7\n139#1:182\n139#1:183\n*E\n"})
public final class PlotToolEventDispatcher
implements ToolEventDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotInteractor plotInteractor;
    @NotNull
    private final Map<String, List<InteractionInfo>> interactionsByOrigin;
    private Function1<? super Map<String, ? extends Object>, Unit> toolEventCallback;
    private static final long DEBOUNCE_DELAY_MS = 30L;

    public PlotToolEventDispatcher(@NotNull PlotInteractor plotInteractor) {
        Intrinsics.checkNotNullParameter((Object)plotInteractor, (String)"plotInteractor");
        this.plotInteractor = plotInteractor;
        this.interactionsByOrigin = new HashMap();
    }

    @Override
    public void initToolEventCallback(@NotNull Function1<? super Map<String, ? extends Object>, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!(this.toolEventCallback == null)) {
            boolean bl = false;
            String string = "Repeated initialization of 'toolEventCallback'.";
            throw new IllegalStateException(string.toString());
        }
        this.toolEventCallback = callback;
    }

    @Override
    public void activateInteractions(@NotNull String origin, @NotNull List<? extends Map<String, ? extends Object>> interactionSpecList) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(interactionSpecList, (String)"interactionSpecList");
        Iterable $this$forEach$iv = interactionSpecList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map interactionSpec = (Map)element$iv;
            boolean bl = false;
            this.activateInteraction(origin, interactionSpec);
        }
    }

    private final void activateInteraction(String origin, Map<String, ? extends Object> interactionSpec) {
        List list2;
        ToolFeedback toolFeedback;
        this.deactivateOverlappingInteractions(origin, interactionSpec);
        Object object = MapsKt.getValue(interactionSpec, (Object)"name");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String interactionName = (String)object;
        Function1 completeInteractionDebounced2 = DebounceKt.debounce(30L, CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), (Function1)new Function1<DoubleRectangle, Unit>(interactionName, this, origin){
            final /* synthetic */ String $interactionName;
            final /* synthetic */ PlotToolEventDispatcher this$0;
            final /* synthetic */ String $origin;
            {
                this.$interactionName = $interactionName;
                this.this$0 = $receiver;
                this.$origin = $origin;
                super(1);
            }

            public final void invoke(@NotNull DoubleRectangle dataBounds) {
                Intrinsics.checkNotNullParameter((Object)dataBounds, (String)"dataBounds");
                System.out.println((Object)("Debounced interaction: " + this.$interactionName + ", dataBounds: " + dataBounds));
                PlotToolEventDispatcher.access$completeInteraction(this.this$0, this.$origin, this.$interactionName, dataBounds);
            }
        });
        switch (interactionName) {
            case "drag-pan": {
                toolFeedback = new PanGeomFeedback((Function1<? super DoubleRectangle, Unit>)((Function1)new Function1<DoubleRectangle, Unit>(this, origin, interactionName){
                    final /* synthetic */ PlotToolEventDispatcher this$0;
                    final /* synthetic */ String $origin;
                    final /* synthetic */ String $interactionName;
                    {
                        this.this$0 = $receiver;
                        this.$origin = $origin;
                        this.$interactionName = $interactionName;
                        super(1);
                    }

                    public final void invoke(@NotNull DoubleRectangle dataBounds) {
                        Intrinsics.checkNotNullParameter((Object)dataBounds, (String)"dataBounds");
                        System.out.println((Object)("Pan tool: apply " + dataBounds));
                        PlotToolEventDispatcher.access$completeInteraction(this.this$0, this.$origin, this.$interactionName, dataBounds);
                    }
                }));
                break;
            }
            case "box-zoom": {
                boolean centerStart = Intrinsics.areEqual((Object)interactionSpec.get("zoom-box-mode"), (Object)"center_start");
                toolFeedback = new DrawRectFeedback(centerStart, (Function1<? super DoubleRectangle, Unit>)((Function1)new Function1<DoubleRectangle, Unit>(this, origin, interactionName){
                    final /* synthetic */ PlotToolEventDispatcher this$0;
                    final /* synthetic */ String $origin;
                    final /* synthetic */ String $interactionName;
                    {
                        this.this$0 = $receiver;
                        this.$origin = $origin;
                        this.$interactionName = $interactionName;
                        super(1);
                    }

                    public final void invoke(@NotNull DoubleRectangle dataBounds) {
                        Intrinsics.checkNotNullParameter((Object)dataBounds, (String)"dataBounds");
                        System.out.println((Object)("client: data " + dataBounds));
                        PlotToolEventDispatcher.access$completeInteraction(this.this$0, this.$origin, this.$interactionName, dataBounds);
                    }
                }));
                break;
            }
            case "wheel-zoom": {
                toolFeedback = new WheelZoomFeedback((Function1<? super DoubleRectangle, Unit>)((Function1)new Function1<DoubleRectangle, Unit>(completeInteractionDebounced2){
                    final /* synthetic */ Function1<DoubleRectangle, Unit> $completeInteractionDebounced;
                    {
                        this.$completeInteractionDebounced = $completeInteractionDebounced;
                        super(1);
                    }

                    public final void invoke(@NotNull DoubleRectangle dataBounds) {
                        Intrinsics.checkNotNullParameter((Object)dataBounds, (String)"dataBounds");
                        this.$completeInteractionDebounced.invoke((Object)dataBounds);
                    }
                }));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported interaction: " + interactionName);
            }
        }
        ToolFeedback feedback2 = toolFeedback;
        Registration feedbackRegistration = this.plotInteractor.startToolFeedback(feedback2);
        Map<String, List<InteractionInfo>> $this$getOrPut$iv = this.interactionsByOrigin;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(origin);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(origin, answer$iv);
            list2 = answer$iv;
        } else {
            list2 = value$iv;
        }
        list2.add((InteractionInfo)new InteractionInfo(interactionSpec, feedbackRegistration));
        Function1<? super Map<String, ? extends Object>, Unit> function1 = this.toolEventCallback;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolEventCallback");
            function1 = null;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"interaction_activated"), TuplesKt.to((Object)"origin", (Object)origin), TuplesKt.to((Object)"interaction", (Object)interactionName)};
        function1.invoke((Object)MapsKt.mapOf((Pair[])pairArray));
    }

    private final void completeInteraction(String origin, String interactionName, DoubleRectangle dataBounds) {
        Function1<? super Map<String, ? extends Object>, Unit> function1 = this.toolEventCallback;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toolEventCallback");
            function1 = null;
        }
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"name", (Object)"interaction_completed");
        pairArray[1] = TuplesKt.to((Object)"origin", (Object)origin);
        pairArray[2] = TuplesKt.to((Object)"interaction", (Object)interactionName);
        Object[] objectArray = new Double[]{dataBounds.getLeft(), dataBounds.getTop(), dataBounds.getRight(), dataBounds.getBottom()};
        pairArray[3] = TuplesKt.to((Object)"selected.dataBounds", (Object)CollectionsKt.listOf((Object[])objectArray));
        function1.invoke((Object)MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    public void deactivateInteractions(@NotNull String origin) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            List<InteractionInfo> list2 = this.interactionsByOrigin.remove(origin);
            if (list2 == null) break block2;
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InteractionInfo interactionInfo = (InteractionInfo)element$iv;
                boolean bl = false;
                interactionInfo.getFeedbackReg().dispose();
                Function1<? super Map<String, ? extends Object>, Unit> function1 = this.toolEventCallback;
                if (function1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"toolEventCallback");
                    function1 = null;
                }
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"interaction_deactivated"), TuplesKt.to((Object)"origin", (Object)origin), TuplesKt.to((Object)"interaction", (Object)interactionInfo.getInteractionName())};
                function1.invoke((Object)MapsKt.mapOf((Pair[])pairArray));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, List<Map<String, Object>>> deactivateAllSilently() {
        void $this$mapValuesTo$iv$iv;
        Map<String, List<InteractionInfo>> $this$mapValues$iv = this.interactionsByOrigin;
        boolean $i$f$mapValues = false;
        Map<String, List<InteractionInfo>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            List interactionInfoList = (List)entry2.getValue();
            Iterable $this$map$iv = interactionInfoList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InteractionInfo interactionInfo = (InteractionInfo)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                it.getFeedbackReg().dispose();
                collection.add(it.getInteractionSpec());
            }
            List list2 = (List)destination$iv$iv2;
            map4.put(k, list2);
        }
        Map deactivatedInteractions = destination$iv$iv;
        this.interactionsByOrigin.clear();
        return deactivatedInteractions;
    }

    /*
     * WARNING - void declaration
     */
    private final void deactivateOverlappingInteractions(String originBeingActivated, Map<String, ? extends Object> interactionSpecBeingActivated) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = new ArrayList(this.interactionsByOrigin.keySet());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String origin = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)origin, (Object)originBeingActivated))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String origin = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)origin);
            this.deactivateInteractions(origin);
        }
    }

    public static final /* synthetic */ void access$completeInteraction(PlotToolEventDispatcher $this, String origin, String interactionName, DoubleRectangle dataBounds) {
        $this.completeInteraction(origin, interactionName, dataBounds);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/interact/PlotToolEventDispatcher$Companion;", "", "()V", "DEBOUNCE_DELAY_MS", "", "plot-builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/interact/PlotToolEventDispatcher$InteractionInfo;", "", "interactionSpec", "", "", "feedbackReg", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/commons/registration/Registration;)V", "getFeedbackReg", "()Lorg/jetbrains/letsPlot/commons/registration/Registration;", "interactionName", "getInteractionName", "()Ljava/lang/String;", "getInteractionSpec", "()Ljava/util/Map;", "plot-builder"})
    private static final class InteractionInfo {
        @NotNull
        private final Map<String, Object> interactionSpec;
        @NotNull
        private final Registration feedbackReg;
        @NotNull
        private final String interactionName;

        public InteractionInfo(@NotNull Map<String, ? extends Object> interactionSpec, @NotNull Registration feedbackReg) {
            Intrinsics.checkNotNullParameter(interactionSpec, (String)"interactionSpec");
            Intrinsics.checkNotNullParameter((Object)feedbackReg, (String)"feedbackReg");
            this.interactionSpec = interactionSpec;
            this.feedbackReg = feedbackReg;
            Object object = MapsKt.getValue(this.interactionSpec, (Object)"name");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            this.interactionName = (String)object;
        }

        @NotNull
        public final Map<String, Object> getInteractionSpec() {
            return this.interactionSpec;
        }

        @NotNull
        public final Registration getFeedbackReg() {
            return this.feedbackReg;
        }

        @NotNull
        public final String getInteractionName() {
            return this.interactionName;
        }
    }
}

