/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.documentation.mdn.MdnCssSymbolKind;
import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssCustomPropertyAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssKeyframesRule;
import com.intellij.psi.css.CssPageRule;
import com.intellij.psi.css.CssPseudoClass;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MdnDocumentationUtil {
    private static final List<String> VISIBLE_BROWSERS = Arrays.asList("chrome", "chrome_android", "edge", "firefox", "ie", "opera", "safari", "safari_ios", "nodejs");

    @NotNull
    private static String getFormattedCompatibilityData(@Nullable Map data) {
        Map support;
        Object compat;
        Object v0 = compat = data != null ? data.get("__compat") : null;
        if (compat != null && (support = (Map)((Map)compat).get("support")) != null) {
            boolean everywhere = true;
            LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
            for (Object key : support.keySet()) {
                String browserId = key.toString();
                if (!VISIBLE_BROWSERS.contains(browserId)) continue;
                Object browserInfos = support.get(key);
                Map browserInfo = (Map)(browserInfos instanceof ArrayList ? ((ArrayList)browserInfos).get(0) : browserInfos);
                Object versionAdded = browserInfo.get("version_added");
                String version = versionAdded != null ? versionAdded.toString() : "";
                everywhere &= MdnDocumentationUtil.anyVersion(browserId, version);
                if (StringUtil.isEmpty((String)version) || "false".equals(version)) continue;
                versions.put(browserId, version);
            }
            if (everywhere) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (Map.Entry entry : versions.entrySet()) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(MdnDocumentationUtil.getReadableBrowserName((String)entry.getKey()));
                String version = (String)entry.getValue();
                if (MdnDocumentationUtil.anyVersion((String)entry.getKey(), version)) continue;
                result.append(" ").append(version);
            }
            String string = result.toString();
            if (string == null) {
                MdnDocumentationUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        return "";
    }

    private static boolean anyVersion(String browser, String version) {
        if (browser.startsWith("edge") && "12".equals(version)) {
            return true;
        }
        if (browser.equals("firefox_android") && "4".equals(version)) {
            return true;
        }
        if (browser.equals("chrome_android") && "18".equals(version)) {
            return true;
        }
        return "true".equals(version) || "1".equals(version);
    }

    private static String getReadableBrowserName(String key) {
        if ("webview_android".equals(key)) {
            return "Android WebView";
        }
        if ("safari_ios".equals(key)) {
            return "Safari iOS";
        }
        if ("ie".equals(key)) {
            return "IE";
        }
        if ("nodejs".equals(key)) {
            return "Node.js";
        }
        if ("samsunginternet_android".equals(key)) {
            return "Samsung Internet";
        }
        return StringUtil.capitalizeWords((String)key.replace('_', ' '), (boolean)true);
    }

    @Nullable
    public static String getMdnUrl(@Nullable Map data) {
        Object compat;
        Object v0 = compat = data != null ? data.get("__compat") : null;
        if (compat != null) {
            Object mdnUrl = ((Map)compat).get("mdn_url");
            return mdnUrl != null ? mdnUrl.toString() : null;
        }
        return null;
    }

    public static boolean isDeprecated(@Nullable Map data) {
        Object status;
        Object compat;
        Object v0 = compat = data != null ? data.get("__compat") : null;
        if (compat != null && (status = ((Map)compat).get("status")) != null) {
            return "true".equals(((Map)status).get("deprecated").toString());
        }
        return false;
    }

    @NotNull
    @NlsSafe
    public static String buildDoc(@NotNull String name, @NotNull String description, @Nullable Map mdnCompatData) {
        if (name == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(1);
        }
        if (description == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(2);
        }
        return MdnDocumentationUtil.buildDoc(name, description, mdnCompatData, null, null);
    }

    @NotNull
    @NlsSafe
    public static String buildDoc(@NotNull String name, @NotNull String description, @Nullable Map mdnCompatData, @Nullable String formalSyntax, @Nullable Map<String, String> valuesDescription) {
        boolean hasSections;
        if (name == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(3);
        }
        if (description == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(4);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<div class='definition'><pre>").append(name).append("</pre></div>");
        if (!description.isEmpty()) {
            buf.append("<div class='content'>");
            buf.append(StringUtil.capitalize((String)description));
            buf.append("</div>");
        }
        String compatibilityData = MdnDocumentationUtil.getFormattedCompatibilityData(mdnCompatData);
        boolean deprecated = MdnDocumentationUtil.isDeprecated(mdnCompatData);
        boolean bl = hasSections = deprecated || !compatibilityData.isEmpty() || formalSyntax != null || !ContainerUtil.isEmpty(valuesDescription);
        if (hasSections) {
            buf.append("<table class='sections'>");
        }
        if (formalSyntax != null) {
            buf.append("<tr><td valign='top' class='section'><p>").append("Syntax:");
            buf.append("</td><td valign='top'>").append("<pre><code>").append(formalSyntax).append("</code></pre>");
            buf.append("</td>");
        }
        if (!ContainerUtil.isEmpty(valuesDescription)) {
            buf.append("<tr><td valign='top' class='section'><p>").append("Values:").append("</td><td valign='top'>").append(MdnDocumentationKt.buildSubSection(valuesDescription));
            buf.append("</td>");
        }
        if (deprecated) {
            buf.append("<tr><td valign='top' class='section'><p>").append("Deprecated");
            buf.append("</td>");
        }
        if (!compatibilityData.isEmpty()) {
            buf.append("<tr><td valign='top' class='section'><p>").append("Supported by:");
            buf.append("</td><td valign='top'>").append(compatibilityData);
            buf.append("</td>");
        }
        if (hasSections) {
            buf.append("</table>");
        }
        String string = buf.toString();
        if (string == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static MdnSymbolDocumentation getMdnDocumentation(@NotNull PsiElement element, @Nullable PsiElement context) {
        MdnCssSymbolKind kind;
        Object name;
        if (element == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(6);
        }
        if (element instanceof CssDeclaration) {
            PsiElement grandParent;
            String propertyName = ((CssDeclaration)element).getPropertyName();
            CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider(element);
            if (descriptorProvider != null) {
                propertyName = descriptorProvider.restoreFullPropertyName(propertyName, element);
            }
            PsiElement parent = context != null && context.getParent() instanceof CssDeclaration ? context.getParent().getParent() : (context instanceof PsiWhiteSpace && context.getParent() instanceof CssBlock ? context.getParent() : element.getParent());
            name = parent instanceof CssBlock && parent.getNode().getElementType() == CssElementTypes.CSS_DECLARATION_BLOCK && (grandParent = parent.getParent()) instanceof CssAtRule ? "@" + MdnDocumentationUtil.getCssAtRuleName((CssAtRule)grandParent) + "." + propertyName : propertyName;
            kind = MdnCssSymbolKind.Property;
        } else if (element instanceof CssPseudoSelector) {
            name = ((CssPseudoSelector)element).getName();
            kind = element instanceof CssPseudoClass ? MdnCssSymbolKind.PseudoClass : MdnCssSymbolKind.PseudoElement;
        } else if (element instanceof CssAtRule) {
            name = MdnDocumentationUtil.getCssAtRuleName((CssAtRule)element);
            kind = MdnCssSymbolKind.AtRule;
        } else if (element instanceof CssFunction) {
            if (element.getParent() instanceof CssPseudoClass) {
                name = ((CssFunction)element).getName() + "()";
                kind = MdnCssSymbolKind.PseudoClass;
            } else {
                name = ((CssFunction)element).getName();
                kind = MdnCssSymbolKind.Function;
            }
        } else if (element instanceof CssImport) {
            name = "import";
            kind = MdnCssSymbolKind.AtRule;
        } else if (element instanceof CssUri) {
            name = "url";
            kind = MdnCssSymbolKind.Function;
        } else {
            return null;
        }
        return MdnDocumentationKt.getCssMdnDocumentation((String)name, (MdnCssSymbolKind)kind);
    }

    @NotNull
    private static String getCssAtRuleName(@NotNull CssAtRule element) {
        if (element == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(7);
        }
        String name = element instanceof CssKeyframesRule ? "keyframes" : (element instanceof CssPageRule ? "page" : (element instanceof CssCustomPropertyAtRule ? "property" : StringUtil.trimStart((String)element.getName(), (String)"@")));
        String string = name;
        if (string == null) {
            MdnDocumentationUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/MdnDocumentationUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattedCompatibilityData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/MdnDocumentationUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDoc";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssAtRuleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildDoc";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMdnDocumentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCssAtRuleName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

