/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphIdentifiable;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.edges.CollapsedEdge;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.threading.GraphActionExecutor;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DUndoManager;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GraphBuilder<N, E>
extends UserDataHolderBase
implements UserDataHolder,
Disposable {
    @NotNull
    public abstract GraphActionExecutor getActionExecutor();

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract Graph2D getGraph();

    @NotNull
    public abstract Graph2DView getView();

    @NotNull
    public abstract GraphDataModel<N, E> getGraphDataModel();

    @NotNull
    public abstract GraphPresentationModel<N, E> getGraphPresentationModel();

    @NotNull
    public Graph2DUndoManager getUndoManager() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract double getZoom();

    public abstract void setZoom(double var1);

    public abstract void setZoom(double var1, boolean var3);

    public abstract void setZoom(double var1, boolean var3, ZoomChangedEvent var4);

    public abstract void fitContent(boolean var1);

    @Contract(pure=true)
    @NotNull
    public abstract GraphUpdateQueryParams<N, E> queryGraphUpdate();

    @Nullable
    public abstract String getNodeName(@Nullable N var1);

    @Nullable
    public abstract String getEdgeName(@Nullable E var1);

    @Nullable
    public abstract Node getNode(@Nullable N var1);

    @Nullable
    public abstract Edge getEdge(@Nullable E var1);

    @Nullable
    public abstract Node getGroupNode(@Nullable NodeGroupDescriptor var1);

    @Nullable
    public abstract Edge getCollapsedEdge(@Nullable CollapsedEdge var1);

    @Nullable
    public abstract N getNodeObject(@Nullable Node var1);

    @Nullable
    public abstract E getEdgeObject(@Nullable Edge var1);

    @Nullable
    public abstract NodeGroupDescriptor getGroupNodeObject(@Nullable Node var1);

    @Nullable
    public abstract CollapsedEdge getCollapsedEdgeObject(@Nullable Edge var1);

    @NotNull
    public abstract Collection<N> getNodeObjects();

    @NotNull
    public abstract Collection<E> getEdgeObjects();

    @NotNull
    public abstract Collection<NodeGroupDescriptor> getGroupNodeObjects();

    @NotNull
    public abstract Collection<CollapsedEdge> getCollapsedEdgeObjects();

    public abstract boolean removeNode(@Nullable N var1);

    public abstract boolean removeEdge(@Nullable E var1);

    public abstract void addGraphBuilderListener(@NotNull GraphBuilderListener var1, @NotNull Disposable var2);

    public abstract void removeGraphBuilderListener(@NotNull GraphBuilderListener var1);

    @ApiStatus.Internal
    public abstract void addCustomUpdater(@NotNull CustomGraphUpdater var1);

    @ApiStatus.Internal
    public void removeCustomUpdater(@NotNull CustomGraphUpdater updater) {
        if (updater == null) {
            GraphBuilder.$$$reportNull$$$0(0);
        }
    }

    @ApiStatus.Internal
    public abstract boolean isCellEditing();

    @ApiStatus.Internal
    @NotNull
    public abstract EditMode getEditMode();

    @ApiStatus.Internal
    @NotNull
    public ViewMode getActiveMode() {
        EditMode editMode = this.getEditMode();
        if (editMode == null) {
            GraphBuilder.$$$reportNull$$$0(1);
        }
        return editMode;
    }

    @ApiStatus.Internal
    public void setActiveMode(@NotNull ViewMode activeMode) {
        if (activeMode == null) {
            GraphBuilder.$$$reportNull$$$0(2);
        }
        throw new IllegalStateException("Not Implemented");
    }

    @ApiStatus.Internal
    public void updateDataModelWithCustomMapping(@Nullable Function<? super N, ? extends Node> nodeMapping, @Nullable Function<? super E, ? extends Edge> edgeMapping) {
        this.updateDataModel();
    }

    @ApiStatus.Internal
    public abstract void initialize();

    @ApiStatus.Internal
    public void setNodeRealizer(@NotNull Node node, @NotNull NodeRealizer newNodeRealizer) {
        if (node == null) {
            GraphBuilder.$$$reportNull$$$0(3);
        }
        if (newNodeRealizer == null) {
            GraphBuilder.$$$reportNull$$$0(4);
        }
        this.getGraph().setRealizer(node, newNodeRealizer);
    }

    @ApiStatus.Internal
    public void setEdgeRealizer(@NotNull Edge edge, @NotNull EdgeRealizer newEdgeRealizer) {
        if (edge == null) {
            GraphBuilder.$$$reportNull$$$0(5);
        }
        if (newEdgeRealizer == null) {
            GraphBuilder.$$$reportNull$$$0(6);
        }
        this.getGraph().setRealizer(edge, newEdgeRealizer);
    }

    @ApiStatus.Internal
    @NotNull
    public GraphIdentifiable.Node.Identity getNodeIdentity(@NotNull Node node) {
        if (node == null) {
            GraphBuilder.$$$reportNull$$$0(7);
        }
        this.getActionExecutor().assertReadAccess();
        N modelObject = this.getNodeObject(node);
        if (modelObject == null) {
            return new GraphIdentifiable.Node.OfGraphNode(node);
        }
        if (modelObject instanceof GraphIdentifiable.Node) {
            GraphIdentifiable.Node.Identity identity = (GraphIdentifiable.Node.Identity)((GraphIdentifiable.Node)modelObject).getID();
            if (identity == null) {
                GraphBuilder.$$$reportNull$$$0(8);
            }
            return identity;
        }
        return new GraphIdentifiable.Node.OfModelNode(modelObject);
    }

    @ApiStatus.Internal
    @NotNull
    public GraphIdentifiable.Edge.Identity getEdgeIdentity(@NotNull Edge edge) {
        if (edge == null) {
            GraphBuilder.$$$reportNull$$$0(9);
        }
        this.getActionExecutor().assertReadAccess();
        E modelObject = this.getEdgeObject(edge);
        if (modelObject == null) {
            return new GraphIdentifiable.Edge.OfGraphEdge(edge);
        }
        if (modelObject instanceof GraphIdentifiable.Edge) {
            GraphIdentifiable.Edge.Identity identity = (GraphIdentifiable.Edge.Identity)((GraphIdentifiable.Edge)modelObject).getID();
            if (identity == null) {
                GraphBuilder.$$$reportNull$$$0(10);
            }
            return identity;
        }
        return new GraphIdentifiable.Edge.OfModelEdge(modelObject);
    }

    @ApiStatus.Internal
    @NotNull
    public HierarchyManager getHierarchyManager() {
        HierarchyManager hierarchyManager = this.getGraph().getHierarchyManager();
        if (hierarchyManager == null) {
            GraphBuilder.$$$reportNull$$$0(11);
        }
        return hierarchyManager;
    }

    @ApiStatus.Internal
    public void setHierarchyManager(@NotNull HierarchyManager hierarchyManager) {
        if (hierarchyManager == null) {
            GraphBuilder.$$$reportNull$$$0(12);
        }
    }

    @Deprecated
    @ApiStatus.Internal
    public abstract void updateGraph(boolean var1);

    @Deprecated
    @ApiStatus.Internal
    public void updateGraph() {
        this.updateGraph(true);
    }

    @Deprecated
    @ApiStatus.Internal
    public abstract void updateDataModel();

    @Deprecated
    public void updateView() {
    }

    @ApiStatus.Internal
    public void updateBridges() {
    }

    @ApiStatus.Internal
    public void updateGrid() {
    }

    @Deprecated
    public abstract void queueUpdate();

    @Deprecated
    @ApiStatus.Internal
    public abstract void updateRealizers(boolean var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/GraphBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeMode";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNodeRealizer";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEdgeRealizer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/GraphBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveMode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeIdentity";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeIdentity";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomUpdater";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setActiveMode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNodeRealizer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeRealizer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNodeIdentity";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeIdentity";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setHierarchyManager";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 10, 11 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface ZoomChangedEvent {
        public void execute();
    }

    public static interface GraphUpdateQueryParams<N, E> {
        @Contract(pure=true)
        @NotNull
        public GraphUpdateQueryParams<N, E> withDataReload();

        @Contract(pure=true)
        @NotNull
        public GraphUpdateQueryParams<N, E> withRelayout();

        @Contract(pure=true)
        @NotNull
        public GraphUpdateQueryParams<N, E> withRelayout(@NotNull Layouter var1);

        @Contract(pure=true)
        @NotNull
        public GraphUpdateQueryParams<N, E> withAllNodeSizeUpdate();

        @Contract(pure=true)
        @NotNull
        default public GraphUpdateQueryParams<N, E> withAllNodeSizeUpdateIf(boolean statement) {
            GraphUpdateQueryParams<N, E> graphUpdateQueryParams = statement ? this.withAllNodeSizeUpdate() : this;
            if (graphUpdateQueryParams == null) {
                GraphUpdateQueryParams.$$$reportNull$$$0(0);
            }
            return graphUpdateQueryParams;
        }

        @Contract(pure=true)
        @NotNull
        public GraphUpdateQueryParams<N, E> withNodeSizeUpdate(N ... var1);

        public void run();

        @NotNull
        public CompletableFuture<Void> runAsync();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/GraphBuilder$GraphUpdateQueryParams", "withAllNodeSizeUpdateIf"));
        }
    }
}

