/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.rt.impl;

import com.intellij.execution.rmi.RemoteObject;
import com.intellij.grid.scripting.rt.RemoteLoaderSession;
import com.intellij.grid.scripting.rt.bindings.Loader;
import com.intellij.grid.scripting.rt.util.DatabaseExtensionScriptRunnerBase;
import com.intellij.util.ExceptionUtilRt;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteLoaderSessionImpl
extends RemoteObject
implements RemoteLoaderSession {
    private static final RemoteLoaderSession.Event START = new RemoteLoaderSession.Event(){};
    private static final RemoteLoaderSession.Event FINISH = new RemoteLoaderSession.Event(){};
    protected final Map<String, Object> myContext;
    private final Thread myThread;
    private final BlockingQueue<RemoteLoaderSession.Event> myQueue;
    private boolean myEof;
    protected final DatabaseExtensionScriptRunnerBase.ProgressMessagesConsumer myProgressConsumer;

    public RemoteLoaderSessionImpl(@NotNull Map<String, Object> context) {
        if (context == null) {
            RemoteLoaderSessionImpl.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myQueue = new ArrayBlockingQueue<RemoteLoaderSession.Event>(100);
        this.myThread = this.createFillerThread();
        this.myProgressConsumer = message -> {
            this.checkCancelled();
            this.myQueue.offer(new RemoteLoaderSession.Event.Progress(message));
        };
        this.startProducing();
    }

    @Override
    @Nullable(value="EOF")
    public @Nullable(value="EOF") List<RemoteLoaderSession.Event> fetch(int blockingLimit, int limit) throws RemoteException, InterruptedException {
        List res = null;
        for (int i = 0; i < limit && !this.myEof; ++i) {
            boolean block = blockingLimit > 0 && (res == null || res.size() < blockingLimit);
            RemoteLoaderSession.Event e = this.handle(block ? this.myQueue.take() : (RemoteLoaderSession.Event)this.myQueue.poll());
            if (e != null) {
                if (res == null) {
                    res = new ArrayList(limit);
                }
                res.add(e);
                continue;
            }
            if (!block) break;
        }
        return res == null && !this.myEof ? Collections.emptyList() : res;
    }

    private RemoteLoaderSession.Event handle(RemoteLoaderSession.Event e) {
        if (e == FINISH) {
            this.myEof = true;
            return null;
        }
        return e;
    }

    @Override
    public void close() throws RemoteException {
        this.myThread.interrupt();
        this.myQueue.clear();
        this.myThread.interrupt();
    }

    private void startProducing() {
        this.myThread.start();
        try {
            RemoteLoaderSession.Event e = this.myQueue.poll(5L, TimeUnit.SECONDS);
            if (e == START) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new CancellationException("Processing didn't start");
    }

    @NotNull
    private Thread createFillerThread() {
        return new Thread("Script"){

            @Override
            public void run() {
                RemoteLoaderSessionImpl.this.myQueue.offer(START);
                RemoteLoaderSessionImpl.this.consumeDataSafe();
            }
        };
    }

    private void consumeDataSafe() {
        try {
            Loader.DataConsumer consumer = this.createConsumer();
            this.load(consumer);
        }
        catch (Throwable th) {
            if (!ExceptionUtilRt.causedBy((Throwable)th, CancellationException.class)) {
                this.myQueue.offer(new RemoteLoaderSession.Event.Error(th));
            }
        }
        finally {
            Thread.interrupted();
            try {
                this.myQueue.put(FINISH);
            }
            catch (InterruptedException consumer) {}
        }
    }

    protected abstract void load(Loader.DataConsumer var1) throws Exception;

    @NotNull
    private Loader.DataConsumer createConsumer() {
        return new Loader.DataConsumer(){

            @Override
            public void consumeColumns(String[] names, Class<?>[] types) {
                RemoteLoaderSessionImpl.this.checkCancelled();
                RemoteLoaderSessionImpl.this.myQueue.offer(new RemoteLoaderSession.Event.Columns(names, types));
            }

            @Override
            public void consume(Object ... row) {
                RemoteLoaderSessionImpl.this.checkCancelled();
                RemoteLoaderSessionImpl.this.myQueue.offer(new RemoteLoaderSession.Event.Data(Collections.singletonList(row)));
            }
        };
    }

    private void checkCancelled() {
        if (this.myThread.isInterrupted()) {
            throw new CancellationException();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/grid/scripting/rt/impl/RemoteLoaderSessionImpl", "<init>"));
    }
}

