/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.profiler.api.Fraction;
import com.intellij.profiler.ui.flamegraph.FlameGraphNodes;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0016J\b\u0010\u0003\u001a\u00020\u0004H&J\u000f\u0010\u0005\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\t\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H'\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\f\u0010\u0013\u001a\u00020\u0011*\u00020\fH\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/ui/flamegraph/FlameGraphModel;", "T", "", "isEmpty", "", "getRoot", "()Ljava/lang/Object;", "getChildren", "", "node", "(Ljava/lang/Object;)Ljava/util/List;", "getFractionOfParent", "", "parent", "child", "(Ljava/lang/Object;Ljava/lang/Object;)D", "getExactFractionOfParent", "Lcom/intellij/profiler/api/Fraction;", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/profiler/api/Fraction;", "toApproximateFraction", "createNodes", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNodes;", "Companion", "intellij.profiler.common"})
public interface FlameGraphModel<T> {
    @NotNull
    public static final Companion Companion = com.intellij.profiler.ui.flamegraph.FlameGraphModel$Companion.$$INSTANCE;

    public boolean isEmpty();

    @Nullable
    public T getRoot();

    @NotNull
    public List<T> getChildren(T var1);

    @Deprecated(message="Not used to paint the flame graph anymore due to floating-point imprecision and difficult debugging", replaceWith=@ReplaceWith(expression="getExactFractionOfParent", imports={}))
    public double getFractionOfParent(T var1, T var2);

    @NotNull
    default public Fraction getExactFractionOfParent(T parent, T child) {
        return this.toApproximateFraction(this.getFractionOfParent(parent, child));
    }

    private Fraction toApproximateFraction(double $this$toApproximateFraction) {
        if ($this$toApproximateFraction < -1.0E-10 || $this$toApproximateFraction > 1.0000000001) {
            throw new IllegalArgumentException("Incorrect fraction: must be in interval [0; 1], got " + $this$toApproximateFraction);
        }
        long nominator = (long)($this$toApproximateFraction * (double)10000000000L);
        return new Fraction(Math.min(nominator, 10000000000L), 10000000000L);
    }

    @NotNull
    public FlameGraphNodes<T> createNodes();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0001\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ui/flamegraph/FlameGraphModel$Companion;", "", "<init>", "()V", "EPS", "", "EPS_INV", "", "createEmptyModel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphModel;", "T", "intellij.profiler.common"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final double EPS = 1.0E-10;
        private static final long EPS_INV = 10000000000L;

        private Companion() {
        }

        @NotNull
        public final <T> FlameGraphModel<T> createEmptyModel() {
            return new FlameGraphModel<T>(){

                public boolean isEmpty() {
                    return true;
                }

                public T getRoot() {
                    return null;
                }

                public List<T> getChildren(T node) {
                    return CollectionsKt.emptyList();
                }

                public double getFractionOfParent(T parent, T child) {
                    return 1.0;
                }

                public Fraction getExactFractionOfParent(T parent, T child) {
                    return Fraction.Companion.getONE();
                }

                public FlameGraphNodes<T> createNodes() {
                    return FlameGraphNodes.Companion.empty();
                }
            };
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

