/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.py.debugger.CellSourcePosition;
import com.intellij.jupyter.py.debugger.JupyterDebugProcess;
import com.intellij.jupyter.py.editor.JupyterFileUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\f\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0015J\u0018\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0006J\u0016\u0010%\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0007J\b\u0010'\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "idToPosition", "", "", "Lcom/intellij/jupyter/py/debugger/CellSourcePosition;", "positionToId", "indexedFiles", "", "", "latestCellPosition", "latestCellId", "updatePositions", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "latestCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "updateCellInfo", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cell", "latest", "", "getValidCellIds", "", "notebookFile", "cleanPositionsForFile", "filepath", "isFileIndexed", "generateCellId", "getCellPositionById", "cellId", "getIdByPosition", "cellPosition", "dispose", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterDebugCellIdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDebugCellIdManager.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,111:1\n535#2:112\n520#2,6:113\n535#2:119\n520#2,6:120\n535#2:126\n520#2,6:127\n*S KotlinDebug\n*F\n+ 1 JupyterDebugCellIdManager.kt\ncom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager\n*L\n55#1:112\n55#1:113,6\n59#1:119\n59#1:120,6\n60#1:126\n60#1:127,6\n*E\n"})
public final class JupyterDebugCellIdManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<Integer, CellSourcePosition> idToPosition = new LinkedHashMap();
    @NotNull
    private Map<CellSourcePosition, Integer> positionToId = new LinkedHashMap();
    @NotNull
    private Set<String> indexedFiles = new LinkedHashSet();
    @Nullable
    private CellSourcePosition latestCellPosition;
    private int latestCellId;
    @NotNull
    private static final Logger LOG;

    public final synchronized void updatePositions(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile, @Nullable JupyterPsiCell latestCell) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile originalFile = virtualFile.getOriginFile();
        String string = originalFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        this.cleanPositionsForFile(filePath);
        this.indexedFiles.add(filePath);
        List list = JupyterHelper.INSTANCE.getPsiCells(project, virtualFile);
        if (list == null) {
            return;
        }
        List cells = list;
        for (JupyterPsiCell cell : cells) {
            this.updateCellInfo(originalFile, cell, false);
        }
        if (latestCell != null) {
            this.updateCellInfo(originalFile, latestCell, true);
        }
    }

    public static /* synthetic */ void updatePositions$default(JupyterDebugCellIdManager jupyterDebugCellIdManager, Project project, BackedNotebookVirtualFile backedNotebookVirtualFile, JupyterPsiCell jupyterPsiCell, int n, Object object) {
        if ((n & 4) != 0) {
            jupyterPsiCell = null;
        }
        jupyterDebugCellIdManager.updatePositions(project, backedNotebookVirtualFile, jupyterPsiCell);
    }

    private final void updateCellInfo(VirtualFile originalFile, JupyterPsiCell cell, boolean latest) {
        int cellId = this.generateCellId(cell);
        CellSourcePosition cellPosition = JupyterFileUtilKt.getCellPositionForJupyterCell(originalFile, cell);
        if (cellPosition != null) {
            Integer n = cellId;
            this.idToPosition.put(n, cellPosition);
            n = cellId;
            this.positionToId.put(cellPosition, n);
        }
        if (latest) {
            this.latestCellPosition = cellPosition;
            this.latestCellId = cellId;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getValidCellIds(@NotNull BackedNotebookVirtualFile notebookFile) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Map<CellSourcePosition, Integer> $this$filter$iv = this.positionToId;
        boolean $i$f$filter = false;
        Map<CellSourcePosition, Integer> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((CellSourcePosition)it.getKey()).getStart().getFile().getPath(), (Object)notebookFile.getOriginFile().getPath())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }

    private final void cleanPositionsForFile(String filepath) {
        boolean bl;
        Map.Entry<Object, Object> it;
        Map<Integer, CellSourcePosition> $this$filterTo$iv$iv;
        Map<Integer, CellSourcePosition> $this$filter$iv;
        Map<CellSourcePosition, Integer> map = this.positionToId;
        JupyterDebugCellIdManager jupyterDebugCellIdManager = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)((CellSourcePosition)it.getKey()).getStart().getFile().getPath(), (Object)filepath))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        jupyterDebugCellIdManager.positionToId = MapsKt.toMutableMap((Map)destination$iv$iv);
        $this$filter$iv = this.idToPosition;
        jupyterDebugCellIdManager = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry<Object, Object> entry : $this$filterTo$iv$iv.entrySet()) {
            it = entry;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)((CellSourcePosition)it.getValue()).getStart().getFile().getPath(), (Object)filepath))) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        jupyterDebugCellIdManager.idToPosition = MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    public final synchronized boolean isFileIndexed(@NotNull String filepath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        return this.indexedFiles.contains(filepath);
    }

    public final int generateCellId(@NotNull JupyterPsiCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        return cell.getText().hashCode();
    }

    @Nullable
    public final synchronized CellSourcePosition getCellPositionById(@NotNull Project project, int cellId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CellSourcePosition position = this.idToPosition.get(cellId);
        if (position == null) {
            JupyterDebugProcess.Companion.showCellEditedDuringSession(project);
            return this.latestCellPosition;
        }
        return position;
    }

    public final synchronized int getIdByPosition(@NotNull Project project, @NotNull CellSourcePosition cellPosition) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cellPosition, (String)"cellPosition");
        Integer id = this.positionToId.get(cellPosition);
        if (id == null) {
            if (this.indexedFiles.contains(cellPosition.getStart().getFile().getPath())) {
                JupyterDebugProcess.Companion.showCellEditedDuringSession(project);
            }
            return 0;
        }
        int n = this.latestCellId;
        if (id == n && !Intrinsics.areEqual((Object)cellPosition, (Object)this.latestCellPosition)) {
            return 0;
        }
        return id;
    }

    public void dispose() {
        this.idToPosition.clear();
        this.positionToId.clear();
        this.latestCellPosition = null;
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/py/debugger/JupyterDebugCellIdManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterDebugCellIdManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JupyterDebugCellIdManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JupyterDebugCellIdManager)object;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

