/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.remote;

import com.intellij.jupyter.core.jupyter.connections.auth.JupyterAuthHandler;
import com.intellij.jupyter.core.jupyter.connections.auth.JupyterAuthHandlerFinder;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileContentsApiKt;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterRestClientErrorResponseException;
import com.intellij.jupyter.core.jupyter.connections.settings.ConfiguredServerJupyterModuleConnectionSettings;
import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.remote.SuggestedKind;
import com.intellij.jupyter.py.remote.VerifyJupyterUrlError;
import com.intellij.jupyter.py.remote.vfs.JupyterRemoteVfsUtilKt;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguageKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t\u00a8\u0006\n"}, d2={"verifyJupyterUrl", "Lcom/intellij/jupyter/core/jupyter/connections/settings/ConfiguredServerJupyterModuleConnectionSettings;", "jupyterUrl", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sanitizeUrlForVerifying", "Ljava/net/URI;", "suggestedKind", "Lcom/intellij/jupyter/py/remote/SuggestedKind;", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteUtil.kt\ncom/intellij/jupyter/py/remote/JupyterRemoteUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class JupyterRemoteUtilKt {
    @Nullable
    public static final Object verifyJupyterUrl(@Nullable String jupyterUrl, @NotNull Continuation<? super ConfiguredServerJupyterModuleConnectionSettings> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ConfiguredServerJupyterModuleConnectionSettings>, Object>(jupyterUrl, null){
            int label;
            final /* synthetic */ String $jupyterUrl;
            {
                this.$jupyterUrl = $jupyterUrl;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ConfiguredServerJupyterModuleConnectionSettings configuredServerJupyterModuleConnectionSettings;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            URI uri = JupyterRemoteUtilKt.sanitizeUrlForVerifying(this.$jupyterUrl);
                            Pair pair = JupyterAuthHandlerFinder.Companion.chooseAppropriate(uri);
                            if (pair == null) {
                                throw new VerifyJupyterUrlError(JupyterRemoteBundle.message("Jupyter.remote.verify.url.not.jupyter", new Object[0]));
                            }
                            Pair pair2 = pair;
                            JupyterAuthHandler authHandler = (JupyterAuthHandler)pair2.component1();
                            URI fixedUri = (URI)pair2.component2();
                            ConfiguredServerJupyterModuleConnectionSettings result2 = new ConfiguredServerJupyterModuleConnectionSettings(fixedUri, authHandler, false, 4, null);
                            FileContentsApiKt.getFileNode((FileContentsApi)((FileContentsApi)JupyterRemoteVfsUtilKt.getFileContentsApi(result2)), (String)"/", (boolean)false);
                            configuredServerJupyterModuleConnectionSettings = result2;
                        }
                        catch (MalformedURLException err) {
                            throw new VerifyJupyterUrlError(JupyterRemoteBundle.message("Jupyter.remote.verify.url.malformed", new Object[0]), err);
                        }
                        catch (JupyterRestClientErrorResponseException err) {
                            Object[] authHandler = new Object[2];
                            authHandler[0] = Boxing.boxInt((int)err.getCode());
                            String string = err.getMessage();
                            if (string == null) {
                                string = "";
                            }
                            authHandler[1] = string;
                            throw new VerifyJupyterUrlError(JupyterRemoteBundle.message("Jupyter.remote.verify.url.wrong.response", authHandler), err);
                        }
                        catch (IOException err) {
                            throw new VerifyJupyterUrlError(JupyterRemoteBundle.message("Jupyter.remote.verify.url.connection.error", new Object[0]), err);
                        }
                        catch (RuntimeException err) {
                            if (err instanceof RuntimeExceptionWithAttachments) {
                                boolean $i$f$logger = false;
                                Logger logger = Logger.getInstance(VerifyJupyterUrlError.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                logger.error("Got unexpected error while verified url " + this.$jupyterUrl, (Throwable)err);
                            }
                            throw new VerifyJupyterUrlError(JupyterRemoteBundle.message("Jupyter.remote.verify.url.unexpected.error", new Object[0]), err);
                        }
                        return configuredServerJupyterModuleConnectionSettings;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ConfiguredServerJupyterModuleConnectionSettings> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public static final URI sanitizeUrlForVerifying(@Nullable String jupyterUrl) {
        CharSequence charSequence;
        String string;
        block5: {
            block4: {
                String string2;
                string = jupyterUrl;
                if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) break block4;
                String it = string2 = string;
                boolean bl = false;
                string = ((CharSequence)it).length() > 0 ? string2 : null;
                if (string != null) break block5;
            }
            throw new VerifyJupyterUrlError(JupyterRemoteBundle.message("Jupyter.remote.verify.url.empty", new Object[0]));
        }
        String trimmedUrl = string;
        URI uri = JupyterRemoteUtilKt.sanitizeUrlForVerifying$parseUrlForVerifying(trimmedUrl);
        if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"http") && !Intrinsics.areEqual((Object)uri.getScheme(), (Object)"https") || (charSequence = (CharSequence)uri.getHost()) == null || charSequence.length() == 0) {
            throw new VerifyJupyterUrlError(JupyterRemoteBundle.message("Jupyter.remote.verify.url.malformed", new Object[0]));
        }
        return uri;
    }

    @Nullable
    public static final SuggestedKind suggestedKind(@NotNull JupyterRemotePath $this$suggestedKind) {
        Intrinsics.checkNotNullParameter((Object)$this$suggestedKind, (String)"<this>");
        String string = $this$suggestedKind.getName();
        if (string == null) {
            return null;
        }
        String name = string;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)name));
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
        FileType fileType2 = fileType;
        return JupyterLanguageKt.isJupyterLanguage((FileType)fileType2) ? SuggestedKind.NOTEBOOK : (fileType2 instanceof UnknownFileType ? null : SuggestedKind.FILE);
    }

    private static final URI sanitizeUrlForVerifying$parseUrlForVerifying(String trimmedUrl) {
        URI uRI;
        try {
            uRI = new URI(trimmedUrl);
        }
        catch (MalformedURLException err) {
            throw new VerifyJupyterUrlError(JupyterRemoteBundle.message("Jupyter.remote.verify.url.malformed", new Object[0]), err);
        }
        catch (URISyntaxException err) {
            if (new Regex("https?://").matches((CharSequence)trimmedUrl)) {
                throw new VerifyJupyterUrlError(JupyterRemoteBundle.message("Jupyter.remote.verify.url.malformed", new Object[0]), err);
            }
            uRI = JupyterRemoteUtilKt.sanitizeUrlForVerifying$parseUrlForVerifying("http://" + trimmedUrl);
        }
        return uRI;
    }
}

