/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterExecutionException;
import com.intellij.jupyter.py.variables.PythonJupyterVarsCommandExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.pydev.ProtocolParser;
import com.jetbrains.python.debugger.values.DataFrameDebugValue;
import com.jetbrains.python.debugger.values.DataFrameDebugValueUtilKt;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J*\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u000f2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0 0\u001f2\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVarsFrameExecutor;", "", "notebookProject", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "getNotebookProject", "()Lcom/intellij/openapi/project/Project;", "getNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "commandExecutor", "Lcom/intellij/jupyter/py/variables/PythonJupyterVarsCommandExecutor;", "executeCommand", "", "command", "parseFrameVars", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "result", "parentValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "parseVar", "parseArrayChunk", "Lcom/jetbrains/python/debugger/ArrayChunk;", "varName", "parseAsyncValues", "", "vars", "", "Lcom/jetbrains/python/debugger/PyFrameAccessor$PyAsyncValue;", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterVarsFrameExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVarsFrameExecutor.kt\ncom/intellij/jupyter/py/variables/JupyterVarsFrameExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public class JupyterVarsFrameExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project notebookProject;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private final PythonJupyterVarsCommandExecutor commandExecutor;
    @NotNull
    private static final Logger LOG;

    public JupyterVarsFrameExecutor(@NotNull Project notebookProject, @NotNull BackedNotebookVirtualFile notebookFile) {
        Intrinsics.checkNotNullParameter((Object)notebookProject, (String)"notebookProject");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        this.notebookProject = notebookProject;
        this.notebookFile = notebookFile;
        this.commandExecutor = PythonJupyterVarsCommandExecutor.Companion.getInstance(this.notebookProject);
    }

    @NotNull
    public final Project getNotebookProject() {
        return this.notebookProject;
    }

    @NotNull
    public final BackedNotebookVirtualFile getNotebookFile() {
        return this.notebookFile;
    }

    @NotNull
    public final String executeCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return PythonJupyterVarsCommandExecutor.executeCommand$default(this.commandExecutor, command, this.notebookFile, null, 4, null);
    }

    @Nullable
    public final XValueChildrenList parseFrameVars(@NotNull String result2, @Nullable PyDebugValue parentValue, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (((CharSequence)result2).length() == 0) {
            LOG.warn("Failed to load Jupyter variables: result is empty");
            return null;
        }
        try {
            List list = ProtocolParser.parseValues((String)result2, (PyFrameAccessor)frameAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parseValues(...)");
            List values = list;
            XValueChildrenList variables2 = new XValueChildrenList(values.size());
            for (PyDebugValue value : values) {
                if (parentValue != null) {
                    value.setParent(parentValue);
                }
                if (value instanceof DataFrameDebugValue && !(parentValue instanceof DataFrameDebugValue)) {
                    String string = ((DataFrameDebugValue)value).getValue();
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        DataFrameDebugValue.InformationColumns informationColumns = DataFrameDebugValueUtilKt.getColumnData((String)it);
                        string = informationColumns;
                        if (informationColumns != null) {
                            it = string;
                            boolean bl2 = false;
                            ((DataFrameDebugValue)value).setColumns((DataFrameDebugValue.InformationColumns)it);
                        }
                    }
                }
                value.setFrameAccessor(frameAccessor);
                variables2.add(value.getVisibleName(), (XValue)value);
            }
            return variables2;
        }
        catch (Exception e) {
            LOG.warn("Failed to load Jupyter variables: " + result2);
            return null;
        }
    }

    @NotNull
    public final PyDebugValue parseVar(@NotNull String result2, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (((CharSequence)result2).length() == 0) {
            Object[] objectArray = new Object[]{result2};
            throw new JupyterExecutionException(JupyterBundle.message((String)"jupyter.failed.to.evaluate.expression", (Object[])objectArray));
        }
        try {
            PyDebugValue pyDebugValue = ProtocolParser.parseValue((String)result2, (PyFrameAccessor)frameAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)pyDebugValue, (String)"parseValue(...)");
            return pyDebugValue;
        }
        catch (Exception e) {
            throw new Exception("Failed to evaluate expression: " + result2);
        }
    }

    @NotNull
    public final ArrayChunk parseArrayChunk(@NotNull String result2, @NotNull String varName, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (((CharSequence)result2).length() == 0) {
            Object[] objectArray = new Object[]{varName};
            throw new JupyterExecutionException(JupyterBundle.message((String)"jupyter.failed.to.load.variable", (Object[])objectArray));
        }
        try {
            ArrayChunk arrayChunk = ProtocolParser.parseArrayValues((String)result2, (PyFrameAccessor)frameAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)arrayChunk, (String)"parseArrayValues(...)");
            return arrayChunk;
        }
        catch (Exception e) {
            throw new Exception("Failed to load array: " + result2);
        }
    }

    public final void parseAsyncValues(@NotNull String result2, @NotNull List<? extends PyFrameAccessor.PyAsyncValue<String>> vars, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        try {
            List list = ProtocolParser.parseValues((String)result2, (PyFrameAccessor)frameAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parseValues(...)");
            List debugValues = list;
            int n = ((Collection)debugValues).size();
            for (int i = 0; i < n; ++i) {
                PyDebugValue resultValue = (PyDebugValue)debugValues.get(i);
                vars.get(i).getCallback().ok((Object)resultValue.getValue());
            }
        }
        catch (Exception e) {
            for (PyFrameAccessor.PyAsyncValue<String> pyAsyncValue : vars) {
                pyAsyncValue.getCallback().error(new PyDebuggerException(result2));
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/py/variables/JupyterVarsFrameExecutor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

