/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugEngineKt;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavaScriptDebugSettingsEditor;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J \u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J,\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/debugger/execution/JavaScriptDebugRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "getRunnerId", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "startSession", "project", "Lcom/intellij/openapi/project/Project;", "engineAndBrowser", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "Lcom/intellij/ide/browsers/WebBrowser;", "Companion", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nJavaScriptDebugRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptDebugRunner.kt\ncom/intellij/javascript/debugger/execution/JavaScriptDebugRunner\n+ 2 DebuggableProgramRunner.kt\ncom/intellij/javascript/debugger/execution/DebuggableProgramRunnerKt\n*L\n1#1,89:1\n40#2,7:90\n*S KotlinDebug\n*F\n+ 1 JavaScriptDebugRunner.kt\ncom/intellij/javascript/debugger/execution/JavaScriptDebugRunner\n*L\n86#1:90,7\n*E\n"})
public class JavaScriptDebugRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof JavaScriptDebugConfiguration && (Intrinsics.areEqual((Object)executorId, (Object)"Debug") || Intrinsics.areEqual((Object)executorId, (Object)"Run"));
    }

    @NotNull
    public String getRunnerId() {
        return "JavascriptDebugRunner";
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        boolean isRun = Intrinsics.areEqual((Object)environment.getExecutor().getId(), (Object)"Run");
        Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser = Companion.findEngineAndBrowser(configuration.getEngineId());
        if (isRun) {
            BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
            String string = configuration.getUri();
            Intrinsics.checkNotNull((Object)string);
            browserLauncher.browse(string, (WebBrowser)engineAndBrowser.second, environment.getProject());
            return Promises.resolvedPromise();
        }
        JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)engineAndBrowser.first;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = engineAndBrowser.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        Promise promise2 = javaScriptDebugEngine.prepareDebugger(project, (WebBrowser)object).then(arg_0 -> JavaScriptDebugRunner.execute$lambda$1(arg_0 -> JavaScriptDebugRunner.execute$lambda$0(this, environment, engineAndBrowser, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    private final RunContentDescriptor startSession(Project project, ExecutionEnvironment environment, Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser) {
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        String string = configuration.getUri();
        Intrinsics.checkNotNull((Object)string);
        Url url = Urls.newFromIdea((CharSequence)string);
        DebuggableFileFinderImpl defaultFileFinder = new DebuggableFileFinderImpl(project, url);
        DebuggableFileFinder fileFinder = null;
        if (url.isInLocalFileSystem()) {
            fileFinder = defaultFileFinder;
        } else {
            List<RemoteUrlMappingBean> list = configuration.getMappings();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getMappings(...)");
            fileFinder = new RemoteDebuggingFileFinder(RemoteDebuggingFileFinderKt.createUrlToLocalMap(list), defaultFileFinder);
        }
        boolean $i$f$startSession = false;
        boolean $i$f$xDebugProcessStarter = false;
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(engineAndBrowser, fileFinder, url){
            final /* synthetic */ Pair $engineAndBrowser$inlined;
            final /* synthetic */ DebuggableFileFinder $fileFinder$inlined;
            final /* synthetic */ Url $url$inlined;
            {
                this.$engineAndBrowser$inlined = pair;
                this.$fileFinder$inlined = debuggableFileFinder;
                this.$url$inlined = url;
            }

            public XDebugProcess start(XDebugSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                XDebugSession it = session2;
                boolean bl = false;
                JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)this.$engineAndBrowser$inlined.first;
                Object object = this.$engineAndBrowser$inlined.second;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                return javaScriptDebugEngine.createDebugProcess(it, (WebBrowser)object, this.$fileFinder$inlined, this.$url$inlined, null, true);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSession(...)");
        RunContentDescriptor runContentDescriptor = xDebugSession.getRunContentDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor, (String)"getRunContentDescriptor(...)");
        return runContentDescriptor;
    }

    private static final RunContentDescriptor execute$lambda$0(JavaScriptDebugRunner this$0, ExecutionEnvironment $environment, Pair $engineAndBrowser, Unit it) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = $environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this$0.startSession(project, $environment, (Pair<JavaScriptDebugEngine, WebBrowser>)$engineAndBrowser);
    }

    private static final RunContentDescriptor execute$lambda$1(Function1 $tmp0, Object p0) {
        return (RunContentDescriptor)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/debugger/execution/JavaScriptDebugRunner$Companion;", "", "<init>", "()V", "findEngineAndBrowser", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "Lcom/intellij/ide/browsers/WebBrowser;", "browserIdOrNameOrEngineId", "", "intellij.javascript.debugger"})
    @SourceDebugExtension(value={"SMAP\nJavaScriptDebugRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptDebugRunner.kt\ncom/intellij/javascript/debugger/execution/JavaScriptDebugRunner$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<JavaScriptDebugEngine, WebBrowser> findEngineAndBrowser(@Nullable String browserIdOrNameOrEngineId) {
            WebBrowser webBrowser;
            JavaScriptDebugEngine debugEngine;
            Pair<JavaScriptDebugEngine, WebBrowser> info;
            String string = browserIdOrNameOrEngineId;
            if (string != null) {
                String it = string;
                boolean bl = false;
                v1 = JavaScriptDebugEngine.Companion.findByBrowserIdOrName(it);
            } else {
                v1 = info = null;
            }
            if (info != null) {
                return info;
            }
            String string2 = browserIdOrNameOrEngineId;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                v3 = JavaScriptDebugEngineKt.findByBrowserIdOrNameOrEngineId(it);
            } else {
                v3 = debugEngine = null;
            }
            if (debugEngine == null) {
                List list = WebBrowserManager.getInstance().getBrowsers(JavaScriptDebugSettingsEditor.BROWSER_CONDITION);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBrowsers(...)");
                WebBrowser defaultBrowser = (WebBrowser)CollectionsKt.firstOrNull((List)list);
                if (defaultBrowser == null) {
                    debugEngine = (JavaScriptDebugEngine)CollectionsKt.first(JavaScriptDebugEngineKt.getEngines());
                } else {
                    debugEngine = JavaScriptDebugEngine.Companion.findByBrowser(defaultBrowser);
                    Pair pair = Pair.create((Object)debugEngine, (Object)defaultBrowser);
                    Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                    return pair;
                }
            }
            if ((webBrowser = debugEngine.getBrowser()) == null) {
                WebBrowser webBrowser2 = WebBrowserManager.getInstance().getFirstBrowser(debugEngine.getBrowserFamily());
                webBrowser = webBrowser2;
                Intrinsics.checkNotNullExpressionValue((Object)webBrowser2, (String)"getFirstBrowser(...)");
            }
            WebBrowser notNullBrowser = webBrowser;
            Pair pair = Pair.create((Object)debugEngine, (Object)notNullBrowser);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

