/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection.incompatible;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.python.django.lang.template.inspection.incompatible.DjangoCompatibilityInfo;
import com.jetbrains.django.lang.template.tags.Jinja2BlockTransTag;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DjangoBlockTransTrimmedCompatibilityInfo
extends DjangoCompatibilityInfo<Jinja2BlockTransTag> {
    private static final Pattern TRIMMED_PATTERN = Jinja2BlockTransTag.createPatternForKeyword((String)"trimmed");

    DjangoBlockTransTrimmedCompatibilityInfo() {
        super(DJANGO_1_7, "trimmed", Jinja2BlockTransTag.class);
    }

    @Override
    @Nullable
    ProblemDescriptor processVersion(boolean isVersionGreater, @NotNull Jinja2BlockTransTag tag, @NotNull InspectionManager inspectionManager) {
        if (tag == null) {
            DjangoBlockTransTrimmedCompatibilityInfo.$$$reportNull$$$0(0);
        }
        if (inspectionManager == null) {
            DjangoBlockTransTrimmedCompatibilityInfo.$$$reportNull$$$0(1);
        }
        if (!isVersionGreater && TRIMMED_PATTERN.matcher(tag.getText()).matches()) {
            return inspectionManager.createProblemDescriptor((PsiElement)tag, this.getMessage(), true, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/django/lang/template/inspection/incompatible/DjangoBlockTransTrimmedCompatibilityInfo";
        objectArray[2] = "processVersion";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

