/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection.incompatible;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jinja.tags.Jinja2Tag;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.packaging.PyRequirement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class DjangoCompatibilityInfo<T extends Jinja2Tag> {
    protected static final PyRequirement DJANGO_1_7 = DjangoUtil.createRequirementAtLeast((int)1, (int)7);
    protected static final PyRequirement DJANGO_1_8 = DjangoUtil.createRequirementAtLeast((int)1, (int)8);
    protected static final PyRequirement DJANGO_1_9 = DjangoUtil.createRequirementAtLeast((int)1, (int)9);
    protected static final PyRequirement DJANGO_1_10 = DjangoUtil.createRequirementAtLeast((int)1, (int)10);
    protected static final PyRequirement DJANGO_1_11 = DjangoUtil.createRequirementAtLeast((int)1, (int)11);
    private final PyRequirement myRequirement;
    @NotNull
    private final Class<? extends Jinja2Tag> myTagClass;
    @Nullable
    @Nls
    private final String myMessage;

    protected DjangoCompatibilityInfo(@NotNull PyRequirement requirement, @Nullable String what, @NotNull Class<T> tagClass) {
        if (requirement == null) {
            DjangoCompatibilityInfo.$$$reportNull$$$0(0);
        }
        if (tagClass == null) {
            DjangoCompatibilityInfo.$$$reportNull$$$0(1);
        }
        this.myRequirement = requirement;
        this.myTagClass = tagClass;
        this.myMessage = what != null ? DjangoBundle.message((String)"inspection.incompatible.error", (Object[])new Object[]{what, String.format("%s", requirement.getPresentableText())}) : null;
    }

    @NotNull
    PyRequirement getRequirement() {
        PyRequirement pyRequirement = this.myRequirement;
        if (pyRequirement == null) {
            DjangoCompatibilityInfo.$$$reportNull$$$0(2);
        }
        return pyRequirement;
    }

    @NotNull
    Class<? extends Jinja2Tag> getTagClass() {
        Class<? extends Jinja2Tag> clazz = this.myTagClass;
        if (clazz == null) {
            DjangoCompatibilityInfo.$$$reportNull$$$0(3);
        }
        return clazz;
    }

    @Nullable
    abstract ProblemDescriptor processVersion(boolean var1, @NotNull T var2, @NotNull InspectionManager var3);

    @NotNull
    @Nls
    protected final String getMessage() {
        if (this.myMessage == null) {
            throw new IllegalStateException("'what' not provided, can't use this API");
        }
        String string = this.myMessage;
        if (string == null) {
            DjangoCompatibilityInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/lang/template/inspection/incompatible/DjangoCompatibilityInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/lang/template/inspection/incompatible/DjangoCompatibilityInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequirement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

