// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package bgp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetBgpRoutePoliciesParams creates a new GetBgpRoutePoliciesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetBgpRoutePoliciesParams() *GetBgpRoutePoliciesParams {
	return &GetBgpRoutePoliciesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetBgpRoutePoliciesParamsWithTimeout creates a new GetBgpRoutePoliciesParams object
// with the ability to set a timeout on a request.
func NewGetBgpRoutePoliciesParamsWithTimeout(timeout time.Duration) *GetBgpRoutePoliciesParams {
	return &GetBgpRoutePoliciesParams{
		timeout: timeout,
	}
}

// NewGetBgpRoutePoliciesParamsWithContext creates a new GetBgpRoutePoliciesParams object
// with the ability to set a context for a request.
func NewGetBgpRoutePoliciesParamsWithContext(ctx context.Context) *GetBgpRoutePoliciesParams {
	return &GetBgpRoutePoliciesParams{
		Context: ctx,
	}
}

// NewGetBgpRoutePoliciesParamsWithHTTPClient creates a new GetBgpRoutePoliciesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetBgpRoutePoliciesParamsWithHTTPClient(client *http.Client) *GetBgpRoutePoliciesParams {
	return &GetBgpRoutePoliciesParams{
		HTTPClient: client,
	}
}

/*
GetBgpRoutePoliciesParams contains all the parameters to send to the API endpoint

	for the get bgp route policies operation.

	Typically these are written to a http.Request.
*/
type GetBgpRoutePoliciesParams struct {

	/* RouterAsn.

	     Autonomous System Number (ASN) identifying a BGP virtual router instance.
	If not specified, all virtual router instances are selected.

	*/
	RouterAsn *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get bgp route policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetBgpRoutePoliciesParams) WithDefaults() *GetBgpRoutePoliciesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get bgp route policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetBgpRoutePoliciesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get bgp route policies params
func (o *GetBgpRoutePoliciesParams) WithTimeout(timeout time.Duration) *GetBgpRoutePoliciesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get bgp route policies params
func (o *GetBgpRoutePoliciesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get bgp route policies params
func (o *GetBgpRoutePoliciesParams) WithContext(ctx context.Context) *GetBgpRoutePoliciesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get bgp route policies params
func (o *GetBgpRoutePoliciesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get bgp route policies params
func (o *GetBgpRoutePoliciesParams) WithHTTPClient(client *http.Client) *GetBgpRoutePoliciesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get bgp route policies params
func (o *GetBgpRoutePoliciesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithRouterAsn adds the routerAsn to the get bgp route policies params
func (o *GetBgpRoutePoliciesParams) WithRouterAsn(routerAsn *int64) *GetBgpRoutePoliciesParams {
	o.SetRouterAsn(routerAsn)
	return o
}

// SetRouterAsn adds the routerAsn to the get bgp route policies params
func (o *GetBgpRoutePoliciesParams) SetRouterAsn(routerAsn *int64) {
	o.RouterAsn = routerAsn
}

// WriteToRequest writes these params to a swagger request
func (o *GetBgpRoutePoliciesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.RouterAsn != nil {

		// query param router_asn
		var qrRouterAsn int64

		if o.RouterAsn != nil {
			qrRouterAsn = *o.RouterAsn
		}
		qRouterAsn := swag.FormatInt64(qrRouterAsn)
		if qRouterAsn != "" {

			if err := r.SetQueryParam("router_asn", qRouterAsn); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
