/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializerKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "protocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "constantCache", "", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getConstantCache", "()Ljava/util/Map;", "loadConstant", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "callableId", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "isUnsigned", "", "fir-deserialization"})
@SourceDebugExtension(value={"SMAP\nFirConstDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstDeserializer.kt\norg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public class FirConstDeserializer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final SerializerExtensionProtocol protocol;
    @NotNull
    private final Map<CallableId, FirExpression> constantCache;

    public FirConstDeserializer(@NotNull FirSession session2, @NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        this.session = session2;
        this.protocol = protocol;
        this.constantCache = new LinkedHashMap();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    protected final Map<CallableId, FirExpression> getConstantCache() {
        return this.constantCache;
    }

    @Nullable
    public FirExpression loadConstant(@NotNull ProtoBuf.Property propertyProto, @NotNull CallableId callableId, @NotNull NameResolver nameResolver, boolean isUnsigned) {
        FirExpression firExpression;
        Intrinsics.checkNotNullParameter((Object)propertyProto, (String)"propertyProto");
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        if (!Flags.HAS_CONSTANT.get(propertyProto.getFlags()).booleanValue()) {
            return null;
        }
        FirExpression firExpression2 = this.constantCache.get(callableId);
        if (firExpression2 != null) {
            FirExpression it = firExpression2;
            boolean bl = false;
            return it;
        }
        ProtoBuf.Annotation.Argument.Value value2 = ProtoBufUtilKt.getExtensionOrNull(propertyProto, this.protocol.getCompileTimeValue());
        if (value2 == null) {
            return null;
        }
        ProtoBuf.Annotation.Argument.Value value3 = value2;
        FirExpression firExpression3 = FirConstDeserializerKt.buildFirConstant(value3, null, value3.getType().name(), nameResolver, isUnsigned);
        if (firExpression3 != null) {
            FirExpression firExpression4;
            FirExpression it = firExpression4 = firExpression3;
            boolean bl = false;
            this.constantCache.put(callableId, it);
            firExpression = firExpression4;
        } else {
            firExpression = null;
        }
        return firExpression;
    }
}

