// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceACLFrontendOKCode is the HTTP code returned for type ReplaceACLFrontendOK
const ReplaceACLFrontendOKCode int = 200

/*
ReplaceACLFrontendOK ACL line replaced

swagger:response replaceAclFrontendOK
*/
type ReplaceACLFrontendOK struct {

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewReplaceACLFrontendOK creates ReplaceACLFrontendOK with default headers values
func NewReplaceACLFrontendOK() *ReplaceACLFrontendOK {

	return &ReplaceACLFrontendOK{}
}

// WithPayload adds the payload to the replace Acl frontend o k response
func (o *ReplaceACLFrontendOK) WithPayload(payload *models.ACL) *ReplaceACLFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl frontend o k response
func (o *ReplaceACLFrontendOK) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceACLFrontendAcceptedCode is the HTTP code returned for type ReplaceACLFrontendAccepted
const ReplaceACLFrontendAcceptedCode int = 202

/*
ReplaceACLFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceAclFrontendAccepted
*/
type ReplaceACLFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewReplaceACLFrontendAccepted creates ReplaceACLFrontendAccepted with default headers values
func NewReplaceACLFrontendAccepted() *ReplaceACLFrontendAccepted {

	return &ReplaceACLFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace Acl frontend accepted response
func (o *ReplaceACLFrontendAccepted) WithReloadID(reloadID string) *ReplaceACLFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Acl frontend accepted response
func (o *ReplaceACLFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Acl frontend accepted response
func (o *ReplaceACLFrontendAccepted) WithPayload(payload *models.ACL) *ReplaceACLFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl frontend accepted response
func (o *ReplaceACLFrontendAccepted) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceACLFrontendBadRequestCode is the HTTP code returned for type ReplaceACLFrontendBadRequest
const ReplaceACLFrontendBadRequestCode int = 400

/*
ReplaceACLFrontendBadRequest Bad request

swagger:response replaceAclFrontendBadRequest
*/
type ReplaceACLFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceACLFrontendBadRequest creates ReplaceACLFrontendBadRequest with default headers values
func NewReplaceACLFrontendBadRequest() *ReplaceACLFrontendBadRequest {

	return &ReplaceACLFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Acl frontend bad request response
func (o *ReplaceACLFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceACLFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Acl frontend bad request response
func (o *ReplaceACLFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Acl frontend bad request response
func (o *ReplaceACLFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceACLFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl frontend bad request response
func (o *ReplaceACLFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceACLFrontendNotFoundCode is the HTTP code returned for type ReplaceACLFrontendNotFound
const ReplaceACLFrontendNotFoundCode int = 404

/*
ReplaceACLFrontendNotFound The specified resource was not found

swagger:response replaceAclFrontendNotFound
*/
type ReplaceACLFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceACLFrontendNotFound creates ReplaceACLFrontendNotFound with default headers values
func NewReplaceACLFrontendNotFound() *ReplaceACLFrontendNotFound {

	return &ReplaceACLFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Acl frontend not found response
func (o *ReplaceACLFrontendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceACLFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Acl frontend not found response
func (o *ReplaceACLFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Acl frontend not found response
func (o *ReplaceACLFrontendNotFound) WithPayload(payload *models.Error) *ReplaceACLFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl frontend not found response
func (o *ReplaceACLFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceACLFrontendDefault General Error

swagger:response replaceAclFrontendDefault
*/
type ReplaceACLFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceACLFrontendDefault creates ReplaceACLFrontendDefault with default headers values
func NewReplaceACLFrontendDefault(code int) *ReplaceACLFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceACLFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace Acl frontend default response
func (o *ReplaceACLFrontendDefault) WithStatusCode(code int) *ReplaceACLFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace Acl frontend default response
func (o *ReplaceACLFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace Acl frontend default response
func (o *ReplaceACLFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceACLFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Acl frontend default response
func (o *ReplaceACLFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Acl frontend default response
func (o *ReplaceACLFrontendDefault) WithPayload(payload *models.Error) *ReplaceACLFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Acl frontend default response
func (o *ReplaceACLFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceACLFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
