// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package traces

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateTracesCreatedCode is the HTTP code returned for type CreateTracesCreated
const CreateTracesCreatedCode int = 201

/*
CreateTracesCreated Traces section created

swagger:response createTracesCreated
*/
type CreateTracesCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Traces `json:"body,omitempty"`
}

// NewCreateTracesCreated creates CreateTracesCreated with default headers values
func NewCreateTracesCreated() *CreateTracesCreated {

	return &CreateTracesCreated{}
}

// WithPayload adds the payload to the create traces created response
func (o *CreateTracesCreated) WithPayload(payload *models.Traces) *CreateTracesCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create traces created response
func (o *CreateTracesCreated) SetPayload(payload *models.Traces) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTracesCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTracesAcceptedCode is the HTTP code returned for type CreateTracesAccepted
const CreateTracesAcceptedCode int = 202

/*
CreateTracesAccepted Configuration change accepted and reload requested

swagger:response createTracesAccepted
*/
type CreateTracesAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Traces `json:"body,omitempty"`
}

// NewCreateTracesAccepted creates CreateTracesAccepted with default headers values
func NewCreateTracesAccepted() *CreateTracesAccepted {

	return &CreateTracesAccepted{}
}

// WithReloadID adds the reloadId to the create traces accepted response
func (o *CreateTracesAccepted) WithReloadID(reloadID string) *CreateTracesAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create traces accepted response
func (o *CreateTracesAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create traces accepted response
func (o *CreateTracesAccepted) WithPayload(payload *models.Traces) *CreateTracesAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create traces accepted response
func (o *CreateTracesAccepted) SetPayload(payload *models.Traces) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTracesAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTracesBadRequestCode is the HTTP code returned for type CreateTracesBadRequest
const CreateTracesBadRequestCode int = 400

/*
CreateTracesBadRequest Bad request

swagger:response createTracesBadRequest
*/
type CreateTracesBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTracesBadRequest creates CreateTracesBadRequest with default headers values
func NewCreateTracesBadRequest() *CreateTracesBadRequest {

	return &CreateTracesBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create traces bad request response
func (o *CreateTracesBadRequest) WithConfigurationVersion(configurationVersion string) *CreateTracesBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create traces bad request response
func (o *CreateTracesBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create traces bad request response
func (o *CreateTracesBadRequest) WithPayload(payload *models.Error) *CreateTracesBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create traces bad request response
func (o *CreateTracesBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTracesBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateTracesConflictCode is the HTTP code returned for type CreateTracesConflict
const CreateTracesConflictCode int = 409

/*
CreateTracesConflict The specified resource already exists

swagger:response createTracesConflict
*/
type CreateTracesConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTracesConflict creates CreateTracesConflict with default headers values
func NewCreateTracesConflict() *CreateTracesConflict {

	return &CreateTracesConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create traces conflict response
func (o *CreateTracesConflict) WithConfigurationVersion(configurationVersion string) *CreateTracesConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create traces conflict response
func (o *CreateTracesConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create traces conflict response
func (o *CreateTracesConflict) WithPayload(payload *models.Error) *CreateTracesConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create traces conflict response
func (o *CreateTracesConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTracesConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateTracesDefault General Error

swagger:response createTracesDefault
*/
type CreateTracesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateTracesDefault creates CreateTracesDefault with default headers values
func NewCreateTracesDefault(code int) *CreateTracesDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateTracesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create traces default response
func (o *CreateTracesDefault) WithStatusCode(code int) *CreateTracesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create traces default response
func (o *CreateTracesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create traces default response
func (o *CreateTracesDefault) WithConfigurationVersion(configurationVersion string) *CreateTracesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create traces default response
func (o *CreateTracesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create traces default response
func (o *CreateTracesDefault) WithPayload(payload *models.Error) *CreateTracesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create traces default response
func (o *CreateTracesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateTracesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
