```{eval-rst}
.. role:: hidden
    :class: hidden-section
```

# Probability distributions - torch.distributions

```{eval-rst}
.. automodule:: torch.distributions
```

```{eval-rst}
.. currentmodule:: torch.distributions
```

## {hidden}`Distribution`

```{eval-rst}
.. currentmodule:: torch.distributions.distribution
```

```{eval-rst}
.. autoclass:: Distribution
    :members:
    :show-inheritance:
```

## {hidden}`ExponentialFamily`

```{eval-rst}
.. currentmodule:: torch.distributions.exp_family
```

```{eval-rst}
.. autoclass:: ExponentialFamily
    :members:
    :show-inheritance:
```

## {hidden}`Bernoulli`

```{eval-rst}
.. currentmodule:: torch.distributions.bernoulli
```

```{eval-rst}
.. autoclass:: Bernoulli
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Beta`

```{eval-rst}
.. currentmodule:: torch.distributions.beta
```

```{eval-rst}
.. autoclass:: Beta
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Binomial`

```{eval-rst}
.. currentmodule:: torch.distributions.binomial
```

```{eval-rst}
.. autoclass:: Binomial
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Categorical`

```{eval-rst}
.. currentmodule:: torch.distributions.categorical
```

```{eval-rst}
.. autoclass:: Categorical
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Cauchy`

```{eval-rst}
.. currentmodule:: torch.distributions.cauchy
```

```{eval-rst}
.. autoclass:: Cauchy
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Chi2`

```{eval-rst}
.. currentmodule:: torch.distributions.chi2
```

```{eval-rst}
.. autoclass:: Chi2
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`ContinuousBernoulli`

```{eval-rst}
.. currentmodule:: torch.distributions.continuous_bernoulli
```

```{eval-rst}
.. autoclass:: ContinuousBernoulli
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Dirichlet`

```{eval-rst}
.. currentmodule:: torch.distributions.dirichlet
```

```{eval-rst}
.. autoclass:: Dirichlet
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Exponential`

```{eval-rst}
.. currentmodule:: torch.distributions.exponential
```

```{eval-rst}
.. autoclass:: Exponential
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`FisherSnedecor`

```{eval-rst}
.. currentmodule:: torch.distributions.fishersnedecor
```

```{eval-rst}
.. autoclass:: FisherSnedecor
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Gamma`

```{eval-rst}
.. currentmodule:: torch.distributions.gamma
```

```{eval-rst}
.. autoclass:: Gamma
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`GeneralizedPareto`

```{eval-rst}
.. currentmodule:: torch.distributions.generalized_pareto
```

```{eval-rst}
.. autoclass:: GeneralizedPareto
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Geometric`

```{eval-rst}
.. currentmodule:: torch.distributions.geometric
```

```{eval-rst}
.. autoclass:: Geometric
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Gumbel`

```{eval-rst}
.. currentmodule:: torch.distributions.gumbel
```

```{eval-rst}
.. autoclass:: Gumbel
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`HalfCauchy`

```{eval-rst}
.. currentmodule:: torch.distributions.half_cauchy
```

```{eval-rst}
.. autoclass:: HalfCauchy
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`HalfNormal`

```{eval-rst}
.. currentmodule:: torch.distributions.half_normal
```

```{eval-rst}
.. autoclass:: HalfNormal
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Independent`

```{eval-rst}
.. currentmodule:: torch.distributions.independent
```

```{eval-rst}
.. autoclass:: Independent
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`InverseGamma`

```{eval-rst}
.. currentmodule:: torch.distributions.inverse_gamma
```

```{eval-rst}
.. autoclass:: InverseGamma
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Kumaraswamy`

```{eval-rst}
.. currentmodule:: torch.distributions.kumaraswamy
```

```{eval-rst}
.. autoclass:: Kumaraswamy
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`LKJCholesky`

```{eval-rst}
.. currentmodule:: torch.distributions.lkj_cholesky
```

```{eval-rst}
.. autoclass:: LKJCholesky
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Laplace`

```{eval-rst}
.. currentmodule:: torch.distributions.laplace
```

```{eval-rst}
.. autoclass:: Laplace
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`LogNormal`

```{eval-rst}
.. currentmodule:: torch.distributions.log_normal
```

```{eval-rst}
.. autoclass:: LogNormal
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`LowRankMultivariateNormal`

```{eval-rst}
.. currentmodule:: torch.distributions.lowrank_multivariate_normal
```

```{eval-rst}
.. autoclass:: LowRankMultivariateNormal
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`MixtureSameFamily`

```{eval-rst}
.. currentmodule:: torch.distributions.mixture_same_family
```

```{eval-rst}
.. autoclass:: MixtureSameFamily
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Multinomial`

```{eval-rst}
.. currentmodule:: torch.distributions.multinomial
```

```{eval-rst}
.. autoclass:: Multinomial
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`MultivariateNormal`

```{eval-rst}
.. currentmodule:: torch.distributions.multivariate_normal
```

```{eval-rst}
.. autoclass:: MultivariateNormal
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`NegativeBinomial`

```{eval-rst}
.. currentmodule:: torch.distributions.negative_binomial
```

```{eval-rst}
.. autoclass:: NegativeBinomial
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Normal`

```{eval-rst}
.. currentmodule:: torch.distributions.normal
```

```{eval-rst}
.. autoclass:: Normal
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`OneHotCategorical`

```{eval-rst}
.. currentmodule:: torch.distributions.one_hot_categorical
```

```{eval-rst}
.. autoclass:: OneHotCategorical
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Pareto`

```{eval-rst}
.. currentmodule:: torch.distributions.pareto
```

```{eval-rst}
.. autoclass:: Pareto
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Poisson`

```{eval-rst}
.. currentmodule:: torch.distributions.poisson
```

```{eval-rst}
.. autoclass:: Poisson
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`RelaxedBernoulli`

```{eval-rst}
.. currentmodule:: torch.distributions.relaxed_bernoulli
```

```{eval-rst}
.. autoclass:: RelaxedBernoulli
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`LogitRelaxedBernoulli`

```{eval-rst}
.. currentmodule:: torch.distributions.relaxed_bernoulli
```

```{eval-rst}
.. autoclass:: LogitRelaxedBernoulli
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`RelaxedOneHotCategorical`

```{eval-rst}
.. currentmodule:: torch.distributions.relaxed_categorical
```

```{eval-rst}
.. autoclass:: RelaxedOneHotCategorical
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`StudentT`

```{eval-rst}
.. currentmodule:: torch.distributions.studentT
```

```{eval-rst}
.. autoclass:: StudentT
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`TransformedDistribution`

```{eval-rst}
.. currentmodule:: torch.distributions.transformed_distribution
```

```{eval-rst}
.. autoclass:: TransformedDistribution
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Uniform`

```{eval-rst}
.. currentmodule:: torch.distributions.uniform
```

```{eval-rst}
.. autoclass:: Uniform
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`VonMises`

```{eval-rst}
.. currentmodule:: torch.distributions.von_mises
```

```{eval-rst}
.. autoclass:: VonMises
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Weibull`

```{eval-rst}
.. currentmodule:: torch.distributions.weibull
```

```{eval-rst}
.. autoclass:: Weibull
    :members:
    :undoc-members:
    :show-inheritance:
```

## {hidden}`Wishart`

```{eval-rst}
.. currentmodule:: torch.distributions.wishart
```

```{eval-rst}
.. autoclass:: Wishart
    :members:
    :undoc-members:
    :show-inheritance:
```

## `KL Divergence`

```{eval-rst}
.. automodule:: torch.distributions.kl
```

```{eval-rst}
.. currentmodule:: torch.distributions.kl
```

```{eval-rst}
.. autofunction:: kl_divergence
```

```{eval-rst}
.. autofunction:: register_kl
```

## `Transforms`

```{eval-rst}
.. automodule:: torch.distributions.transforms
    :members:
    :member-order: bysource
```

## `Constraints`

```{eval-rst}
.. automodule:: torch.distributions.constraints
    :members:
    :member-order: bysource
```

## `Constraint Registry`

```{eval-rst}
.. automodule:: torch.distributions.constraint_registry
    :members:
    :member-order: bysource
```

% This module needs to be documented. Adding here in the meantime

% for tracking purposes

```{eval-rst}
.. py:module:: torch.distributions.bernoulli

.. py:module:: torch.distributions.beta

.. py:module:: torch.distributions.binomial

.. py:module:: torch.distributions.categorical

.. py:module:: torch.distributions.cauchy

.. py:module:: torch.distributions.chi2

.. py:module:: torch.distributions.continuous_bernoulli

.. py:module:: torch.distributions.dirichlet

.. py:module:: torch.distributions.distribution

.. py:module:: torch.distributions.exp_family

.. py:module:: torch.distributions.exponential

.. py:module:: torch.distributions.fishersnedecor

.. py:module:: torch.distributions.gamma

.. py:module:: torch.distributions.generalized_pareto

.. py:module:: torch.distributions.geometric

.. py:module:: torch.distributions.gumbel

.. py:module:: torch.distributions.half_cauchy

.. py:module:: torch.distributions.half_normal

.. py:module:: torch.distributions.independent

.. py:module:: torch.distributions.inverse_gamma

.. py:module:: torch.distributions.kumaraswamy

.. py:module:: torch.distributions.laplace

.. py:module:: torch.distributions.lkj_cholesky

.. py:module:: torch.distributions.log_normal

.. py:module:: torch.distributions.logistic_normal

.. py:module:: torch.distributions.lowrank_multivariate_normal

.. py:module:: torch.distributions.mixture_same_family

.. py:module:: torch.distributions.multinomial

.. py:module:: torch.distributions.multivariate_normal

.. py:module:: torch.distributions.negative_binomial

.. py:module:: torch.distributions.normal

.. py:module:: torch.distributions.one_hot_categorical

.. py:module:: torch.distributions.pareto

.. py:module:: torch.distributions.poisson

.. py:module:: torch.distributions.relaxed_bernoulli

.. py:module:: torch.distributions.relaxed_categorical

.. py:module:: torch.distributions.studentT

.. py:module:: torch.distributions.transformed_distribution

.. py:module:: torch.distributions.uniform

.. py:module:: torch.distributions.utils

.. py:module:: torch.distributions.von_mises

.. py:module:: torch.distributions.weibull

.. py:module:: torch.distributions.wishart
```
