#!/bin/bash

# This script uses mingw and the GNU tool chain for cross-compiling under
# linux. You can change the variables to not cross-compile for running
# with MSYS on windows. Whichever you choose, you need to provide the
# following as described and review the commands.

# static libs: libiconv, libintl, winpthread, libenet
# shared libs: sdl2, openal, curl

# libenet is not currently provided as a package in mingw distributions.
# The thing to check is that if pkgconfig is used, the one generated by
# libenet's make install does not have the proper libs for windows.
# Check that -lws2_32 and -lwinmm are libs in libenet.pc, as pkgconfig files
# are preferred by the configure script.

# Finally, you will need TeXLive to build the manual.

HOST=i686-w64-mingw32.shared
HOST_OPT=--host=$HOST
STRIP=${HOST}-strip

./configure --disable-fhs $HOST_OPT
make -j6
make install DESTDIR=`pwd`/dest bindir=/ docdir=/ pkgdatadir=/ localedir=/locale
$STRIP dest/7kaa.exe

cd doc
latexmk
cd ..
cp doc/main.pdf dest/7kaa-manual.pdf

# Still need to add music and dlls
# then run NSIS on install.nsi
