/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.completion.cloud.context;

import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.sql.completion.cloud.context.ContextBuilder;
import com.intellij.util.text.ImmutableCharSequence;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 J\u001c\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010!\u001a\u00020\u0012J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u001e\u0010\"\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010!\u001a\u00020\u0012H\u0002J\b\u0010#\u001a\u00020\u001bH\u0002J\u0006\u0010$\u001a\u00020%R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0007\"\u0004\b\u0019\u0010\t\u00a8\u0006&"}, d2={"Lcom/intellij/ml/llm/sql/completion/cloud/context/DecomposedTextBuilder;", "", "<init>", "()V", "prefix", "Lcom/intellij/ml/llm/sql/completion/cloud/context/ContextBuilder$ContextNode$Text;", "getPrefix", "()Lcom/intellij/ml/llm/sql/completion/cloud/context/ContextBuilder$ContextNode$Text;", "setPrefix", "(Lcom/intellij/ml/llm/sql/completion/cloud/context/ContextBuilder$ContextNode$Text;)V", "middleText", "Lcom/intellij/ml/llm/privacy/PrivacySafe;", "Lcom/intellij/util/text/ImmutableCharSequence;", "getMiddleText", "()Lcom/intellij/ml/llm/privacy/PrivacySafe;", "setMiddleText", "(Lcom/intellij/ml/llm/privacy/PrivacySafe;)V", "middleTokens", "", "getMiddleTokens", "()I", "setMiddleTokens", "(I)V", "lastFoldable", "getLastFoldable", "setLastFoldable", "appendFoldable", "", "text", "appendText", "appendNodeText", "c", "Lcom/intellij/ml/llm/sql/completion/cloud/context/ContextBuilder$ContextNode;", "tokenCount", "appendTextImpl", "flushLast", "build", "Lcom/intellij/ml/llm/sql/completion/cloud/context/ContextBuilder$ContextNode$Dynamic$DecomposedText;", "intellij.ml.llm.sql.completion"})
public final class DecomposedTextBuilder {
    @Nullable
    private ContextBuilder.ContextNode.Text prefix;
    @NotNull
    private PrivacySafe<? extends ImmutableCharSequence> middleText = ContextBuilder.Companion.getEmptyStr();
    private int middleTokens;
    @Nullable
    private ContextBuilder.ContextNode.Text lastFoldable;

    @Nullable
    public final ContextBuilder.ContextNode.Text getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(@Nullable ContextBuilder.ContextNode.Text text2) {
        this.prefix = text2;
    }

    @NotNull
    public final PrivacySafe<ImmutableCharSequence> getMiddleText() {
        return this.middleText;
    }

    public final void setMiddleText(@NotNull PrivacySafe<? extends ImmutableCharSequence> privacySafe) {
        Intrinsics.checkNotNullParameter(privacySafe, (String)"<set-?>");
        this.middleText = privacySafe;
    }

    public final int getMiddleTokens() {
        return this.middleTokens;
    }

    public final void setMiddleTokens(int n) {
        this.middleTokens = n;
    }

    @Nullable
    public final ContextBuilder.ContextNode.Text getLastFoldable() {
        return this.lastFoldable;
    }

    public final void setLastFoldable(@Nullable ContextBuilder.ContextNode.Text text2) {
        this.lastFoldable = text2;
    }

    public final void appendFoldable(@Nullable ContextBuilder.ContextNode.Text text2) {
        if (text2 == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.lastFoldable, (Object)text2)) {
            return;
        }
        this.flushLast();
        this.lastFoldable = text2;
    }

    public final void appendText(@Nullable ContextBuilder.ContextNode.Text text2) {
        if (text2 == null || ((CharSequence)text2.getText()).length() == 0) {
            return;
        }
        this.flushLast();
        this.appendTextImpl(text2);
    }

    public final void appendNodeText(@NotNull ContextBuilder.ContextNode c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (c instanceof ContextBuilder.ContextNode.Expandable && (!((ContextBuilder.ContextNode.Expandable)c).isExpanded() || ((ContextBuilder.ContextNode.Expandable)c).getChildren().isEmpty())) {
            this.appendFoldable(((ContextBuilder.ContextNode.Expandable)c).getPlaceholder());
        } else if (c instanceof ContextBuilder.ContextNode.Dynamic) {
            ContextBuilder.ContextNode.Dynamic.DecomposedText decomposed = ((ContextBuilder.ContextNode.Dynamic)c).getOrComputeDecomposedText$intellij_ml_llm_sql_completion();
            this.appendFoldable(decomposed.getPrefix());
            this.appendText(decomposed.getMiddle());
            this.appendFoldable(decomposed.getSuffix());
        } else {
            this.appendText(c.getText(), c.getTokenCount());
        }
    }

    public final void appendText(@NotNull PrivacySafe<? extends ImmutableCharSequence> text2, int tokenCount) {
        Intrinsics.checkNotNullParameter(text2, (String)"text");
        this.flushLast();
        this.appendTextImpl(text2, tokenCount);
    }

    private final void appendTextImpl(ContextBuilder.ContextNode.Text text2) {
        this.appendTextImpl(text2.getText(), text2.getTokenCount());
    }

    private final void appendTextImpl(PrivacySafe<? extends ImmutableCharSequence> text2, int tokenCount) {
        this.middleText = PrivacySafe.Companion.concat(this.middleText, text2);
        this.middleTokens += tokenCount;
    }

    private final void flushLast() {
        ContextBuilder.ContextNode.Text text2 = this.lastFoldable;
        if (text2 == null) {
            return;
        }
        ContextBuilder.ContextNode.Text last = text2;
        this.lastFoldable = null;
        if (this.prefix == null && this.middleTokens == 0) {
            this.prefix = last;
        } else {
            this.appendTextImpl(last);
        }
    }

    @NotNull
    public final ContextBuilder.ContextNode.Dynamic.DecomposedText build() {
        ContextBuilder.ContextNode.Text middle = new ContextBuilder.ContextNode.Text(this.middleText, this.middleTokens, MapsKt.emptyMap());
        if (this.prefix == null && this.middleTokens == 0) {
            return new ContextBuilder.ContextNode.Dynamic.DecomposedText(this.lastFoldable, middle, null);
        }
        return new ContextBuilder.ContextNode.Dynamic.DecomposedText(this.prefix, middle, this.lastFoldable);
    }
}

