/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.Util;
import com.intellij.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class OpenSSHConfig
implements ConfigRepository {
    private final Map<String, List<String[]>> config = new HashMap<String, List<String[]>>();
    private final List<String> hosts = new ArrayList<String>();
    private static final Map<String, String> keymap = new HashMap<String, String>();

    public static OpenSSHConfig parse(String conf) throws IOException {
        try (StringReader stringReader = new StringReader(conf);){
            OpenSSHConfig openSSHConfig = new OpenSSHConfig(stringReader);
            return openSSHConfig;
        }
    }

    public static OpenSSHConfig parseFile(String file) throws IOException {
        try (FileReader fileReader = new FileReader(file);){
            OpenSSHConfig openSSHConfig = new OpenSSHConfig(fileReader);
            return openSSHConfig;
        }
    }

    OpenSSHConfig(Reader r) throws IOException {
        this.S(r);
    }

    private void S(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string2 = "";
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty() || string.startsWith("#")) continue;
            String[] stringArray = string.split("[= \t]", 2);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
            if (stringArray.length <= 1) continue;
            if (stringArray[0].equalsIgnoreCase("Host")) {
                this.config.put(string2, arrayList);
                this.hosts.add(string2);
                string2 = stringArray[1];
                arrayList = new ArrayList();
                continue;
            }
            arrayList.add(stringArray);
        }
        this.config.put(string2, arrayList);
        this.hosts.add(string2);
    }

    @Override
    public MyConfig getConfig(String host) {
        return new MyConfig(this, host);
    }

    static {
        keymap.put("kex", "KexAlgorithms");
        keymap.put("server_host_key", "HostKeyAlgorithms");
        keymap.put("cipher.c2s", "Ciphers");
        keymap.put("cipher.s2c", "Ciphers");
        keymap.put("mac.c2s", "Macs");
        keymap.put("mac.s2c", "Macs");
        keymap.put("compression.s2c", "Compression");
        keymap.put("compression.c2s", "Compression");
        keymap.put("compression_level", "CompressionLevel");
        keymap.put("MaxAuthTries", "NumberOfPasswordPrompts");
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class MyConfig
    implements ConfigRepository.Config {
        private final String host;
        private final List<List<String[]>> _configs = new ArrayList<List<String[]>>();

        MyConfig(OpenSSHConfig this$0, String host) {
            this.host = host;
            this._configs.add(this$0.config.get(""));
            byte[] byArray = Util.str2byte(host);
            if (this$0.hosts.size() > 1) {
                for (int i = 1; i < this$0.hosts.size(); ++i) {
                    String[] stringArray = this$0.hosts.get(i).split("[ \t]");
                    boolean bl = false;
                    for (String string : stringArray) {
                        boolean bl2 = false;
                        String string2 = string.trim();
                        if (string2.startsWith("!")) {
                            bl2 = true;
                            string2 = string2.substring(1).trim();
                        }
                        if (!Util.glob(Util.str2byte(string2), byArray)) continue;
                        if (!bl2) {
                            bl = true;
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    this._configs.add(this$0.config.get(this$0.hosts.get(i)));
                }
            }
        }

        private String S(String string) {
            if (keymap.get(string) != null) {
                string = keymap.get(string);
            }
            string = StringUtil.toUpperCase((String)string);
            String string2 = null;
            for (List<String[]> list : this._configs) {
                for (String[] stringArray : list) {
                    if (!StringUtil.toUpperCase((String)stringArray[0]).equals(string)) continue;
                    string2 = stringArray[1];
                    break;
                }
                if (string2 == null) continue;
                break;
            }
            return string2;
        }

        private String[] S(String string) {
            string = StringUtil.toUpperCase((String)string);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (List<String[]> list : this._configs) {
                for (String[] stringArray : list) {
                    String string2;
                    if (!StringUtil.toUpperCase((String)stringArray[0]).equals(string) || (string2 = stringArray[1]) == null) continue;
                    arrayList.remove(string2);
                    arrayList.add(string2);
                }
            }
            return ArrayUtil.toStringArray(arrayList);
        }

        @Override
        public String getHostname() {
            return this.S("Hostname");
        }

        @Override
        public String getUser() {
            return this.S("User");
        }

        @Override
        public int getPort() {
            String string = this.S("Port");
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return n;
        }

        @Override
        public String getValue(@Nullable String key) {
            if (key != null && (key.equals("compression.s2c") || key.equals("compression.c2s"))) {
                String string = this.S(key);
                if (string == null || string.equals("no")) {
                    return "none,zlib@openssh.com,zlib";
                }
                return "zlib@openssh.com,zlib,none";
            }
            return this.S(key);
        }

        @Override
        public String[] getValues(String key) {
            return this.S(key);
        }

        public Stream<String[]> stream() {
            return this._configs.stream().flatMap(Collection::stream).map(object -> (String[])((String[])object).clone());
        }
    }
}

