/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.diff;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.CpuDiffCalculator;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.ShowSnapshotDiffDialog;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class V8CpuDiffAction
extends DumbAwareAction {
    private final Project myProject;
    private final V8LogCachingReader myReader;

    public V8CpuDiffAction(Project project, V8LogCachingReader reader) {
        super(NodeJSBundle.messagePointer("action.V8CpuDiffAction.compare.with.text", new Object[0]), NodeJSBundle.messagePointer("action.V8CpuDiffAction.compare.with.another.v8.log.description", new Object[0]), AllIcons.Actions.Diff);
        this.myProject = project;
        this.myReader = reader;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ShowSnapshotDiffDialog dialog;
        VirtualFile[] files;
        if (e == null) {
            V8CpuDiffAction.$$$reportNull$$$0(0);
        }
        if ((files = (dialog = new ShowSnapshotDiffDialog(FileChooserDescriptorFactory.createSingleFileDescriptor((String)"log"), this.myProject, NodeJSBundle.message("profile.cpu.ShowSnapshotDiffDialog.title", new Object[0]))).choose(this.myProject, new VirtualFile[0])).length != 1) {
            return;
        }
        VirtualFile file = files[0];
        if (file != null) {
            File changedFile = new File(file.getPath());
            if (FileUtil.filesEqual((File)changedFile, (File)this.myReader.getV8LogFile())) {
                NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.compare_snapshot_with_itself.action.name", new Object[0]), MessageType.WARNING).notify(this.myProject);
                return;
            }
            CpuDiffCalculator calculateSecondAndDiff = new CpuDiffCalculator(this.myProject, this.myReader, changedFile, !dialog.isAfter());
            ProgressManager.getInstance().run((Task)calculateSecondAndDiff);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/cpu/v8log/diff/V8CpuDiffAction", "actionPerformed"));
    }
}

