/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ecmascript6.psi.impl.ES6ClassImpl;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElementIndexingDataCalculator;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexingDataHolder;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiQualifiedReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/javascript/psi/ES6ClassIndexingDataCalculator;", "Lcom/intellij/lang/javascript/psi/JSElementIndexingDataCalculator;", "Lcom/intellij/lang/ecmascript6/psi/impl/ES6ClassImpl;", "<init>", "()V", "accepts", "", "indexingDataHolder", "Lcom/intellij/lang/javascript/psi/JSIndexingDataHolder;", "calculate", "Lcom/intellij/lang/javascript/psi/stubs/JSElementIndexingData;", "dataHolder", "addBaseTypesFromExtendsList", "indexingData", "intellij.javascript.analysis.impl"})
public final class ES6ClassIndexingDataCalculator
implements JSElementIndexingDataCalculator<ES6ClassImpl> {
    public boolean accepts(@NotNull JSIndexingDataHolder indexingDataHolder) {
        Intrinsics.checkNotNullParameter((Object)indexingDataHolder, (String)"indexingDataHolder");
        return indexingDataHolder instanceof ES6ClassImpl;
    }

    @Nullable
    public JSElementIndexingData calculate(@NotNull ES6ClassImpl dataHolder) {
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        JSElementIndexingData indexingData = null;
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)((PsiElement)dataHolder))) {
            indexingData = handler.processClass((JSClass)dataHolder, indexingData);
        }
        indexingData = this.addBaseTypesFromExtendsList(dataHolder, indexingData);
        return indexingData;
    }

    private final JSElementIndexingData addBaseTypesFromExtendsList(ES6ClassImpl $this$addBaseTypesFromExtendsList, JSElementIndexingData indexingData) {
        JSElementIndexingData indexingData2;
        JSElementIndexingData jSElementIndexingData = indexingData2 = indexingData;
        if (jSElementIndexingData != null) {
            return jSElementIndexingData;
        }
        JSReferenceList extendsList = $this$addBaseTypesFromExtendsList.getExtendsList();
        if (extendsList == null) {
            return null;
        }
        String currentClassQName = $this$addBaseTypesFromExtendsList.getQualifiedName();
        if (currentClassQName == null) {
            return null;
        }
        JSExpression[] jSExpressionArray = extendsList.getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getExpressions(...)");
        for (JSExpression expression : jSExpressionArray) {
            JSQualifiedName name;
            if (!(expression instanceof JSReferenceExpression) || (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((PsiQualifiedReference)expression))) == null) continue;
            if (indexingData2 == null) {
                indexingData2 = new JSElementIndexingDataImpl();
            }
            indexingData2.addBaseType(currentClassQName, name.getQualifiedName());
        }
        return indexingData2;
    }
}

