/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceParameter;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterDialog;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSParameterInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.validation.fixes.JSParameterInserter;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceParameterHandler
extends JSBaseIntroduceHandler<JSElement, JSIntroduceParameterSettings, JSIntroduceParameterDialog> {
    protected JSParameterInserter parameterInserter;
    private JSIntroduceParameterSettings mySettings;
    private Collection<UsageInfo> myFunctionCallUsages;
    private static final String ADD_JSDOC_KEY = "js.introduce.parameter.add.jsdoc";
    private static final String GENERATE_OPTIONAL_KEY = "js.introduce.parameter.generate.optional";
    private SmartPsiElementPointer<PsiElement> myInitializerPointer;
    public static final JSIntroduceTargetChooser<JSFunction> DEFAULT_SCOPE_CHOOSER = (editor, elements, callback, presenter) -> callback.accept(ContainerUtil.getLastItem((List)elements));
    private final JSIntroduceTargetChooser<JSFunction> myScopeChooser;

    public JSIntroduceParameterHandler() {
        this.myScopeChooser = ApplicationManager.getApplication().isUnitTestMode() ? DEFAULT_SCOPE_CHOOSER : (editor, functions, callback, presenter) -> JSIntroduceParameterHandler.showScopeChooser(editor, functions, callback, (Function<? super JSFunction, String>)presenter);
    }

    public JSIntroduceParameterHandler(@NotNull JSIntroduceTargetChooser<JSExpression> expressionChooser, @NotNull JSIntroduceTargetChooser<JSFunction> scopeChooser) {
        if (expressionChooser == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        if (scopeChooser == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        super(expressionChooser);
        this.myScopeChooser = scopeChooser;
    }

    @Override
    @Nullable
    @NonNls
    public String getRefactoringId() {
        return "refactoring.javascript.introduceParameter";
    }

    @Override
    protected String getRefactoringName() {
        return JavaScriptBundle.message((String)"javascript.introduce.parameter.title", (Object[])new Object[0]);
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.parameter.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.parameter.error.expression.has.void.type";
    }

    @Override
    @Nullable
    protected Pair<JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings>, JSElement> adjustContext(@NotNull JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> introduceContext, @NotNull JSElement anchorStatement, @NotNull Editor editor, @NotNull Project project) {
        if (introduceContext == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(2);
        }
        if (anchorStatement == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(5);
        }
        return this.adjustParenthesizedOccurrences(introduceContext, anchorStatement, project, editor.getDocument());
    }

    @Override
    protected void findIntroducedScope(@NotNull Editor editor, @NotNull Pair<? extends JSExpression, ? extends TextRange> expressionDescriptor, @NotNull NullableConsumer<? super PsiElement> callback) {
        List<JSFunction> candidates;
        if (editor == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(6);
        }
        if (expressionDescriptor == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(8);
        }
        if ((candidates = JSIntroduceParameterHandler.getPossibleScopes((JSExpression)expressionDescriptor.first)).isEmpty()) {
            this.showErrorHint(editor, ((JSExpression)expressionDescriptor.getFirst()).getContainingFile(), JavaScriptBundle.message((String)"javascript.introduce.parameter.error.no.containing.function", (Object[])new Object[0]));
            return;
        }
        JSIntroduceParameterHandler.chooseElement(this.myScopeChooser, editor, candidates, arg_0 -> callback.consume(arg_0), JSIntroduceParameterHandler::getScopePresentation);
    }

    @NotNull
    private static List<JSFunction> getPossibleScopes(@NotNull JSExpression expression) {
        if (expression == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(9);
        }
        SmartList functions = new SmartList();
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
        while (fun != null) {
            if (!(fun.getParent() instanceof JSArgumentList)) {
                functions.add(fun);
            }
            fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)fun, JSFunction.class);
        }
        SmartList smartList = functions;
        if (smartList == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    @Override
    protected JSBaseInplaceIntroducer<JSIntroduceParameterSettings> createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> context2, PsiElement scope2, Editor editor, Project project, JSExpression[] occurences, Runnable callback) {
        return new JSParameterInplaceIntroducer(editor, project, occurences, this, context2, callback);
    }

    @Override
    protected InplaceSettings<JSIntroduceParameterSettings> getInplaceSettings(final Pair<JSExpression, TextRange> exprDescriptor, JSExpression[] occurrences, final PsiElement scope2, final OccurrencesChooser.ReplaceChoice choice) {
        BasicIntroducedEntityInfoProvider entityInfoProvider = new BasicIntroducedEntityInfoProvider((JSExpression)exprDescriptor.first, occurrences, scope2);
        final String[] candidateNames = entityInfoProvider.suggestCandidateNames();
        final String myIntroducedName = candidateNames.length > 0 ? candidateNames[0].trim() : "newParam";
        return new InplaceSettings<JSIntroduceParameterSettings>(){
            private SmartPsiElementPointer<PsiElement> scopePointer;
            {
                this.scopePointer = SmartPointerManager.createPointer((PsiElement)scope2);
            }

            @Override
            public String[] getSuggestedNames() {
                return candidateNames;
            }

            @Override
            public JSIntroduceParameterSettings getSettings() {
                return new JSIntroduceParameterSettings.Base(exprDescriptor){

                    @Override
                    public boolean addOptionalParameter() {
                        return JSIntroduceParameterHandler.isGenerateOptional(((JSExpression)exprDescriptor.first).getProject());
                    }

                    @Override
                    public boolean addJsDoc() {
                        return JSIntroduceParameterHandler.isAddJSDoc(((JSExpression)exprDescriptor.first).getProject());
                    }

                    @Override
                    public String getInitialValue() {
                        return JSIntroduceParameterHandler.access$001(JSIntroduceParameterHandler.this, exprDescriptor).getText();
                    }

                    @Override
                    public boolean isReplaceAllOccurrences() {
                        return choice == OccurrencesChooser.ReplaceChoice.ALL;
                    }

                    @Override
                    public String getVariableName() {
                        return myIntroducedName;
                    }

                    @Override
                    public String getVariableType() {
                        return null;
                    }

                    @Override
                    public JSFunction functionForIntroduceParameter() {
                        PsiElement scope2 = scopePointer.getElement();
                        if (scope2 instanceof JSFunction) {
                            return (JSFunction)scope2;
                        }
                        return super.functionForIntroduceParameter();
                    }
                };
            }
        };
    }

    @Override
    protected boolean doPreprocess(Project project, Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull PsiElement scope2) {
        JSFunction fun;
        if (expressionDescriptor == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(11);
        }
        if (scope2 == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(12);
        }
        JSQualifiedNamedElement functionParent = (fun = (JSFunction)scope2) instanceof JSFunctionExpression ? ((JSFunctionExpression)fun).getElementAssignedTo() : null;
        HashSet<UsageInfo> usages = new HashSet<UsageInfo>();
        boolean completedSuccessfully = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            usages.addAll(ContainerUtil.map((Collection)ReferencesSearch.search((PsiElement)fun, (SearchScope)fun.getUseScope()).findAll(), UsageInfo::new));
            if (functionParent != null) {
                usages.addAll(ContainerUtil.map((Collection)ReferencesSearch.search((PsiElement)functionParent, (SearchScope)functionParent.getUseScope()).findAll(), UsageInfo::new));
            }
        }), JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project);
        if (!completedSuccessfully) {
            return false;
        }
        this.myFunctionCallUsages = usages;
        if (JSIntroduceParameterHandler.containsAwaitExpressions((JSExpression)expressionDescriptor.first)) {
            if (!((JSFunction)scope2).isAsync()) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"javascript.introduce.parameter.error.target.not.async", (Object[])new Object[0]), (String)this.getRefactoringName(), null);
                return false;
            }
            if (ContainerUtil.or(this.myFunctionCallUsages, u -> !JSIntroduceParameterHandler.isInAsyncContext(u.getElement()))) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"javascript.introduce.parameter.error.not.async.context", (Object[])new Object[0]), (String)this.getRefactoringName(), null);
                return false;
            }
        }
        if (JSIntroduceParameterHandler.containsYieldExpressions((JSExpression)expressionDescriptor.first)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message((String)"javascript.introduce.parameter.error.yield", (Object[])new Object[0]), (String)this.getRefactoringName(), null);
            return false;
        }
        return true;
    }

    private static boolean isInAsyncContext(PsiElement element2) {
        return ES6PsiUtil.isAsyncFunction((JSFunction)((JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, JSFunction.class)));
    }

    @Override
    protected JSIntroduceParameterDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope2) {
        return new JSIntroduceParameterDialog(project, occurrences, expression, expression.getText(), scope2 instanceof JSFunction ? (JSFunction)scope2 : (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class));
    }

    @Override
    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        Object initialValue;
        Object object = initialValue = this.mySettings == null ? super.getReplacementExpression(expressionDescriptor).getText() : this.mySettings.getInitialValue();
        if (((String)initialValue).isEmpty()) {
            initialValue = "null";
        }
        boolean doUnwrapParenthesized = false;
        if (expressionDescriptor.first instanceof JSFunctionExpression || expressionDescriptor.first instanceof JSObjectLiteralExpression || expressionDescriptor.first instanceof JSArrayLiteralExpression) {
            initialValue = "(" + (String)initialValue + ")";
            doUnwrapParenthesized = true;
        }
        JSExpression psi = JSPsiElementFactory.createJSExpression((String)initialValue, (PsiElement)((PsiElement)expressionDescriptor.first));
        if (doUnwrapParenthesized) {
            psi = ((JSParenthesizedExpression)psi).getInnerExpression();
        }
        return psi;
    }

    @Override
    protected JSElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> settingsBaseIntroduceContext, boolean replaceAllOccurrences) {
        this.mySettings = (JSIntroduceParameterSettings)settingsBaseIntroduceContext.settings;
        this.parameterInserter = JSParameterInserter.build(((JSIntroduceParameterSettings)settingsBaseIntroduceContext.settings).functionForIntroduceParameter());
        return (JSElement)super.findAnchor(settingsBaseIntroduceContext, replaceAllOccurrences);
    }

    protected JSParameter addStatementBefore(JSElement anchor, JSVarStatement declaration) throws IncorrectOperationException {
        JSType type2;
        JSVariable var = declaration.getVariables()[0];
        Object paramText = var.getName();
        if (DialectDetector.hasFeature((PsiElement)anchor, (JSLanguageFeature)JSLanguageFeature.TYPES) && (type2 = var.getJSType()) != null) {
            paramText = (String)paramText + ":" + type2.getTypeText(JSType.TypeTextFormat.CODE);
        }
        JSExpression initializer = var.getInitializer();
        if (this.mySettings.addOptionalParameter() && JSIntroduceParameterHandler.shouldGenerateParameterInitializer(initializer)) {
            paramText = var.getText();
        }
        return this.parameterInserter.doInsert((String)paramText, this.mySettings.addOptionalParameter(), initializer != null ? initializer.getText() : null);
    }

    @Override
    protected boolean shouldAddTypeAnnotation(JSExpression expression, JSIntroduceParameterSettings settings) {
        return DialectDetector.hasFeature((PsiElement)expression, (JSLanguageFeature)JSLanguageFeature.TYPES);
    }

    @Override
    protected void doPostprocess(JSVarStatement declaration, JSIntroduceParameterSettings settings, Editor editor) {
        JSFunction fun = settings.functionForIntroduceParameter();
        assert (fun != null);
        JSVariable variable = declaration.getVariables()[0];
        Document document = fun.getContainingFile().getViewProvider().getDocument();
        assert (document != null);
        JSExpression initializer = variable.getInitializer();
        if (settings.addOptionalParameter() && !JSIntroduceParameterHandler.shouldGenerateParameterInitializer(initializer)) {
            String initializerText = initializer != null ? initializer.getText() : null;
            this.myInitializerPointer = JSIntroduceParameterHandler.addOptionalParameterInitializer(fun, variable.getName(), initializerText, editor);
        }
        if (settings.addJsDoc()) {
            ArrayList<String> create2 = new ArrayList<String>();
            StringBuilder paramTag = new StringBuilder("param ");
            JSType type2 = JSResolveUtil.getExpressionJSType((JSExpression)initializer);
            if (!(type2 == null || DialectDetector.isTypeScript((PsiElement)declaration) && !TypeScriptCodeStyleSettings.getTypeScriptSettings((PsiElement)declaration).JSDOC_INCLUDE_TYPES || type2 instanceof JSAnyType)) {
                paramTag.append("{").append(type2.getTypeText(JSType.TypeTextFormat.CODE)).append("} ");
            }
            paramTag.append(variable.getName());
            create2.add(paramTag.toString());
            JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)fun, create2, null, null);
        }
    }

    @Override
    public void performIntroduce(@NotNull JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> introduceContext) {
        PsiElement grandParent;
        Object scope2;
        JSFunction fun;
        if (introduceContext == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(13);
        }
        if ((fun = ((JSIntroduceParameterSettings)introduceContext.settings).functionForIntroduceParameter()) == null && (scope2 = introduceContext.scope) instanceof JSFunction) {
            fun = (JSFunction)scope2;
        }
        assert (fun != null);
        for (UsageInfo u : this.myFunctionCallUsages) {
            PsiElement parent;
            PsiElement element2 = u.getElement();
            if (element2 == null || !((parent = element2.getParent()) instanceof JSCallExpression)) continue;
            this.parameterInserter.fixCall((JSCallExpression)parent);
        }
        if (fun instanceof JSFunctionExpression && fun.getParent() instanceof JSParenthesizedExpression && (grandParent = fun.getParent().getParent()) instanceof JSCallExpression) {
            this.parameterInserter.fixCall((JSCallExpression)grandParent);
        }
    }

    @Override
    protected boolean canInplaceIntroduceForSubexpression() {
        return true;
    }

    public static SmartPsiElementPointer<PsiElement> addOptionalParameterInitializer(@NotNull JSFunction function, String variableName, String defaultValue, @Nullable Editor editor) {
        if (function == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(14);
        }
        return JSIntroduceParameterHandler.addOptionalParameterInitializer(function, variableName, defaultValue, false, true, editor);
    }

    public static SmartPsiElementPointer<PsiElement> addOptionalParameterInitializer(@NotNull JSFunction function, @NotNull String variableName, @NotNull String defaultValue, boolean addBeforeFirstElement, boolean addSemicolon, @Nullable Editor editor) {
        JSBlockStatement body;
        if (function == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(15);
        }
        if (variableName == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(16);
        }
        if (defaultValue == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(17);
        }
        if ((body = function.getBlock()) == null) {
            return null;
        }
        Project project = function.getProject();
        String text = variableName + "=" + variableName + "||" + defaultValue;
        if (addSemicolon) {
            text = text + JSCodeStyleSettings.getSemicolon((PsiElement)function);
        }
        JSStatement initializeStatement = JSPsiElementFactory.createJSStatement((String)text, (PsiElement)function);
        PsiElement element2 = addBeforeFirstElement ? body.addBefore((PsiElement)initializeStatement, body.getFirstChild()) : body.addAfter((PsiElement)initializeStatement, body.getFirstChild());
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element2);
        if (editor != null) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
        JSIntroduceParameterHandler.fixFormat((SmartPsiElementPointer<? extends PsiElement>)pointer, project, editor);
        return pointer;
    }

    public void removeOptionalParameterInitializer() {
        PsiElement element2;
        PsiElement psiElement = element2 = this.myInitializerPointer != null ? this.myInitializerPointer.getElement() : null;
        if (element2 != null) {
            element2.getParent().deleteChildRange(element2, element2.getNextSibling());
        }
    }

    public List<JSReferenceExpression> getParameterReferencesFromOptionalInitializer() {
        PsiElement element2 = this.myInitializerPointer != null ? this.myInitializerPointer.getElement() : null;
        ArrayList<JSReferenceExpression> referenceExpressions = new ArrayList<JSReferenceExpression>();
        PsiTreeUtil.processElements((PsiElement)element2, child -> {
            if (child instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)((JSReferenceExpression)child), (String)this.mySettings.getVariableName())) {
                referenceExpressions.add((JSReferenceExpression)child);
            }
            return true;
        });
        return referenceExpressions;
    }

    private static void showScopeChooser(@NotNull Editor editor, @NotNull List<? extends JSFunction> functions, @NotNull Consumer<? super JSFunction> callback, @NotNull Function<? super JSFunction, String> presenter) {
        if (editor == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(18);
        }
        if (functions == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(19);
        }
        if (callback == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(20);
        }
        if (presenter == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(21);
        }
        IntroduceTargetChooser.showChooser((Editor)editor, functions, (Pass)Pass.create(callback), presenter, (String)JavaScriptBundle.message((String)"popup.title.target.function", (Object[])new Object[0]));
    }

    @NotNull
    private static String getScopePresentation(JSFunction function) {
        String string = JSFormatUtil.formatMethod((JSFunction)function, (int)4097, (int)0);
        if (string == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(22);
        }
        return string;
    }

    public static boolean isAddJSDoc(@NotNull Project project) {
        if (project == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(23);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(ADD_JSDOC_KEY, false);
    }

    public static boolean isGenerateOptional(@NotNull Project project) {
        if (project == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(24);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(GENERATE_OPTIONAL_KEY, true);
    }

    public static void setAddJSDoc(@NotNull Project project, boolean value) {
        if (project == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(25);
        }
        PropertiesComponent.getInstance((Project)project).setValue(ADD_JSDOC_KEY, value, false);
    }

    public static void setGenerateOptional(@NotNull Project project, boolean value) {
        if (project == null) {
            JSIntroduceParameterHandler.$$$reportNull$$$0(26);
        }
        PropertiesComponent.getInstance((Project)project).setValue(GENERATE_OPTIONAL_KEY, value, true);
    }

    private static boolean shouldGenerateParameterInitializer(@Nullable JSExpression initializerExpression) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)initializerExpression);
        return JSIntroduceParameterHandler.dialectSupportsParameterInitializers(dialect) && (!dialect.hasFeature(JSLanguageFeature.ASYNC_AWAIT) || !JSIntroduceParameterHandler.containsAwaitExpressions(initializerExpression));
    }

    private static boolean dialectSupportsParameterInitializers(@Nullable DialectOptionHolder holder) {
        return holder != null && (holder.isECMA4 || holder.isECMA6 || holder.isTypeScript);
    }

    static /* synthetic */ JSExpression access$001(JSIntroduceParameterHandler x0, Pair x1) {
        return super.getReplacementExpression((Pair<JSExpression, TextRange>)x1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionChooser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeChooser";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorStatement";
                break;
            }
            case 4: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceParameter/JSIntroduceParameterHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceParameter/JSIntroduceParameterHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleScopes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findIntroducedScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleScopes";
                break;
            }
            case 10: 
            case 22: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doPreprocess";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performIntroduce";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addOptionalParameterInitializer";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showScopeChooser";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAddJSDoc";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isGenerateOptional";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setAddJSDoc";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setGenerateOptional";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 22 -> new IllegalStateException(string);
        };
    }
}

