/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSInitializeParameterFix
extends PsiUpdateModCommandAction<JSParameterListElement> {
    private final String initializer;

    public JSInitializeParameterFix(JSParameterListElement parameter, String initializer) {
        super((PsiElement)parameter);
        this.initializer = JSRefactoringUtil.recodeQuotes(initializer, JSCodeStyleSettings.getQuote((PsiElement)parameter));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.fix.initialize.parameter", (Object[])new Object[0]);
        if (string == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull JSParameterListElement parameter, @NotNull ModPsiUpdater updater) {
        if (context2 == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(1);
        }
        if (parameter == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            JSInitializeParameterFix.$$$reportNull$$$0(3);
        }
        JSParameterListElement createdParam = JSChangeUtil.createParameter((String)(parameter.getText() + "=" + this.initializer), (PsiElement)parameter);
        parameter.replace((PsiElement)createdParam);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSInitializeParameterFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSInitializeParameterFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

