/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.sql.cardinality.SqlJoinCardinalityInfo;
import com.intellij.sql.cardinality.SqlJoinCardinalityType;
import com.intellij.sql.cardinality.SqlJoinType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0012J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012J\u0006\u0010\u001e\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0012J\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0012J\u0016\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/intellij/sql/inspections/Analysis;", "", "condition", "Lcom/intellij/psi/PsiElement;", "joinType", "Lcom/intellij/sql/cardinality/SqlJoinType;", "isUniqueFKey", "", "isNotNullFKey", "isRight2LeftFKey", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/sql/cardinality/SqlJoinType;ZZZ)V", "getCondition", "()Lcom/intellij/psi/PsiElement;", "getJoinType", "()Lcom/intellij/sql/cardinality/SqlJoinType;", "()Z", "analyse", "Lcom/intellij/sql/cardinality/SqlJoinCardinalityInfo;", "analyseLeftJoin", "analyseRightJoin", "analyseFullJoin", "analyseInnerJoin", "oneOne", "oneOne2n", "one2nOne", "oneZero2one", "one2nZero2one", "oneZero2n", "zero2oneOne", "zero2oneOne2n", "zero2nOne", "zero2nZero2one", "zero2oneZero2n", "zero2oneZero2one", "getResult", "left", "Lcom/intellij/sql/cardinality/SqlJoinCardinalityType;", "right", "intellij.database.sql.core.impl"})
final class Analysis {
    @NotNull
    private final PsiElement condition;
    @NotNull
    private final SqlJoinType joinType;
    private final boolean isUniqueFKey;
    private final boolean isNotNullFKey;
    private final boolean isRight2LeftFKey;

    public Analysis(@NotNull PsiElement condition, @NotNull SqlJoinType joinType, boolean isUniqueFKey, boolean isNotNullFKey, boolean isRight2LeftFKey) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)joinType, (String)"joinType");
        this.condition = condition;
        this.joinType = joinType;
        this.isUniqueFKey = isUniqueFKey;
        this.isNotNullFKey = isNotNullFKey;
        this.isRight2LeftFKey = isRight2LeftFKey;
    }

    @NotNull
    public final PsiElement getCondition() {
        return this.condition;
    }

    @NotNull
    public final SqlJoinType getJoinType() {
        return this.joinType;
    }

    public final boolean isUniqueFKey() {
        return this.isUniqueFKey;
    }

    public final boolean isNotNullFKey() {
        return this.isNotNullFKey;
    }

    public final boolean isRight2LeftFKey() {
        return this.isRight2LeftFKey;
    }

    @NotNull
    public final SqlJoinCardinalityInfo analyse() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.joinType.ordinal()]) {
            case 1 -> this.analyseLeftJoin();
            case 2 -> this.analyseRightJoin();
            case 3 -> this.analyseFullJoin();
            default -> this.analyseInnerJoin();
        };
    }

    private final SqlJoinCardinalityInfo analyseLeftJoin() {
        if (this.isRight2LeftFKey) {
            return this.isUniqueFKey ? this.oneZero2one() : this.oneZero2n();
        }
        if (this.isNotNullFKey) {
            return this.isUniqueFKey ? this.oneOne() : this.one2nOne();
        }
        return this.isUniqueFKey ? this.oneZero2one() : this.one2nZero2one();
    }

    private final SqlJoinCardinalityInfo analyseRightJoin() {
        if (!this.isRight2LeftFKey) {
            return this.isUniqueFKey ? this.zero2oneOne() : this.zero2nOne();
        }
        if (this.isNotNullFKey) {
            return this.isUniqueFKey ? this.oneOne() : this.oneOne2n();
        }
        return this.isUniqueFKey ? this.zero2oneOne() : this.zero2oneOne2n();
    }

    private final SqlJoinCardinalityInfo analyseFullJoin() {
        if (!this.isNotNullFKey) {
            if (this.isUniqueFKey) {
                return this.zero2oneZero2one();
            }
            return this.isRight2LeftFKey ? this.zero2oneZero2n() : this.zero2nZero2one();
        }
        if (this.isRight2LeftFKey) {
            return this.isUniqueFKey ? this.oneZero2one() : this.oneZero2n();
        }
        return this.isUniqueFKey ? this.zero2oneOne() : this.zero2nOne();
    }

    private final SqlJoinCardinalityInfo analyseInnerJoin() {
        if (this.isUniqueFKey) {
            return this.oneOne();
        }
        return this.isRight2LeftFKey ? this.oneOne2n() : this.one2nOne();
    }

    @NotNull
    public final SqlJoinCardinalityInfo oneOne() {
        return this.getResult(SqlJoinCardinalityType.ONE, SqlJoinCardinalityType.ONE);
    }

    @NotNull
    public final SqlJoinCardinalityInfo oneOne2n() {
        return this.getResult(SqlJoinCardinalityType.ONE, SqlJoinCardinalityType.ONE2N);
    }

    @NotNull
    public final SqlJoinCardinalityInfo one2nOne() {
        return this.getResult(SqlJoinCardinalityType.ONE2N, SqlJoinCardinalityType.ONE);
    }

    @NotNull
    public final SqlJoinCardinalityInfo oneZero2one() {
        return this.getResult(SqlJoinCardinalityType.ONE, SqlJoinCardinalityType.ZERO2ONE);
    }

    @NotNull
    public final SqlJoinCardinalityInfo one2nZero2one() {
        return this.getResult(SqlJoinCardinalityType.ONE2N, SqlJoinCardinalityType.ZERO2ONE);
    }

    @NotNull
    public final SqlJoinCardinalityInfo oneZero2n() {
        return this.getResult(SqlJoinCardinalityType.ONE, SqlJoinCardinalityType.ZERO2N);
    }

    @NotNull
    public final SqlJoinCardinalityInfo zero2oneOne() {
        return this.getResult(SqlJoinCardinalityType.ZERO2ONE, SqlJoinCardinalityType.ONE);
    }

    @NotNull
    public final SqlJoinCardinalityInfo zero2oneOne2n() {
        return this.getResult(SqlJoinCardinalityType.ZERO2ONE, SqlJoinCardinalityType.ONE2N);
    }

    @NotNull
    public final SqlJoinCardinalityInfo zero2nOne() {
        return this.getResult(SqlJoinCardinalityType.ZERO2N, SqlJoinCardinalityType.ONE);
    }

    @NotNull
    public final SqlJoinCardinalityInfo zero2nZero2one() {
        return this.getResult(SqlJoinCardinalityType.ZERO2N, SqlJoinCardinalityType.ZERO2ONE);
    }

    @NotNull
    public final SqlJoinCardinalityInfo zero2oneZero2n() {
        return this.getResult(SqlJoinCardinalityType.ZERO2ONE, SqlJoinCardinalityType.ZERO2N);
    }

    @NotNull
    public final SqlJoinCardinalityInfo zero2oneZero2one() {
        return this.getResult(SqlJoinCardinalityType.ZERO2ONE, SqlJoinCardinalityType.ZERO2ONE);
    }

    @NotNull
    public final SqlJoinCardinalityInfo getResult(@NotNull SqlJoinCardinalityType left, @NotNull SqlJoinCardinalityType right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new SqlJoinCardinalityInfo(this.condition, this.joinType, null, null, left, right);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqlJoinType.values().length];
            try {
                nArray[SqlJoinType.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlJoinType.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlJoinType.FULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

