/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.signature;

import org.jruby.org.objectweb.asm.signature.SignatureVisitor;

public class SignatureReader {
    private final String signatureValue;

    public SignatureReader(String signature) {
        this.signatureValue = signature;
    }

    public void accept(SignatureVisitor signatureVistor) {
        int offset2;
        String signature = this.signatureValue;
        int length2 = signature.length();
        if (signature.charAt(0) == '<') {
            char currentChar;
            offset2 = 2;
            do {
                int classBoundStartOffset = signature.indexOf(58, offset2);
                signatureVistor.visitFormalTypeParameter(signature.substring(offset2 - 1, classBoundStartOffset));
                offset2 = classBoundStartOffset + 1;
                currentChar = signature.charAt(offset2);
                if (currentChar == 'L' || currentChar == '[' || currentChar == 'T') {
                    offset2 = SignatureReader.parseType(signature, offset2, signatureVistor.visitClassBound());
                }
                while ((currentChar = signature.charAt(offset2++)) == ':') {
                    offset2 = SignatureReader.parseType(signature, offset2, signatureVistor.visitInterfaceBound());
                }
            } while (currentChar != '>');
        } else {
            offset2 = 0;
        }
        if (signature.charAt(offset2) == '(') {
            ++offset2;
            while (signature.charAt(offset2) != ')') {
                offset2 = SignatureReader.parseType(signature, offset2, signatureVistor.visitParameterType());
            }
            offset2 = SignatureReader.parseType(signature, offset2 + 1, signatureVistor.visitReturnType());
            while (offset2 < length2) {
                offset2 = SignatureReader.parseType(signature, offset2 + 1, signatureVistor.visitExceptionType());
            }
        } else {
            offset2 = SignatureReader.parseType(signature, offset2, signatureVistor.visitSuperclass());
            while (offset2 < length2) {
                offset2 = SignatureReader.parseType(signature, offset2, signatureVistor.visitInterface());
            }
        }
    }

    public void acceptType(SignatureVisitor signatureVisitor) {
        SignatureReader.parseType(this.signatureValue, 0, signatureVisitor);
    }

    /*
     * Unable to fully structure code
     */
    private static int parseType(String signature, int startOffset, SignatureVisitor signatureVisitor) {
        offset = startOffset;
        currentChar = signature.charAt(offset++);
        switch (currentChar) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                signatureVisitor.visitBaseType(currentChar);
                return offset;
            }
            case '[': {
                return SignatureReader.parseType(signature, offset, signatureVisitor.visitArrayType());
            }
            case 'T': {
                endOffset = signature.indexOf(59, offset);
                signatureVisitor.visitTypeVariable(signature.substring(offset, endOffset));
                return endOffset + 1;
            }
            case 'L': {
                start = offset;
                visited = false;
                inner = false;
                while (true) {
                    if ((currentChar = signature.charAt(offset++)) == '.' || currentChar == ';') {
                        if (!visited) {
                            name = signature.substring(start, offset - 1);
                            if (inner) {
                                signatureVisitor.visitInnerClassType(name);
                            } else {
                                signatureVisitor.visitClassType(name);
                            }
                        }
                        if (currentChar == ';') break;
                        start = offset;
                        visited = false;
                        inner = true;
                        continue;
                    }
                    if (currentChar != '<') continue;
                    name = signature.substring(start, offset - 1);
                    if (inner) {
                        signatureVisitor.visitInnerClassType(name);
                    } else {
                        signatureVisitor.visitClassType(name);
                    }
                    visited = true;
                    block11: while (true) {
                        if ((currentChar = signature.charAt(offset)) == '>') ** break;
                        switch (currentChar) {
                            case '*': {
                                ++offset;
                                signatureVisitor.visitTypeArgument();
                                continue block11;
                            }
                            case '+': 
                            case '-': {
                                offset = SignatureReader.parseType(signature, offset + 1, signatureVisitor.visitTypeArgument(currentChar));
                                continue block11;
                            }
                        }
                        offset = SignatureReader.parseType(signature, offset, signatureVisitor.visitTypeArgument('='));
                    }
                    break;
                }
                signatureVisitor.visitEnd();
                return offset;
            }
        }
        throw new IllegalArgumentException();
    }
}

