/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e1rabe";
        final String metaValue_hy = "armenio";
        final String metaValue_bn = "bengal\u00ed";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_ka = "xeorxiano";
        final String metaValue_el = "grego";
        final String metaValue_gu = "guxarati";
        final String metaValue_he = "hebreo";
        final String metaValue_ja = "xapon\u00e9s";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannar\u00e1";
        final String metaValue_ko = "coreano";
        final String metaValue_lo = "laosiano";
        final String metaValue_ml = "malabar";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmano";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_or = "odi\u00e1";
        final String metaValue_si = "cingal\u00e9s";
        final String metaValue_su = "sundan\u00e9s";
        final String metaValue_syr = "sir\u00edaco";
        final String metaValue_ta = "t\u00e1mil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailand\u00e9s";
        final String metaValue_bo = "tibetano";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "001", "Mundo" },
            { "002", "\u00c1frica" },
            { "003", "Am\u00e9rica do Norte" },
            { "005", "Am\u00e9rica do Sur" },
            { "009", "Ocean\u00eda" },
            { "011", "\u00c1frica Occidental" },
            { "013", "Am\u00e9rica Central" },
            { "014", "\u00c1frica Oriental" },
            { "015", "\u00c1frica Setentrional" },
            { "017", "\u00c1frica Central" },
            { "018", "\u00c1frica Meridional" },
            { "019", "Am\u00e9rica" },
            { "021", "Am\u00e9rica Setentrional" },
            { "029", "Caribe" },
            { "030", "Asia Oriental" },
            { "034", "Asia Meridional" },
            { "035", "Sueste Asi\u00e1tico" },
            { "039", "Europa Meridional" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Rexi\u00f3n de Micronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Central" },
            { "145", "Asia Occidental" },
            { "150", "Europa" },
            { "151", "Europa do Leste" },
            { "154", "Europa Setentrional" },
            { "155", "Europa Occidental" },
            { "202", "\u00c1frica subsahariana" },
            { "419", "Am\u00e9rica Latina" },
            { "AC", "Illa de Ascensi\u00f3n" },
            { "AD", "Andorra" },
            { "AE", "Os Emiratos \u00c1rabes Unidos" },
            { "AF", "Afganist\u00e1n" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "A Ant\u00e1rtida" },
            { "AR", "A Arxentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Illas \u00c5land" },
            { "AZ", "Acerbaix\u00e1n" },
            { "BA", "Bosnia e Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "B\u00e9lxica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Illas Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribe Neerland\u00e9s" },
            { "BR", "O Brasil" },
            { "BS", "Bahamas" },
            { "BT", "But\u00e1n" },
            { "BV", "Illa Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belar\u00fas" },
            { "BZ", "Belize" },
            { "CA", "O Canad\u00e1" },
            { "CC", "Illas Cocos (Keeling)" },
            { "CD", "Rep\u00fablica Democr\u00e1tica do Congo" },
            { "CF", "Rep\u00fablica Centroafricana" },
            { "CG", "Rep\u00fablica do Congo" },
            { "CH", "Su\u00edza" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Illas Cook" },
            { "CL", "Chile" },
            { "CM", "Camer\u00fan" },
            { "CN", "A China" },
            { "CO", "Colombia" },
            { "CP", "Illa Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Illa Christmas" },
            { "CY", "Chipre" },
            { "CZ", "Chequia" },
            { "DE", "Alema\u00f1a" },
            { "DG", "Diego Garc\u00eda" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "DZ", "Alxeria" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Exipto" },
            { "EH", "O S\u00e1hara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "Espa\u00f1a" },
            { "ET", "Etiop\u00eda" },
            { "EU", "Uni\u00f3n Europea" },
            { "EZ", "Eurozona" },
            { "FI", "Finlandia" },
            { "FJ", "Fixi" },
            { "FK", "Illas Malvinas" },
            { "FM", "Micronesia" },
            { "FO", "Illas Feroe" },
            { "FR", "Francia" },
            { "GA", "Gab\u00f3n" },
            { "GB", "O Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Xeorxia" },
            { "GF", "G\u00fciana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Xibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Illas Xeorxia do Sur e Sandwich do Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "A Guinea Bissau" },
            { "GY", "G\u00fciana" },
            { "HK", "Hong Kong RAE da China" },
            { "HM", "Illa Heard e Illas McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croacia" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hungr\u00eda" },
            { "IC", "Illas Canarias" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Illa de Man" },
            { "IN", "A India" },
            { "IO", "Territorio Brit\u00e1nico do Oc\u00e9ano \u00cdndico" },
            { "IQ", "Iraq" },
            { "IR", "Ir\u00e1n" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Xamaica" },
            { "JO", "Xordania" },
            { "JP", "O Xap\u00f3n" },
            { "KE", "Kenya" },
            { "KG", "Kirguizist\u00e1n" },
            { "KH", "Camboxa" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "KN", "Saint Kitts e Nevis" },
            { "KP", "Corea do Norte" },
            { "KR", "Corea do Sur" },
            { "KW", "Kuwait" },
            { "KY", "Illas Caim\u00e1n" },
            { "KZ", "Kazakist\u00e1n" },
            { "LA", "Laos" },
            { "LB", "O L\u00edbano" },
            { "LC", "Santa Luc\u00eda" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgo" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Marrocos" },
            { "MC", "M\u00f3naco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Illas Marshall" },
            { "MK", "Macedonia do Norte" },
            { "ML", "Mal\u00ed" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "Macau RAE da China" },
            { "MP", "Illas Marianas do Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricio" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "M\u00e9xico" },
            { "MY", "Malaisia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nova Caledonia" },
            { "NE", "N\u00edxer" },
            { "NF", "Illa Norfolk" },
            { "NG", "Nixeria" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00edses Baixos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zelandia" },
            { "OM", "Om\u00e1n" },
            { "PA", "Panam\u00e1" },
            { "PE", "O Per\u00fa" },
            { "PF", "A Polinesia Francesa" },
            { "PG", "Pap\u00faa-Nova Guinea" },
            { "PH", "Filipinas" },
            { "PK", "Paquist\u00e1n" },
            { "PL", "Polonia" },
            { "PM", "Saint Pierre et Miquelon" },
            { "PN", "Illas Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "O Paraguai" },
            { "QA", "Qatar" },
            { "QO", "Territorios afastados de Ocean\u00eda" },
            { "RE", "Reuni\u00f3n" },
            { "RO", "Roman\u00eda" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Illas Salom\u00f3n" },
            { "SC", "Seychelles" },
            { "SD", "O Sud\u00e1n" },
            { "SE", "Suecia" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Eslovaquia" },
            { "SL", "Serra Leoa" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "O Sud\u00e1n do Sur" },
            { "ST", "San Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "O Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Eswatini" },
            { "TA", "Trist\u00e1n da Cunha" },
            { "TC", "Illas Turks e Caicos" },
            { "TD", "Chad" },
            { "TF", "Territorios Austrais Franceses" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Taxiquist\u00e1n" },
            { "TK", "Tokelau" },
            { "TL", "Timor Leste" },
            { "TM", "Turkmenist\u00e1n" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turqu\u00eda" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e1n" },
            { "TZ", "Tanzania" },
            { "UA", "Ucra\u00edna" },
            { "UG", "Uganda" },
            { "UM", "Illas Menores Distantes dos Estados Unidos" },
            { "UN", "Naci\u00f3ns Unidas" },
            { "US", "Os Estados Unidos" },
            { "UY", "O Uruguai" },
            { "UZ", "Uzbekist\u00e1n" },
            { "VA", "Cidade do Vaticano" },
            { "VC", "San Vicente e As Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Illas Virxes Brit\u00e1nicas" },
            { "VI", "Illas Virxes Estadounidenses" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudoacentos" },
            { "XB", "Pseudobidireccional" },
            { "XK", "Kosovo" },
            { "YE", "O Iemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sur\u00e1frica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Rexi\u00f3n desco\u00f1ecida" },
            { "aa", "afar" },
            { "ab", "abkhazo" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amh\u00e1rico" },
            { "an", "aragon\u00e9s" },
            { "ar", metaValue_ar },
            { "as", "assam\u00e9s" },
            { "av", "avar" },
            { "ay", "aimar\u00e1" },
            { "az", "acerbaixano" },
            { "ba", "baxkir" },
            { "be", "belaruso" },
            { "bg", "b\u00falgaro" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bret\u00f3n" },
            { "bs", "bosn\u00edaco" },
            { "ca", "catal\u00e1n" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cs", "checo" },
            { "cu", "eslavo eclesi\u00e1stico" },
            { "cv", "chuvaxo" },
            { "cy", "gal\u00e9s" },
            { "da", "dinamarqu\u00e9s" },
            { "de", "alem\u00e1n" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "ingl\u00e9s" },
            { "eo", "esperanto" },
            { "es", "espa\u00f1ol" },
            { "et", "estoniano" },
            { "eu", "\u00e9uscaro" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "fin\u00e9s" },
            { "fj", "fixiano" },
            { "fo", "fero\u00e9s" },
            { "fr", "franc\u00e9s" },
            { "fy", "fris\u00f3n occidental" },
            { "ga", "irland\u00e9s" },
            { "gd", "ga\u00e9lico escoc\u00e9s" },
            { "gl", "galego" },
            { "gn", "guaran\u00ed" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hr", "croata" },
            { "ht", "crioulo haitiano" },
            { "hu", "h\u00fangaro" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesio" },
            { "ig", "igbo" },
            { "ii", "yi sichuan\u00e9s" },
            { "io", "ido" },
            { "is", "island\u00e9s" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "xavan\u00e9s" },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazako" },
            { "kl", "groenland\u00e9s" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "caxemir\u00e9s" },
            { "ku", "kurdo" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnico" },
            { "ky", "kirguiz" },
            { "la", "lat\u00edn" },
            { "lb", "luxemburgu\u00e9s" },
            { "lg", "ganda" },
            { "li", "limburgu\u00e9s" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "let\u00f3n" },
            { "mg", "malgaxe" },
            { "mh", "marshal\u00e9s" },
            { "mi", "maor\u00ed" },
            { "mk", "macedonio" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malaio" },
            { "mt", "malt\u00e9s" },
            { "my", metaValue_my },
            { "na", "nauruano" },
            { "nb", "noruegu\u00e9s bokm\u00e5l" },
            { "nd", "ndebele setentrional" },
            { "ne", "nepal\u00ed" },
            { "ng", "ndonga" },
            { "nl", "neerland\u00e9s" },
            { "nn", "noruegu\u00e9s nynorsk" },
            { "no", "noruegu\u00e9s" },
            { "nr", "ndebele meridional" },
            { "nv", "navajo" },
            { "ny", "chewa" },
            { "oc", "occitano" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetio" },
            { "pa", "panxab\u00ed" },
            { "pl", "polaco" },
            { "ps", "paxto" },
            { "pt", "portugu\u00e9s" },
            { "qu", "quechua" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "ro", "roman\u00e9s" },
            { "ru", "ruso" },
            { "rw", "ki\u00f1aruanda" },
            { "sa", "s\u00e1nscrito" },
            { "sc", "sardo" },
            { "sd", "sindhi" },
            { "se", "saami setentrional" },
            { "sg", "sango" },
            { "sh", "serbocroata" },
            { "si", metaValue_si },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somal\u00ed" },
            { "sq", "alban\u00e9s" },
            { "sr", "serbio" },
            { "ss", "suazi" },
            { "st", "sesotho" },
            { "su", metaValue_su },
            { "sv", "sueco" },
            { "sw", "suahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "taxico" },
            { "th", metaValue_th },
            { "ti", "tigri\u00f1a" },
            { "tk", "turkmeno" },
            { "tl", "tagalo" },
            { "tn", "tswana" },
            { "to", "tongano" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "t\u00e1rtaro" },
            { "tw", "twi" },
            { "ty", "tahitiano" },
            { "ug", "uigur" },
            { "uk", "ucra\u00edno" },
            { "ur", "urd\u00fa" },
            { "uz", "uzbeko" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volapuk" },
            { "wa", "val\u00f3n" },
            { "wo", "w\u00f3lof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "ioruba" },
            { "zh", "chin\u00e9s" },
            { "zu", "zul\u00fa" },
            { "ace", "achin\u00e9s" },
            { "ach", "achol\u00ed" },
            { "ada", "adangme" },
            { "ady", "adigueo" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "ale", "aleutiano" },
            { "alt", "altai meridional" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameo" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "ars", "\u00e1rabe najdi" },
            { "asa", "asu" },
            { "ast", "asturiano" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "ban", "balin\u00e9s" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgn", "baluchi occidental" },
            { "bho", "bhojpuri" },
            { "bin", "bini" },
            { "bla", "siksik\u00e1" },
            { "brx", "bodo" },
            { "bug", "bugin\u00e9s" },
            { "byn", "blin" },
            { "cay", "cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "kiga" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "kurdo central" },
            { "clc", "chilcotin" },
            { "crg", "michif" },
            { "crj", "cree do sueste" },
            { "crk", "cree das chairas" },
            { "crl", "cree do nordeste" },
            { "crm", "cree de Moose" },
            { "crr", "algonquino de Carolina" },
            { "crs", "seselwa (crioulo das Seychelles)" },
            { "csw", "cree dos pantanos" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "baixo sorbio" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "exipcio antigo" },
            { "eka", "ekajuk" },
            { "ewo", "ewondo" },
            { "fil", "filipino" },
            { "fon", "fon" },
            { "frc", "franc\u00e9s cajun" },
            { "frr", "fris\u00f3n setentrional" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gez", "ge\u2019ez" },
            { "gil", "kiribatiano" },
            { "gor", "gorontalo" },
            { "grc", "grego antigo" },
            { "gsw", "alem\u00e1n su\u00edzo" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "haw", "hawaiano" },
            { "hax", "haida do sur" },
            { "hil", "hiligaynon" },
            { "hmn", "hmong" },
            { "hsb", "alto sorbio" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadense occidental" },
            { "ilo", "ilocano" },
            { "inh", "inguxo" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kab", "cabila" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kbd", "cabardiano" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "caboverdiano" },
            { "kfo", "koro" },
            { "kgp", "caingangue" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi permio" },
            { "kok", "konkani" },
            { "kpe", "kpelle" },
            { "krc", "carachaio-b\u00e1lcara" },
            { "krl", "carelio" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lsch" },
            { "kum", "kumyk" },
            { "kwk", "kwakiutl" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lez", "lezguio" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lou", "crioulo de Luisiana" },
            { "loz", "lozi" },
            { "lrc", "luri setentrional" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "madur\u00e9s" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "crioulo mauriciano" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "varias linguas" },
            { "mus", "creek" },
            { "mwl", "mirand\u00e9s" },
            { "myv", "erzya" },
            { "mzn", "mazandaran\u00ed" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "nds", "baixo alem\u00e1n" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueano" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "sesotho do norte" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibwa do noroeste" },
            { "ojc", "ojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa do oeste" },
            { "oka", "okanagan" },
            { "pag", "pangasinan" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauano" },
            { "pcm", "pidgin nixeriano" },
            { "pis", "pijin" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "prusiano" },
            { "quc", "quich\u00e9" },
            { "rap", "rapanui" },
            { "rar", "rarotongano" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rup", "aroman\u00e9s" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "iacuto" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliano" },
            { "sco", "escoc\u00e9s" },
            { "sdh", "kurdo meridional" },
            { "seh", "sena" },
            { "ses", "koyraboro senni" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "slh", "lushootseed do sur" },
            { "sma", "saami meridional" },
            { "smj", "saami de Lule" },
            { "smn", "saami de Inari" },
            { "sms", "saami skolt" },
            { "snk", "soninke" },
            { "srn", "sranan tongo" },
            { "ssy", "saho" },
            { "str", "salish dos estreitos" },
            { "suk", "sukuma" },
            { "swb", "comoriano" },
            { "syr", metaValue_syr },
            { "tce", "tutchone do sur" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "tetun" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigr\u00e9" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "ttm", "tutchone do norte" },
            { "tum", "tumbuka" },
            { "tvl", "tuval\u00e9s" },
            { "twq", "tasawaq" },
            { "tyv", "tuvaniano" },
            { "tzm", "tamazight de Marrocos central" },
            { "udm", "udmurto" },
            { "umb", "umbundu" },
            { "und", "lingua desco\u00f1ecida" },
            { "vai", metaValue_vai },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaytta" },
            { "war", "waray-waray" },
            { "wbp", "walrpiri" },
            { "wuu", "chin\u00e9s wu" },
            { "xal", "calmuco" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "canton\u00e9s" },
            { "zgh", "tamazight marroqu\u00ed est\u00e1ndar" },
            { "zun", "zuni" },
            { "zxx", "sen contido ling\u00fc\u00edstico" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "braille" },
            { "Cakm", metaValue_ccp },
            { "Cans", "silabario aborixe canadense unificado" },
            { "Cher", metaValue_chr },
            { "Cyrl", "cir\u00edlico" },
            { "Deva", "devan\u00e1gari" },
            { "Ethi", "et\u00edope" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han con bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hans", "simplificado" },
            { "Hant", "tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hrkt", "silabarios xaponeses" },
            { "Jamo", "jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "latino" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "meitei mayek" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Olck", "ol chiki" },
            { "Orya", metaValue_or },
            { "Rohg", "hanifi" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "yi" },
            { "Zmth", "notaci\u00f3n matem\u00e1tica" },
            { "Zsye", "emojis" },
            { "Zsym", "s\u00edmbolos" },
            { "Zxxx", "non escrito" },
            { "Zyyy", "com\u00fan" },
            { "Zzzz", "sistema de escritura desco\u00f1ecido" },
            { "de_AT", "alem\u00e1n austr\u00edaco" },
            { "de_CH", "alto alem\u00e1n su\u00edzo" },
            { "en_AU", "ingl\u00e9s australiano" },
            { "en_CA", "ingl\u00e9s canadense" },
            { "en_GB", "ingl\u00e9s brit\u00e1nico" },
            { "en_US", "ingl\u00e9s estadounidense" },
            { "es_ES", "espa\u00f1ol de Espa\u00f1a" },
            { "es_MX", "espa\u00f1ol de M\u00e9xico" },
            { "fa_AF", "dari" },
            { "fr_CA", "franc\u00e9s canadense" },
            { "fr_CH", "franc\u00e9s su\u00edzo" },
            { "nl_BE", "flamengo" },
            { "pt_BR", "portugu\u00e9s do Brasil" },
            { "pt_PT", "portugu\u00e9s de Portugal" },
            { "ro_MD", "moldavo" },
            { "sw_CD", "suahili congol\u00e9s" },
            { "ar_001", "\u00e1rabe est\u00e1ndar moderno" },
            { "es_419", "espa\u00f1ol de Am\u00e9rica" },
            { "key.ca", "calendario" },
            { "key.cf", "formato de moeda" },
            { "key.co", "criterio de ordenaci\u00f3n" },
            { "key.cu", "moeda" },
            { "key.hc", "ciclo horario (12 ou 24)" },
            { "key.lb", "estilo de quebra de li\u00f1a" },
            { "key.ms", "sistema internacional de unidades" },
            { "key.nu", "n\u00fameros" },
            { "key.tz", "fuso horario" },
            { "key.va", "variante rexional" },
            { "nds_NL", "baixo sax\u00f3n" },
            { "hi_Latn", "hindi (alfabeto latino)" },
            { "zh_Hans", "chin\u00e9s simplificado" },
            { "zh_Hant", "chin\u00e9s tradicional" },
            { "type.ca.roc", "calendario Minguo" },
            { "type.hc.h11", "sistema de 12 horas (0\u201311)" },
            { "type.hc.h12", "sistema de 12 horas (1\u201312)" },
            { "type.hc.h23", "sistema de 24 horas (0\u201323)" },
            { "type.hc.h24", "sistema de 24 horas (1\u201324)" },
            { "type.m0.bgn", "transliteraci\u00f3n do BGN" },
            { "type.nu.arab", "d\u00edxitos indoar\u00e1bigos" },
            { "type.nu.armn", "numeraci\u00f3n armenia" },
            { "type.nu.beng", "d\u00edxitos bengal\u00eds" },
            { "type.nu.cakm", "d\u00edxitos chakmas" },
            { "type.nu.deva", "d\u00edxitos devanag\u00e1ricos" },
            { "type.nu.ethi", "numeraci\u00f3n et\u00edope" },
            { "type.nu.geor", "numeraci\u00f3n xeorxiana" },
            { "type.nu.grek", "numeraci\u00f3n grega" },
            { "type.nu.gujr", "d\u00edxitos guxaratis" },
            { "type.nu.guru", "d\u00edxitos gurmukhis" },
            { "type.nu.hans", "numeraci\u00f3n chinesa simplificada" },
            { "type.nu.hant", "numeraci\u00f3n chinesa tradicional" },
            { "type.nu.hebr", "numeraci\u00f3n hebrea" },
            { "type.nu.java", "d\u00edxitos xavaneses" },
            { "type.nu.jpan", "numeraci\u00f3n xaponesa" },
            { "type.nu.khmr", "d\u00edxitos khmer" },
            { "type.nu.knda", "d\u00edxitos kannar\u00e1s" },
            { "type.nu.laoo", "d\u00edxitos laosianos" },
            { "type.nu.latn", "d\u00edxitos occidentais" },
            { "type.nu.mlym", "d\u00edxitos malabares" },
            { "type.nu.mong", "D\u00edxitos mongoles" },
            { "type.nu.mtei", "d\u00edxitos meitei mayek" },
            { "type.nu.mymr", "d\u00edxitos birmanos" },
            { "type.nu.olck", "d\u00edxitos ol chiki" },
            { "type.nu.orya", "d\u00edxitos odi\u00e1" },
            { "type.nu.taml", "numeraci\u00f3n t\u00e1mil tradicional" },
            { "type.nu.telu", "d\u00edxitos telugus" },
            { "type.nu.thai", "d\u00edxitos tailandeses" },
            { "type.nu.tibt", "d\u00edxitos tibetanos" },
            { "type.nu.vaii", "d\u00edxitos vai" },
            { "type.ca.dangi", "calendario dangi" },
            { "type.co.ducet", "criterio de ordenaci\u00f3n Unicode predeterminado" },
            { "type.lb.loose", "estilo de quebra de li\u00f1a flexible" },
            { "type.nu.roman", "numeraci\u00f3n romana" },
            { "type.ca.coptic", "calendario copto" },
            { "type.ca.hebrew", "calendario hebreo" },
            { "type.ca.indian", "Calendario nacional indio" },
            { "type.co.pinyin", "Orde de clasificaci\u00f3n pinyin" },
            { "type.co.search", "busca de car\u00e1cter xeral" },
            { "type.co.stroke", "Orde de clasificaci\u00f3n polo n\u00famero de trazos" },
            { "type.co.unihan", "Criterio de ordenaci\u00f3n radical-trazo" },
            { "type.d0.fwidth", "ancho completo" },
            { "type.d0.hwidth", "ancho medio" },
            { "type.lb.normal", "estilo de quebra de li\u00f1a normal" },
            { "type.lb.strict", "estilo de quebra de li\u00f1a estrita" },
            { "type.m0.ungegn", "transliteraci\u00f3n do UNGEGN" },
            { "type.ms.metric", "sistema m\u00e9trico decimal" },
            { "type.nu.native", "d\u00edxitos nativos" },
            { "type.ca.chinese", "calendario chin\u00e9s" },
            { "type.ca.islamic", "calendario isl\u00e1mico" },
            { "type.ca.iso8601", "calendario ISO-8601" },
            { "type.ca.persian", "calendario persa" },
            { "type.cf.account", "formato de moeda contable" },
            { "type.co.big5han", "Orde de clasificaci\u00f3n chinesa tradicional - Big5" },
            { "type.d0.npinyin", "Num\u00e9rico" },
            { "type.nu.arabext", "d\u00edxitos indoar\u00e1bigos ampliados" },
            { "type.nu.armnlow", "numeraci\u00f3n armenia en min\u00fascula" },
            { "type.nu.finance", "N\u00fameros financeiros" },
            { "type.nu.greklow", "numeraci\u00f3n grega en min\u00fascula" },
            { "type.nu.hanidec", "numeraci\u00f3n decimal chinesa" },
            { "type.nu.hansfin", "numeraci\u00f3n financeira chinesa simplificada" },
            { "type.nu.hantfin", "numeraci\u00f3n financeira chinesa tradicional" },
            { "type.nu.jpanfin", "numeraci\u00f3n financeira xaponesa" },
            { "type.nu.tamldec", "d\u00edxitos t\u00e1miles" },
            { "type.ca.buddhist", "calendario budista" },
            { "type.ca.ethiopic", "calendario et\u00edope" },
            { "type.ca.japanese", "calendario xapon\u00e9s" },
            { "type.cf.standard", "formato de moeda est\u00e1ndar" },
            { "type.co.phonetic", "Orde de clasificaci\u00f3n fon\u00e9tica" },
            { "type.co.reformed", "Criterio de ordenaci\u00f3n reformado" },
            { "type.co.searchjl", "Clasificar por consonante inicial hangul" },
            { "type.co.standard", "criterio de ordenaci\u00f3n est\u00e1ndar" },
            { "type.ms.uksystem", "sistema imperial de unidades" },
            { "type.ms.ussystem", "sistema estadounidense de unidades" },
            { "type.nu.fullwide", "d\u00edxitos de ancho completo" },
            { "type.nu.romanlow", "numeraci\u00f3n romana en min\u00fasculas" },
            { "type.ca.gregorian", "calendario gregoriano" },
            { "type.co.gb2312han", "orde de clasifcaci\u00f3n chinesa simplificada - GB2312" },
            { "type.co.phonebook", "orde de clasificaci\u00f3n da gu\u00eda telef\u00f3nica" },
            { "type.co.dictionary", "Criterio de ordenaci\u00f3n do dicionario" },
            { "type.co.traditional", "Orde de clasificaci\u00f3n tradicional" },
            { "type.nu.traditional", "Numeros tradicionais" },
            { "type.ca.islamic-rgsa", "Calendario isl\u00e1mico (Arabia Saudita," },
            { "type.ca.islamic-civil", "calendario isl\u00e1mico (tabular, \u00e9poca civil)" },
            { "type.ca.islamic-umalqura", "calendario isl\u00e1mico (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendario et\u00edope amete alem" },
        };
        return data;
    }
}
