/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.providersupport.shared;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingProvider;
import org.openhab.core.thing.ThingStatus;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.events.ThingStatusInfoEvent;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ScriptedThingProvider.class, ThingProvider.class, EventSubscriber.class})
public class ScriptedThingProvider
extends AbstractProvider<Thing>
implements ThingProvider,
ManagedProvider<Thing, ThingUID>,
EventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(ScriptedThingProvider.class);
    private final Map<ThingUID, Thing> things = new HashMap<ThingUID, Thing>();

    public Collection<Thing> getAll() {
        return this.things.values();
    }

    public @Nullable Thing get(ThingUID uid) {
        return this.things.get(uid);
    }

    public void add(Thing thing) {
        if (this.things.get(thing.getUID()) != null) {
            throw new IllegalArgumentException("Cannot add thing, because a thing with same UID (" + String.valueOf(thing.getUID()) + ") already exists.");
        }
        this.things.put(thing.getUID(), thing);
        this.notifyListenersAboutAddedElement(thing);
    }

    public @Nullable Thing update(Thing thing) {
        Thing oldThing = this.things.get(thing.getUID());
        if (oldThing != null) {
            this.things.put(thing.getUID(), thing);
            this.notifyListenersAboutUpdatedElement(oldThing, thing);
        } else {
            this.logger.warn("Cannot update thing with UID '{}', because it does not exist.", (Object)thing.getUID());
        }
        return oldThing;
    }

    public @Nullable Thing remove(ThingUID uid) {
        Thing thing = this.things.remove(uid);
        if (thing != null) {
            this.notifyListenersAboutRemovedElement(thing);
        }
        return thing;
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of(ThingStatusInfoEvent.TYPE);
    }

    public void receive(Event event) {
        ThingStatusInfoEvent thingStatusInfoEvent;
        if (event instanceof ThingStatusInfoEvent && (thingStatusInfoEvent = (ThingStatusInfoEvent)event).getStatusInfo().getStatus() == ThingStatus.REMOVED) {
            this.remove(thingStatusInfoEvent.getThingUID());
        }
    }
}

