# Summary

- [Introduction](./introduction.md)
- [Requirements](./requirements.md)
- [Library Usage with `build.rs`](./library-usage.md)
    - [Tutorial](./tutorial-0.md)
        - [Add `bindgen` as a Build Dependency](./tutorial-1.md)
        - [Create a `wrapper.h` Header](./tutorial-2.md)
        - [Create a `build.rs` File](./tutorial-3.md)
        - [Include the Generated Bindings in `src/lib.rs`](./tutorial-4.md)
        - [Write a Sanity Test](./tutorial-5.md)
        - [Publish Your Crate!](./tutorial-6.md)
    - [Bindings for non-system libraries](./non-system-libraries.md)
- [Command Line Usage](./command-line-usage.md)
- [Customizing the Generated Bindings](./customizing-generated-bindings.md)
    - [Allowlisting](./allowlisting.md)
    - [Blocklisting](./blocklisting.md)
    - [Treating a Type as an Opaque Blob of Bytes](./opaque.md)
    - [Replacing One Type with Another](./replacing-types.md)
    - [Preventing the Derivation of `Copy` and `Clone`](./nocopy.md)
    - [Preventing the Derivation of `Debug`](./nodebug.md)
    - [Preventing the Derivation of `Default`](./nodefault.md)
    - [Annotating types with `#[must-use]`](./must-use-types.md)
    - [Field visibility](./visibility.md)
    - [Code formatting](./code-formatting.md)
- [Generating Bindings to C++](./cpp.md)
- [Generating Bindings to Objective-c](./objc.md)
- [Using Unions](./using-unions.md)
- [Using Bitfields](./using-bitfields.md)
- [Using Flexible Array Members](./using-fam.md)
- [FAQ](./faq.md)
