package provider

import (
	"context"

	"github.com/ipfs/go-cid"
)

type noopProvider struct{}

var _ System = (*noopProvider)(nil)

// NewNoopProvider creates a ProviderSystem that does nothing.
func NewNoopProvider() System {
	return &noopProvider{}
}

func (op *noopProvider) Clear() int {
	return 0
}

func (op *noopProvider) Close() error {
	return nil
}

func (op *noopProvider) Provide(context.Context, cid.Cid, bool) error {
	return nil
}

func (op *noopProvider) Reprovide(context.Context) error {
	return nil
}

func (op *noopProvider) Stat() (ReproviderStats, error) {
	return ReproviderStats{}, nil
}

func (op *noopProvider) SetKeyProvider(KeyChanFunc) {
}
