/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature.text;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0000\u001a\u001f\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\t\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u00a8\u0006\u000f"}, d2={"calculateTfIdfScore", "", "token", "", "context", "", "hammingDistance", "s1", "s2", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Double;", "jaccardDistance", "levenshteinDistance", "", "lhs", "rhs", "mlapi-core"})
@SourceDebugExtension(value={"SMAP\nTokenAverageDistances.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenAverageDistances.kt\ncom/jetbrains/mlapi/feature/text/TokenAverageDistancesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1774#2,4:111\n1774#2,4:115\n*S KotlinDebug\n*F\n+ 1 TokenAverageDistances.kt\ncom/jetbrains/mlapi/feature/text/TokenAverageDistancesKt\n*L\n71#1:111,4\n78#1:115,4\n*E\n"})
public final class TokenAverageDistancesKt {
    public static final double calculateTfIdfScore(@NotNull String token, @NotNull List<String> context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Iterable $this$count$iv = context;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)token) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        double termFrequency = (double)n / (double)context.size();
        int documentFrequency = 1;
        return termFrequency * Math.log((double)(1 + context.size()) / (double)(1 + documentFrequency)) + 1.0;
    }

    @Nullable
    public static final Double hammingDistance(@NotNull String s1, @NotNull String s2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (s1.length() != s2.length()) {
            return null;
        }
        Iterable $this$count$iv = StringsKt.zip((CharSequence)s1, (CharSequence)s2);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!(((Character)it.getFirst()).charValue() != ((Character)it.getSecond()).charValue()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return (double)n / (double)s1.length();
    }

    public static final double jaccardDistance(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        Set set1 = StringsKt.toSet((CharSequence)s1);
        Set set2 = StringsKt.toSet((CharSequence)s2);
        int intersection = CollectionsKt.intersect((Iterable)set1, (Iterable)set2).size();
        int union = CollectionsKt.union((Iterable)set1, (Iterable)set2).size();
        return 1.0 - (double)intersection / (double)union;
    }

    public static final int levenshteinDistance(@NotNull String lhs, @NotNull String rhs) {
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        int lhsLength = lhs.length();
        int rhsLength = rhs.length();
        int n = 0;
        int n2 = lhsLength + 1;
        Integer[] integerArray = new Integer[n2];
        while (n < n2) {
            int n3 = n++;
            integerArray[n3] = n3;
        }
        Integer[] cost = integerArray;
        n2 = 0;
        int n4 = lhsLength + 1;
        Integer[] integerArray2 = new Integer[n4];
        while (n2 < n4) {
            int n5 = n2++;
            integerArray2[n5] = 0;
        }
        Integer[] newCost = integerArray2;
        int j = 1;
        if (j <= rhsLength) {
            while (true) {
                newCost[0] = j;
                int i = 1;
                if (i <= lhsLength) {
                    while (true) {
                        int match = lhs.charAt(i - 1) == rhs.charAt(j - 1) ? 0 : 1;
                        int costReplace = cost[i - 1] + match;
                        int costInsert = cost[i] + 1;
                        int costDelete = newCost[i - 1] + 1;
                        newCost[i] = Math.min(costInsert, Math.min(costDelete, costReplace));
                        if (i == lhsLength) break;
                        ++i;
                    }
                }
                Integer[] swap = cost;
                cost = newCost;
                newCost = swap;
                if (j == rhsLength) break;
                ++j;
            }
        }
        return cost[lhsLength];
    }
}

