/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Pair;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RemoteConnectionPool {
    private static final Logger LOG = Logger.getInstance(RemoteConnection.class);
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    private static final int INITIAL_WAITING_RCONNECT_TIMEOUT_SECONDS = 3;
    private static final EventDispatcher<ForceDisconnectListener> DUMMY_DISCONNECT_TRIGGER = EventDispatcher.create(ForceDisconnectListener.class);
    private final Collection<RemoteConnection> myConnections;
    private final Object myConnectionsLock;
    private final Connectable myConnectable;
    @NotNull
    private final String myTitle;
    private final FileTransferConfig.Origin myOrigin;
    @NotNull
    private final ConnectionOwner myConnectionOwner;
    private volatile boolean isClosed;
    private final Semaphore myConnectionCreationSemaphore;
    private volatile Future myConnectionCreationFuture;
    private final boolean hasDisconnectTrigger;
    private volatile boolean myCloseFSOnNoConnections;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isClosed = true;
        Future future = this.myConnectionCreationFuture;
        if (future != null) {
            future.cancel(true);
        }
        this.myConnectionCreationSemaphore.release();
        Object object = this.myConnectionsLock;
        synchronized (object) {
            for (RemoteConnection connection : this.myConnections) {
                connection.release();
            }
        }
        this.closeFileSystemIfEmpty(true, true);
    }

    @NotNull
    private FileSystemOptions getConsequentConnectionOptions() {
        FileSystemOptions fileSystemOptions = this.myConnectable.getConnectionOptions(this.myConnectionOwner, this.myTitle, this.myOrigin, (EventDispatcher<ForceDisconnectListener>)(this.hasDisconnectTrigger ? DUMMY_DISCONNECT_TRIGGER : null), null);
        if (fileSystemOptions == null) {
            RemoteConnectionPool.$$$reportNull$$$0(0);
        }
        return fileSystemOptions;
    }

    RemoteConnectionPool(@NotNull Connectable connectable, @NotNull ConnectionOwner connectionOwner, @NotNull String title, FileTransferConfig.Origin origin, EventDispatcher<ForceDisconnectListener> trigger) {
        if (connectable == null) {
            RemoteConnectionPool.$$$reportNull$$$0(1);
        }
        if (connectionOwner == null) {
            RemoteConnectionPool.$$$reportNull$$$0(2);
        }
        if (title == null) {
            RemoteConnectionPool.$$$reportNull$$$0(3);
        }
        this.myConnections = new ArrayList<RemoteConnection>();
        this.myConnectionsLock = new Object();
        this.isClosed = false;
        this.myConnectionCreationSemaphore = new Semaphore(1);
        this.myConnectionCreationFuture = null;
        this.myConnectable = connectable.copyToImmutable();
        this.myConnectionOwner = connectionOwner;
        this.myTitle = title;
        this.myOrigin = origin;
        this.myCloseFSOnNoConnections = RemoteConnectionPool.shouldCloseFSOnNoConnections();
        this.hasDisconnectTrigger = trigger != null;
    }

    private static boolean shouldCloseFSOnNoConnections() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    void notifyServersUpdated(@NotNull @NotNull List<@NotNull Pair<@NotNull WebServerConfig, @Nullable Project>> servers) {
        if (servers == null) {
            RemoteConnectionPool.$$$reportNull$$$0(4);
        }
        Pair<@NotNull WebServerConfig, @Nullable Project> basePair = null;
        for (Pair<WebServerConfig, Project> server : servers) {
            if (!this.myConnectable.isBasedOnServer((WebServerConfig)server.getFirst())) continue;
            basePair = server;
            break;
        }
        if (basePair == null) {
            return;
        }
        if (!this.myCloseFSOnNoConnections) {
            Deployable newConnectable;
            FileSystemOptions newOptions;
            FileSystemOptions options = this.myConnectable.getConnectionOptions(this.myConnectionOwner, this.myTitle, this.myOrigin, null, null);
            if (options.equals((Object)(newOptions = (newConnectable = Deployable.create((WebServerConfig)basePair.getFirst(), (Project)basePair.getSecond())).getConnectionOptions(this.myConnectionOwner, this.myTitle, this.myOrigin, null, null)))) {
                return;
            }
            this.myCloseFSOnNoConnections = true;
            this.closeFileSystemIfEmpty(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteConnection createConnection(@Nullable EventDispatcher<ForceDisconnectListener> forceDisconnectDispatcher, @Nullable ProgressIndicator pi) throws FileSystemException {
        this.checkClosed();
        Object object = this.myConnectionsLock;
        synchronized (object) {
            this.checkClosed();
            if (!this.myConnections.isEmpty()) {
                LOG.debug("Reusing connection to " + this.myConnectable.getRootUri() + this.getInDebugHash());
                RemoteConnection existing = this.myConnections.iterator().next();
                return existing.clone();
            }
        }
        FileSystemManager manager = RemoteConnectionManager.getInstance().getManager();
        AtomicReference exception = new AtomicReference();
        AtomicReference<FileObject> root = new AtomicReference<FileObject>();
        this.myConnectionCreationSemaphore.acquireUninterruptibly();
        if (this.isClosed) {
            this.myConnectionCreationSemaphore.release();
            this.checkClosed();
        }
        this.myConnectionCreationFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                try {
                    this.checkClosed();
                }
                catch (FileSystemException e) {
                    exception.set(e);
                    this.myConnectionCreationSemaphore.release();
                    return;
                }
                LOG.debug("Opening connection to " + this.myConnectable.getRootUri() + this.getInDebugHash());
                int iteration = 0;
                while (iteration == 0 || iteration < 5 && RemoteConnectionPool.shouldRetryConnecting((FileSystemException)((Object)((Object)exception.get())))) {
                    try {
                        RemoteConnectionPool.waitBeforeNextAttempt(pi, ++iteration);
                        RemoteConnectionPool.setProgressSecondText(pi, WDBundle.message("connecting", new Object[0]));
                        this.checkClosed();
                        root.set(manager.resolveFile(this.myConnectable.getRootUri(), this.myConnectable.getConnectionOptions(this.myConnectionOwner, this.myTitle, this.myOrigin, forceDisconnectDispatcher, pi)));
                        ((FileObject)root.get()).getChild(".");
                        exception.set(null);
                        break;
                    }
                    catch (FileSystemException e) {
                        LOG.warn("Retrying connecting to " + this.myConnectable.getRootUri() + this.getInDebugHash() + ": " + iteration + " iterations", (Throwable)e);
                        exception.set(e);
                    }
                    catch (ProcessCanceledException e) {
                        LOG.warn("Connection cancelled to " + this.myConnectable.getRootUri() + this.getInDebugHash());
                        exception.set(new CustomFileSystemException("Connection was cancelled", e));
                        break;
                    }
                    catch (Throwable e) {
                        LOG.warn(e);
                        exception.set(new CustomFileSystemException("Connection failed", e));
                        break;
                    }
                }
            }
            finally {
                this.myConnectionCreationSemaphore.release();
            }
        });
        try {
            this.myConnectionCreationFuture.get();
        }
        catch (InterruptedException e) {
            RemoteConnectionPool.handleException(WDBundle.message("exception.connection.was.interrupted", new Object[0]), e, root, manager);
        }
        catch (ExecutionException e) {
            RemoteConnectionPool.handleException(WDBundle.message("exception.connection.failed", new Object[0]), e, root, manager);
        }
        catch (CancellationException e) {
            RemoteConnectionPool.handleException(WDBundle.message("exception.connection.was.cancelled", new Object[0]), e, root, manager);
        }
        this.checkClosed();
        RemoteConnectionPool.setProgressSecondText(pi, null);
        if (exception.get() != null) {
            if (root.get() != null) {
                RemoteConnectionPool.closeFileSystem(manager, root.get().getFileSystem(), false);
            }
            throw (FileSystemException)((Object)exception.get());
        }
        RemoteConnectionImpl connection = new RemoteConnectionImpl(root.get().getName());
        Object object2 = this.myConnectionsLock;
        synchronized (object2) {
            this.checkClosed();
            this.myConnections.add(connection);
            LOG.debug("Added connection to pool of" + this.myConnectable.getRootUri() + this.getInDebugHash() + "; " + this.myConnections.size() + " connections exists");
        }
        this.myCloseFSOnNoConnections = RemoteConnectionPool.shouldCloseFSOnNoConnections();
        return connection;
    }

    private static void handleException(String message, Exception e, AtomicReference<FileObject> root, FileSystemManager manager) throws CustomFileSystemException {
        if (root.get() != null) {
            RemoteConnectionPool.closeFileSystem(manager, root.get().getFileSystem(), false);
        }
        throw new CustomFileSystemException(message, e);
    }

    private void checkClosed() throws FileSystemException {
        if (this.isClosed) {
            throw new CustomFileSystemException("Connection pool already closed");
        }
    }

    private static void waitBeforeNextAttempt(@Nullable ProgressIndicator pi, int iteration) {
        int timeout;
        RemoteConnectionPool.checkProgressCancelled(pi);
        if (iteration == 1) {
            return;
        }
        RemoteConnectionPool.setProgressSecondText(pi, WDBundle.message("attempt.0.failed.to.connect.waiting.for.1.to.retry", iteration, RemoteConnectionPool.getPresentableTime(timeout)));
        if (pi != null) {
            for (timeout = pi == null ? 3 : (int)Math.pow(3.0, iteration); timeout > 0; --timeout) {
                RemoteConnectionPool.checkProgressCancelled(pi);
                RemoteConnectionPool.setProgressSecondText(pi, WDBundle.message("attempt.0.failed.to.connect.waiting.for.1.to.retry", iteration, RemoteConnectionPool.getPresentableTime(timeout)));
                RemoteConnectionPool.sleep(1);
            }
        } else {
            RemoteConnectionPool.sleep(timeout);
        }
        RemoteConnectionPool.checkProgressCancelled(pi);
    }

    private static String getPresentableTime(int timeout) {
        if (timeout > 120) {
            return WDBundle.message("0.minutes", timeout / 60);
        }
        if (timeout > 60) {
            return WDBundle.message("a.minute", new Object[0]);
        }
        if (timeout == 1) {
            return WDBundle.message("a.second", new Object[0]);
        }
        return WDBundle.message("0.seconds", timeout);
    }

    private static void sleep(int timeout) {
        try {
            TimeUnit.SECONDS.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void setProgressSecondText(@Nullable ProgressIndicator pi, @NlsContexts.ProgressDetails String text) {
        if (pi != null) {
            pi.setText2(text);
        }
    }

    private static void checkProgressCancelled(@Nullable ProgressIndicator pi) {
        if (pi != null) {
            pi.checkCanceled();
        }
    }

    private static boolean shouldRetryConnecting(FileSystemException exception) {
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ConnectException) && !(cause instanceof FTPConnectionClosedException)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(RemoteConnection connection) {
        Object object = this.myConnectionsLock;
        synchronized (object) {
            boolean removed = this.myConnections.remove(connection);
            if (removed) {
                LOG.debug("Releasing one of the connections to " + this.myConnectable.getRootUri() + this.getInDebugHash() + "; connections left " + this.myConnections.size());
            }
        }
        this.closeFileSystemIfEmpty(false, false);
    }

    private static void closeFileSystem(@NotNull FileSystemManager manager, @Nullable FileSystem fileSystem, boolean tryToDoImmediately) {
        if (manager == null) {
            RemoteConnectionPool.$$$reportNull$$$0(5);
        }
        if (fileSystem == null) {
            return;
        }
        if (tryToDoImmediately) {
            manager.tryCloseFileSystem(fileSystem);
        } else {
            manager.closeFileSystem(fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFileSystemIfEmpty(boolean forceClosingOnNonEmpty, boolean tryToDoImmediately) {
        if (!tryToDoImmediately) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
        if (!forceClosingOnNonEmpty) {
            if (!this.myCloseFSOnNoConnections) {
                return;
            }
            Object object = this.myConnectionsLock;
            synchronized (object) {
                if (!this.myConnections.isEmpty()) {
                    return;
                }
            }
        }
        if (forceClosingOnNonEmpty) {
            LOG.warn("Forced closing file system of " + this.myConnectable.getRootUri() + this.getInDebugHash());
        } else {
            LOG.debug("Empty connection pool for " + this.myConnectable.getRootUri() + this.getInDebugHash());
        }
        RemoteConnectionManager connectionManager = (RemoteConnectionManager)ApplicationManager.getApplication().getServiceIfCreated(RemoteConnectionManager.class);
        if (connectionManager != null) {
            FileSystemManager manager = connectionManager.getManager();
            FileSystem fileSystem = this.findOrCreateFileSystem(true, manager);
            RemoteConnectionPool.closeFileSystem(manager, fileSystem, tryToDoImmediately);
        }
        LOG.debug("File system of " + this.myConnectable.getRootUri() + this.getInDebugHash() + " is closed.");
    }

    @Nullable
    private FileSystem findOrCreateFileSystem(boolean cachedOnly, @NotNull FileSystemManager manager) {
        if (manager == null) {
            RemoteConnectionPool.$$$reportNull$$$0(6);
        }
        FileSystemOptions options = this.getConsequentConnectionOptions();
        try {
            return manager.findOrCreateFileSystem(this.myConnectable.getRootUri(), options, cachedOnly);
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NonNls
    public String toString() {
        return "Pool for " + this.myConnectable.getRootUri() + this.getInDebugHash();
    }

    @NonNls
    private String getInDebugHash() {
        return " in @" + Integer.toHexString(this.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionOwner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsequentConnectionOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyServersUpdated";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "closeFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateFileSystem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private final class RemoteConnectionImpl
    extends RemoteConnection {
        private final AtomicBoolean myIsReleased;
        private final Object myLock;

        private RemoteConnectionImpl(FileName rootName) {
            super(rootName);
            this.myIsReleased = new AtomicBoolean(false);
            this.myLock = new Object();
        }

        @Override
        public FileObject resolveFile(String path) throws FileSystemException {
            return this.getSystem().resolveFile(path);
        }

        private FileSystem getSystem() throws FileSystemException {
            FileSystemManager manager = RemoteConnectionManager.getInstance().getManager();
            FileSystemOptions options = RemoteConnectionPool.this.getConsequentConnectionOptions();
            return manager.findOrCreateFileSystem(RemoteConnectionPool.this.myConnectable.getRootUri(), options, false);
        }

        @Override
        @Nullable
        public FileName resolveFileName(String path) throws FileSystemException {
            FileSystem fileSystem = this.getSystem();
            return fileSystem.getFileSystemManager().resolveName(fileSystem.getRootName(), path);
        }

        @Override
        @Nullable
        public FileObject resolveFile(@NotNull FileName fileName) throws FileSystemException {
            if (fileName == null) {
                RemoteConnectionImpl.$$$reportNull$$$0(0);
            }
            return this.getSystem().resolveFile(fileName);
        }

        @Override
        public void release() {
            this.myIsReleased.set(true);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                Object object = this.myLock;
                synchronized (object) {
                    RemoteConnectionPool.this.releaseConnection(this);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T executeServerOperation(ThrowableComputable<T, ? extends FileSystemException> computable, @Nullable ProgressIndicator pi) throws FileSystemException {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myIsReleased.get()) {
                    if (pi != null) {
                        pi.cancel();
                    }
                    throw new ProcessCanceledException();
                }
                return (T)computable.compute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RemoteConnection clone() {
            RemoteConnectionImpl result = new RemoteConnectionImpl(this.getRootName());
            Object object = RemoteConnectionPool.this.myConnectionsLock;
            synchronized (object) {
                RemoteConnectionPool.this.myConnections.add(result);
                LOG.debug("Added cloned connection to pool of" + RemoteConnectionPool.this.myConnectable.getRootUri() + RemoteConnectionPool.this.getInDebugHash() + "; " + RemoteConnectionPool.this.myConnections.size() + " connections exists");
            }
            RemoteConnectionPool.this.myCloseFSOnNoConnections = RemoteConnectionPool.shouldCloseFSOnNoConnections();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool$RemoteConnectionImpl", "resolveFile"));
        }
    }
}

