/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004\u001f !\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0003JL\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0016J4\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lcom/intellij/database/run/actions/GridCellValueLoader;", "", "errorText", "", "<init>", "(Ljava/lang/String;)V", "getErrorText", "()Ljava/lang/String;", "size", "", "loadCellValue", "", "dataGrid", "Lcom/intellij/database/datagrid/DataGrid;", "project", "Lcom/intellij/openapi/project/Project;", "rowIndex", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "colIndex", "Lcom/intellij/database/datagrid/GridColumn;", "operation", "Lkotlin/Function2;", "getWhereClauseColumns", "", "columnToExclude", "dbms", "Lcom/intellij/database/Dbms;", "table", "Lcom/intellij/database/model/DasObject;", "columns", "MyAbstractGridDataRequest", "MyCellValueRequest", "MyTestRowCountRequest", "MyGetCellValueWithoutFilterRequest", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nGridCellValueLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridCellValueLoader.kt\ncom/intellij/database/run/actions/GridCellValueLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1563#2:219\n1634#2,3:220\n774#2:223\n865#2,2:224\n*S KotlinDebug\n*F\n+ 1 GridCellValueLoader.kt\ncom/intellij/database/run/actions/GridCellValueLoader\n*L\n68#1:219\n68#1:220,3\n79#1:223\n79#1:224,2\n*E\n"})
public final class GridCellValueLoader {
    @NotNull
    private final String errorText;

    public GridCellValueLoader(@NotNull String errorText) {
        Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
        this.errorText = errorText;
    }

    @NotNull
    public final String getErrorText() {
        return this.errorText;
    }

    @NlsSafe
    private final String getErrorText(int size) {
        String string;
        if (size == 0) {
            string = DataGridBundle.message((String)"action.Console.TableResult.SaveLobAsAction.TableChanged.text", (Object[])new Object[0]);
        } else {
            Object[] objectArray = new Object[]{size};
            string = DataGridBundle.message((String)"action.Console.TableResult.SaveLobAsAction.AmbiguousQueryResult.text", (Object[])objectArray);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String message = string2;
        return this.errorText + ": " + message;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadCellValue(@NotNull DataGrid dataGrid, @NotNull Project project, @NotNull ModelIndex<GridRow> rowIndex, @NotNull ModelIndex<GridColumn> colIndex, @NotNull Function2<? super GridRow, ? super GridColumn, Unit> operation) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rowIndex, (String)"rowIndex");
        Intrinsics.checkNotNullParameter(colIndex, (String)"colIndex");
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        if (!rowIndex.isValid((CoreGrid)dataGrid) || !colIndex.isValid((CoreGrid)dataGrid)) {
            return;
        }
        GridModel gridModel = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel model = gridModel;
        if (model.getValueAt(rowIndex, colIndex) == null) {
            return;
        }
        GridRow gridRow = (GridRow)model.getRow(rowIndex);
        if (gridRow == null) {
            return;
        }
        GridRow originalRow = gridRow;
        GridColumn gridColumn = (GridColumn)model.getColumn(colIndex);
        if (gridColumn == null) {
            return;
        }
        GridColumn column2 = gridColumn;
        DatabaseGridDataHookUp databaseGridDataHookUp = DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)((CoreGrid)dataGrid));
        Intrinsics.checkNotNullExpressionValue((Object)databaseGridDataHookUp, (String)"getDatabaseHookUp(...)");
        DatabaseGridDataHookUp gridDataHookup = databaseGridDataHookUp;
        String string = gridDataHookup.getUnlimitedQueryText(true);
        if (string == null) {
            return;
        }
        String queryText = string;
        DbDataSource dbDataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid)((CoreGrid)dataGrid));
        if (dbDataSource == null) {
            return;
        }
        DbDataSource dbDataSource2 = dbDataSource;
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid)((CoreGrid)dataGrid));
        List list = model.getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        List columns = list;
        List<GridColumn> filtered = this.getWhereClauseColumns(column2, dbms2, table, columns);
        if (filtered.isEmpty() && model.getRowCount() == 1) {
            DataRequest.Constraints constraints = DataRequest.newConstraints((int)(originalRow.getRowNum() - 1), (int)1, (int)0, (int)gridDataHookup.getSubQueryIndex(), (int)gridDataHookup.getResultSetIndex());
            Intrinsics.checkNotNull((Object)constraints);
            MyGetCellValueWithoutFilterRequest request2 = new MyGetCellValueWithoutFilterRequest(this, gridDataHookup, constraints, dbDataSource2, project, column2, operation);
            gridDataHookup.getMessageBus().getDataProducer().processRequest((GridDataRequest)request2);
            return;
        }
        Iterable $this$map$iv = filtered;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void col;
            GridColumn gridColumn2 = (GridColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ColumnQueryData((GridColumn)col, col.getValue(originalRow)));
        }
        List data = (List)destination$iv$iv;
        RowQueryData rowQueryData = new RowQueryData(data, ArrayUtilRt.EMPTY_INT_ARRAY, queryText);
        DataProducer dataProducer = gridDataHookup.getMessageBus().getDataProducer();
        Intrinsics.checkNotNullExpressionValue((Object)dataProducer, (String)"getDataProducer(...)");
        DataProducer producer = dataProducer;
        producer.processRequest((GridDataRequest)new MyTestRowCountRequest(this, gridDataHookup, rowQueryData, (DasDataSource)dbDataSource2, column2, project, table, this.errorText, null, operation, 256, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GridColumn> getWhereClauseColumns(@NotNull GridColumn columnToExclude, @NotNull Dbms dbms, @Nullable DasObject table, @NotNull List<? extends GridColumn> columns) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)columnToExclude, (String)"columnToExclude");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        List<? extends GridColumn> list = DbImplUtil.getWhereClauseColumns(table, columns, dbms);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getWhereClauseColumns(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GridColumn col = (GridColumn)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)col, (Object)columnToExclude) && (table != null || !GridUtilCore.isRowId((GridColumn)columnToExclude)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\"\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J?\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0010\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0!2\u0006\u0010#\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\u001b2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'J\u001e\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/intellij/database/run/actions/GridCellValueLoader$MyAbstractGridDataRequest;", "Lcom/intellij/database/datagrid/DataRequest$ConditionQueryRequest;", "myGridCellValueLoader", "Lcom/intellij/database/run/actions/GridCellValueLoader;", "myHookUp", "Lcom/intellij/database/datagrid/DataBusGridDataHookUp;", "rowQueryData", "Lcom/intellij/database/datagrid/mutating/RowQueryData;", "mySystem", "Lcom/intellij/database/model/DasDataSource;", "myProject", "Lcom/intellij/openapi/project/Project;", "table", "Lcom/intellij/database/model/DasObject;", "limit", "", "<init>", "(Lcom/intellij/database/run/actions/GridCellValueLoader;Lcom/intellij/database/datagrid/DataBusGridDataHookUp;Lcom/intellij/database/datagrid/mutating/RowQueryData;Lcom/intellij/database/model/DasDataSource;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/DasObject;I)V", "getMyGridCellValueLoader", "()Lcom/intellij/database/run/actions/GridCellValueLoader;", "getMyHookUp", "()Lcom/intellij/database/datagrid/DataBusGridDataHookUp;", "getMySystem", "()Lcom/intellij/database/model/DasDataSource;", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "setColumns", "", "context", "Lcom/intellij/database/datagrid/GridDataRequest$Context;", "subQueryIndex", "resultSetIndex", "columns", "", "Lcom/intellij/database/datagrid/GridColumn;", "firstRowNum", "(Lcom/intellij/database/datagrid/GridDataRequest$Context;II[Lcom/intellij/database/datagrid/GridColumn;I)V", "checkRowCount", "rows", "", "Lcom/intellij/database/datagrid/GridRow;", "errorNotification", "system", "project", "size", "intellij.database.impl"})
    private static abstract class MyAbstractGridDataRequest
    extends DataRequest.ConditionQueryRequest {
        @NotNull
        private final GridCellValueLoader myGridCellValueLoader;
        @NotNull
        private final DataBusGridDataHookUp myHookUp;
        @NotNull
        private final DasDataSource mySystem;
        @NotNull
        private final Project myProject;

        public MyAbstractGridDataRequest(@NotNull GridCellValueLoader myGridCellValueLoader, @NotNull DataBusGridDataHookUp myHookUp, @NotNull RowQueryData rowQueryData, @NotNull DasDataSource mySystem, @NotNull Project myProject, @Nullable DasObject table, int limit) {
            Intrinsics.checkNotNullParameter((Object)myGridCellValueLoader, (String)"myGridCellValueLoader");
            Intrinsics.checkNotNullParameter((Object)myHookUp, (String)"myHookUp");
            Intrinsics.checkNotNullParameter((Object)rowQueryData, (String)"rowQueryData");
            Intrinsics.checkNotNullParameter((Object)mySystem, (String)"mySystem");
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            super((DataRequest.OwnerEx)myHookUp, rowQueryData, DataRequest.ConditionQueryRequest.newConstraints((int)0, (int)limit, (int)0, (int)myHookUp.getSubQueryIndex(), (int)myHookUp.getResultSetIndex()), table);
            this.myGridCellValueLoader = myGridCellValueLoader;
            this.myHookUp = myHookUp;
            this.mySystem = mySystem;
            this.myProject = myProject;
        }

        @NotNull
        public final GridCellValueLoader getMyGridCellValueLoader() {
            return this.myGridCellValueLoader;
        }

        @NotNull
        public final DataBusGridDataHookUp getMyHookUp() {
            return this.myHookUp;
        }

        @NotNull
        public final DasDataSource getMySystem() {
            return this.mySystem;
        }

        @NotNull
        public final Project getMyProject() {
            return this.myProject;
        }

        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, @NotNull GridColumn[] columns, int firstRowNum) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
            DataRequest.Context context2 = context instanceof DataRequest.Context ? (DataRequest.Context)context : null;
            if (context2 == null) {
                return;
            }
            DataRequest.Context c2 = context2;
            this.myHookUp.setCurrentTx(c2.txMarker);
        }

        public final void checkRowCount(@NotNull List<? extends GridRow> rows) {
            Intrinsics.checkNotNullParameter(rows, (String)"rows");
            if (rows.size() != 1) {
                this.errorNotification(this.mySystem, this.myProject, rows.size());
            }
        }

        public final void errorNotification(@NotNull DasDataSource system, @NotNull Project project, int size) {
            Intrinsics.checkNotNullParameter((Object)system, (String)"system");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String text = this.myGridCellValueLoader.getErrorText(size);
            DbUIUtil.createNotification(system, text, NotificationType.ERROR, "SaveLobAsAction.error").notify(project);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u001eH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R#\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/run/actions/GridCellValueLoader$MyCellValueRequest;", "Lcom/intellij/database/run/actions/GridCellValueLoader$MyAbstractGridDataRequest;", "gridCellValueLoader", "Lcom/intellij/database/run/actions/GridCellValueLoader;", "myHookup", "Lcom/intellij/database/datagrid/DataBusGridDataHookUp;", "system", "Lcom/intellij/database/model/DasDataSource;", "rowQueryData", "Lcom/intellij/database/datagrid/mutating/RowQueryData;", "myColumn", "Lcom/intellij/database/datagrid/GridColumn;", "project", "Lcom/intellij/openapi/project/Project;", "table", "Lcom/intellij/database/model/DasObject;", "myOperation", "Lkotlin/Function2;", "Lcom/intellij/database/datagrid/GridRow;", "", "<init>", "(Lcom/intellij/database/run/actions/GridCellValueLoader;Lcom/intellij/database/datagrid/DataBusGridDataHookUp;Lcom/intellij/database/model/DasDataSource;Lcom/intellij/database/datagrid/mutating/RowQueryData;Lcom/intellij/database/datagrid/GridColumn;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/DasObject;Lkotlin/jvm/functions/Function2;)V", "getMyColumn", "()Lcom/intellij/database/datagrid/GridColumn;", "getMyOperation", "()Lkotlin/jvm/functions/Function2;", "addRows", "context", "Lcom/intellij/database/datagrid/GridDataRequest$Context;", "rows", "", "intellij.database.impl"})
    private static final class MyCellValueRequest
    extends MyAbstractGridDataRequest {
        @NotNull
        private final GridColumn myColumn;
        @NotNull
        private final Function2<GridRow, GridColumn, Unit> myOperation;

        public MyCellValueRequest(@NotNull GridCellValueLoader gridCellValueLoader, @NotNull DataBusGridDataHookUp myHookup, @NotNull DasDataSource system, @NotNull RowQueryData rowQueryData, @NotNull GridColumn myColumn, @NotNull Project project, @Nullable DasObject table, @NotNull Function2<? super GridRow, ? super GridColumn, Unit> myOperation) {
            Intrinsics.checkNotNullParameter((Object)gridCellValueLoader, (String)"gridCellValueLoader");
            Intrinsics.checkNotNullParameter((Object)myHookup, (String)"myHookup");
            Intrinsics.checkNotNullParameter((Object)system, (String)"system");
            Intrinsics.checkNotNullParameter((Object)rowQueryData, (String)"rowQueryData");
            Intrinsics.checkNotNullParameter((Object)myColumn, (String)"myColumn");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(myOperation, (String)"myOperation");
            super(gridCellValueLoader, myHookup, rowQueryData, system, project, table, 1);
            this.myColumn = myColumn;
            this.myOperation = myOperation;
        }

        @NotNull
        public final GridColumn getMyColumn() {
            return this.myColumn;
        }

        @NotNull
        public final Function2<GridRow, GridColumn, Unit> getMyOperation() {
            return this.myOperation;
        }

        public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(rows, (String)"rows");
            this.checkRowCount(rows);
            if (rows.size() != 1) {
                return;
            }
            GridRow gridRow = (GridRow)CollectionsKt.first(rows);
            if (gridRow == null) {
                return;
            }
            GridRow row = gridRow;
            this.myOperation.invoke((Object)row, (Object)this.myColumn);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J=\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u001d2\u0006\u0010\u001e\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"H\u0016J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u001aH\u0016J\u001e\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/database/run/actions/GridCellValueLoader$MyGetCellValueWithoutFilterRequest;", "Lcom/intellij/database/datagrid/DataRequest$RawQueryRequest;", "gridCellValueLoader", "Lcom/intellij/database/run/actions/GridCellValueLoader;", "hookup", "Lcom/intellij/database/datagrid/DatabaseGridDataHookUp;", "constraints", "Lcom/intellij/database/datagrid/DataRequest$Constraints;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "myColumn", "Lcom/intellij/database/datagrid/GridColumn;", "myOperation", "Lkotlin/Function2;", "Lcom/intellij/database/datagrid/GridRow;", "", "<init>", "(Lcom/intellij/database/run/actions/GridCellValueLoader;Lcom/intellij/database/datagrid/DatabaseGridDataHookUp;Lcom/intellij/database/datagrid/DataRequest$Constraints;Lcom/intellij/database/psi/DbDataSource;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/datagrid/GridColumn;Lkotlin/jvm/functions/Function2;)V", "hadRows", "", "setColumns", "context", "Lcom/intellij/database/datagrid/GridDataRequest$Context;", "subQueryIndex", "", "resultSetIndex", "columns", "", "firstRowNum", "(Lcom/intellij/database/datagrid/GridDataRequest$Context;II[Lcom/intellij/database/datagrid/GridColumn;I)V", "addRows", "rows", "", "afterLastRowAdded", "total", "errorNotification", "system", "Lcom/intellij/database/model/DasDataSource;", "size", "intellij.database.impl"})
    private static final class MyGetCellValueWithoutFilterRequest
    extends DataRequest.RawQueryRequest {
        @NotNull
        private final GridCellValueLoader gridCellValueLoader;
        @NotNull
        private final DatabaseGridDataHookUp hookup;
        @NotNull
        private final DbDataSource dbDataSource;
        @NotNull
        private final Project project;
        @NotNull
        private final GridColumn myColumn;
        @NotNull
        private final Function2<GridRow, GridColumn, Unit> myOperation;
        private boolean hadRows;

        public MyGetCellValueWithoutFilterRequest(@NotNull GridCellValueLoader gridCellValueLoader, @NotNull DatabaseGridDataHookUp hookup, @NotNull DataRequest.Constraints constraints, @NotNull DbDataSource dbDataSource, @NotNull Project project, @NotNull GridColumn myColumn, @NotNull Function2<? super GridRow, ? super GridColumn, Unit> myOperation) {
            Intrinsics.checkNotNullParameter((Object)gridCellValueLoader, (String)"gridCellValueLoader");
            Intrinsics.checkNotNullParameter((Object)hookup, (String)"hookup");
            Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
            Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)myColumn, (String)"myColumn");
            Intrinsics.checkNotNullParameter(myOperation, (String)"myOperation");
            super((DataRequest.Owner)hookup, hookup.getQueryText(), constraints);
            this.gridCellValueLoader = gridCellValueLoader;
            this.hookup = hookup;
            this.dbDataSource = dbDataSource;
            this.project = project;
            this.myColumn = myColumn;
            this.myOperation = myOperation;
        }

        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, @NotNull GridColumn[] columns, int firstRowNum) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
            this.hookup.setCurrentTx(((DataRequest.Context)context).txMarker);
        }

        public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(rows, (String)"rows");
            this.hadRows = true;
            if (rows.isEmpty()) {
                this.errorNotification((DasDataSource)this.dbDataSource, this.project, 0);
            }
            if (rows.size() != 1) {
                return;
            }
            GridRow row = (GridRow)CollectionsKt.first(rows);
            this.myOperation.invoke((Object)row, (Object)this.myColumn);
        }

        public void afterLastRowAdded(@NotNull GridDataRequest.Context context, int total) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!this.hadRows) {
                this.errorNotification((DasDataSource)this.dbDataSource, this.project, 0);
            }
        }

        public final void errorNotification(@NotNull DasDataSource system, @NotNull Project project, int size) {
            Intrinsics.checkNotNullParameter((Object)system, (String)"system");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String text = this.gridCellValueLoader.getErrorText(size);
            DbUIUtil.createNotification(system, text, NotificationType.ERROR, "SaveLobAsAction.error").notify(project);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J \u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140*H\u0016J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R#\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006."}, d2={"Lcom/intellij/database/run/actions/GridCellValueLoader$MyTestRowCountRequest;", "Lcom/intellij/database/run/actions/GridCellValueLoader$MyAbstractGridDataRequest;", "gridCellValueLoader", "Lcom/intellij/database/run/actions/GridCellValueLoader;", "dataGridHookup", "Lcom/intellij/database/datagrid/DataBusGridDataHookUp;", "rowQueryData", "Lcom/intellij/database/datagrid/mutating/RowQueryData;", "system", "Lcom/intellij/database/model/DasDataSource;", "myColumn", "Lcom/intellij/database/datagrid/GridColumn;", "project", "Lcom/intellij/openapi/project/Project;", "table", "Lcom/intellij/database/model/DasObject;", "errorText", "", "myRows", "", "Lcom/intellij/database/datagrid/GridRow;", "myOperation", "Lkotlin/Function2;", "", "<init>", "(Lcom/intellij/database/run/actions/GridCellValueLoader;Lcom/intellij/database/datagrid/DataBusGridDataHookUp;Lcom/intellij/database/datagrid/mutating/RowQueryData;Lcom/intellij/database/model/DasDataSource;Lcom/intellij/database/datagrid/GridColumn;Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/DasObject;Ljava/lang/String;Ljava/util/List;Lkotlin/jvm/functions/Function2;)V", "getSystem", "()Lcom/intellij/database/model/DasDataSource;", "getMyColumn", "()Lcom/intellij/database/datagrid/GridColumn;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getErrorText", "()Ljava/lang/String;", "getMyRows", "()Ljava/util/List;", "getMyOperation", "()Lkotlin/jvm/functions/Function2;", "addRows", "context", "Lcom/intellij/database/datagrid/GridDataRequest$Context;", "rows", "", "afterLastRowAdded", "total", "", "intellij.database.impl"})
    private static final class MyTestRowCountRequest
    extends MyAbstractGridDataRequest {
        @NotNull
        private final DasDataSource system;
        @NotNull
        private final GridColumn myColumn;
        @NotNull
        private final Project project;
        @NotNull
        private final String errorText;
        @NotNull
        private final List<GridRow> myRows;
        @NotNull
        private final Function2<GridRow, GridColumn, Unit> myOperation;

        public MyTestRowCountRequest(@NotNull GridCellValueLoader gridCellValueLoader, @NotNull DataBusGridDataHookUp dataGridHookup, @NotNull RowQueryData rowQueryData, @NotNull DasDataSource system, @NotNull GridColumn myColumn, @NotNull Project project, @Nullable DasObject table, @NlsSafe @NotNull String errorText, @NotNull List<GridRow> myRows, @NotNull Function2<? super GridRow, ? super GridColumn, Unit> myOperation) {
            Intrinsics.checkNotNullParameter((Object)gridCellValueLoader, (String)"gridCellValueLoader");
            Intrinsics.checkNotNullParameter((Object)dataGridHookup, (String)"dataGridHookup");
            Intrinsics.checkNotNullParameter((Object)rowQueryData, (String)"rowQueryData");
            Intrinsics.checkNotNullParameter((Object)system, (String)"system");
            Intrinsics.checkNotNullParameter((Object)myColumn, (String)"myColumn");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
            Intrinsics.checkNotNullParameter(myRows, (String)"myRows");
            Intrinsics.checkNotNullParameter(myOperation, (String)"myOperation");
            super(gridCellValueLoader, dataGridHookup, rowQueryData, system, project, table, 2);
            this.system = system;
            this.myColumn = myColumn;
            this.project = project;
            this.errorText = errorText;
            this.myRows = myRows;
            this.myOperation = myOperation;
        }

        public /* synthetic */ MyTestRowCountRequest(GridCellValueLoader gridCellValueLoader, DataBusGridDataHookUp dataBusGridDataHookUp, RowQueryData rowQueryData, DasDataSource dasDataSource, GridColumn gridColumn, Project project, DasObject dasObject, String string, List list, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x100) != 0) {
                list = new ArrayList();
            }
            this(gridCellValueLoader, dataBusGridDataHookUp, rowQueryData, dasDataSource, gridColumn, project, dasObject, string, list, (Function2<? super GridRow, ? super GridColumn, Unit>)function2);
        }

        @NotNull
        public final DasDataSource getSystem() {
            return this.system;
        }

        @NotNull
        public final GridColumn getMyColumn() {
            return this.myColumn;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getErrorText() {
            return this.errorText;
        }

        @NotNull
        public final List<GridRow> getMyRows() {
            return this.myRows;
        }

        @NotNull
        public final Function2<GridRow, GridColumn, Unit> getMyOperation() {
            return this.myOperation;
        }

        public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(rows, (String)"rows");
            this.myRows.addAll(CollectionsKt.filterNotNull((Iterable)rows));
        }

        public void afterLastRowAdded(@NotNull GridDataRequest.Context context, int total) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (this.myRows.size() != 1) {
                Object[] objectArray = new Object[]{this.myRows.size()};
                String text = this.errorText + ": " + DataGridBundle.message((String)"action.Console.TableResult.SaveLobAsAction.AmbiguousQueryResult.text", (Object[])objectArray);
                DbUIUtil.createNotification(this.system, text, NotificationType.ERROR, "SaveLobAsAction.error").notify(this.project);
                return;
            }
            GridCellValueLoader gridCellValueLoader = this.getMyGridCellValueLoader();
            DataBusGridDataHookUp dataBusGridDataHookUp = this.getMyHookUp();
            DasDataSource dasDataSource = this.getMySystem();
            RowQueryData rowQueryData = this.rowQueryData;
            Intrinsics.checkNotNullExpressionValue((Object)rowQueryData, (String)"rowQueryData");
            MyCellValueRequest request2 = new MyCellValueRequest(gridCellValueLoader, dataBusGridDataHookUp, dasDataSource, rowQueryData, this.myColumn, this.getMyProject(), this.table, this.myOperation);
            this.getMyHookUp().getMessageBus().getDataProducer().processRequest((GridDataRequest)request2);
        }
    }
}

