/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.introspector;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IdCache;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.SchemaPortion;
import com.intellij.database.dialects.postgres.PgAffectedObjectAnalyzer;
import com.intellij.database.dialects.postgres.introspector.PgIntroQueries;
import com.intellij.database.dialects.postgres.introspector.PgIntrospector;
import com.intellij.database.dialects.postgres.introspector.PgSchemaEffect;
import com.intellij.database.dialects.postgres.model.PgAggregate;
import com.intellij.database.dialects.postgres.model.PgCollation;
import com.intellij.database.dialects.postgres.model.PgDatabase;
import com.intellij.database.dialects.postgres.model.PgDefType;
import com.intellij.database.dialects.postgres.model.PgEventTrigger;
import com.intellij.database.dialects.postgres.model.PgForeignTable;
import com.intellij.database.dialects.postgres.model.PgIndex;
import com.intellij.database.dialects.postgres.model.PgLikeStoredTable;
import com.intellij.database.dialects.postgres.model.PgLocalTable;
import com.intellij.database.dialects.postgres.model.PgLocalTableColumn;
import com.intellij.database.dialects.postgres.model.PgMatView;
import com.intellij.database.dialects.postgres.model.PgModelHelper;
import com.intellij.database.dialects.postgres.model.PgOperator;
import com.intellij.database.dialects.postgres.model.PgOperatorClass;
import com.intellij.database.dialects.postgres.model.PgOperatorFamily;
import com.intellij.database.dialects.postgres.model.PgRole;
import com.intellij.database.dialects.postgres.model.PgRoot;
import com.intellij.database.dialects.postgres.model.PgRoutine;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgSecurityPolicy;
import com.intellij.database.dialects.postgres.model.PgSequence;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgres.model.PgTrigger;
import com.intellij.database.dialects.postgres.model.PgView;
import com.intellij.database.dialects.postgres.model.properties.PgCheckOption;
import com.intellij.database.dialects.postgres.model.properties.PgDataTypeSubCategory;
import com.intellij.database.dialects.postgres.model.properties.PgIdentityKind;
import com.intellij.database.dialects.postgres.model.properties.PgRoutineConcurrencyKind;
import com.intellij.database.dialects.postgres.model.properties.PgSecurityPolicyOperationType;
import com.intellij.database.dialects.postgresbase.introspector.IntroGuidance;
import com.intellij.database.dialects.postgresbase.introspector.IntroModeCtx;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospector;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseAggregate;
import com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject;
import com.intellij.database.dialects.postgresbase.model.PgBaseDefType;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntroQueries;
import com.intellij.database.dialects.postgresgreenplumbase.introspector.PgGPlumBaseIntrospector;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseIndex;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTrigger;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModMultiLevelObject;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.LevelFun;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.Version;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.util.common.Long2ObjectAutoMap;
import com.intellij.database.util.common.TextTable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.sql.psi.SqlCreateStatement;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 02\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0007/012345B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J \u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0004H\u0014J\u001c\u0010$\u001a\u00060%R\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0014J\u001c\u0010&\u001a\u00060'R\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003H\u0014J\u001c\u0010(\u001a\u00060)R\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u0004H\u0014JJ\u0010*\u001a(\u0012\u0006\b\u0001\u0012\u00020\u0003\u0012\u0006\b\u0001\u0012\u00020\u00040+R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010 \u001a\u00020!2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040.H\u0014R\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00066"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "helper", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "queries", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "getAffectedObjectAnalyzer", "Lcom/intellij/database/dialects/postgres/PgAffectedObjectAnalyzer;", "initConnectionRelatedState", "", "generateDbAge", "", "tx", "processRole", "role", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRole;", "r", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneRole;", "performFragmentIntrospectionPreceders", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "schema", "createDatabaseRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever;", "createNativeRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyNativeRetriever;", "createSchemaRetriever", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever;", "createLevelOneRetrieverForPortion", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseSchemasRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "portion", "Lcom/intellij/database/dialects/base/introspector/SchemaPortion;", "Factory", "Companion", "MyDatabaseRetriever", "MyNativeRetriever", "MySchemaRetriever", "MyL1Retriever", "ArgumentNameHolderWrapper", "intellij.database.dialects.postgres"})
public final class PgIntrospector
extends PgGPlumBaseIntrospector<PgRoot, PgDatabase, PgSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final PgIntroQueries QUERIES;
    @NotNull
    private static final Companion.MY_NATURE.1 MY_NATURE;

    public PgIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = MY_NATURE;
        Dbms dbms = Dbms.POSTGRES;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"POSTGRES");
        super(context, nature, dbms, modelFactory);
    }

    @Override
    @NotNull
    protected PgGPlumBaseModelHelper getHelper() {
        return PgModelHelper.INSTANCE;
    }

    @Override
    @NotNull
    protected PgIntroQueries getQueries() {
        return QUERIES;
    }

    @Override
    @NotNull
    protected PgAffectedObjectAnalyzer getAffectedObjectAnalyzer() {
        return new PgAffectedObjectAnalyzer(this.getModel(), this.log);
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        Companion.setVersionParameters(this.getServerVersion(), this.getParametersMap());
    }

    @Override
    @NotNull
    public String generateDbAge(@NotNull String tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        return "pg_catalog.age(" + tx + "::varchar::xid)";
    }

    @Override
    protected void processRole(@NotNull PgGPlumBaseRole role, @NotNull PgGPlumBaseIntroQueries.OneRole r) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        super.processRole(role, r);
        if (!(role instanceof PgRole)) {
            return;
        }
        ((PgRole)role).setReplication(r.is_replication);
        ((PgRole)role).setBypassRls(r.bypass_rls);
    }

    @Override
    protected void performFragmentIntrospectionPreceders(@NotNull DBTransaction transaction, @NotNull PgDatabase database, @NotNull PgSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (database.getLanguages().isNotEmpty()) {
            return;
        }
        MyDatabaseRetriever dbRetriever = this.createDatabaseRetriever(transaction, database);
        dbRetriever.retrieveAuxiliaryObjects();
    }

    @NotNull
    protected MyDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull PgDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected MyNativeRetriever createNativeRetriever(@NotNull DBTransaction transaction, @NotNull PgDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyNativeRetriever(transaction, database);
    }

    @NotNull
    protected MySchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull PgSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new MySchemaRetriever(transaction, schema);
    }

    @Override
    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseSchemasRetriever<? extends PgDatabase, ? extends PgSchema> createLevelOneRetrieverForPortion(@NotNull DBTransaction transaction, @NotNull SchemaPortion<? extends PgDatabase, ? extends PgSchema> portion) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(portion, (String)"portion");
        return new MyL1Retriever(transaction, portion.getDatabase(), portion.getSchemas());
    }

    static {
        Scriptum scriptum = Scriptum.of(PgIntroQueries.class);
        Intrinsics.checkNotNullExpressionValue((Object)scriptum, (String)"of(...)");
        QUERIES = new PgIntroQueries(scriptum);
        MY_NATURE = new BaseIntrospector.Nature(){
            private final boolean supportServerObjects;
            private final Set<ObjectKind> supportFragmentKinds;
            {
                this.supportServerObjects = true;
                Object[] objectArray = new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW, ObjectKind.OBJECT_TYPE, ObjectKind.SEQUENCE, ObjectKind.ROUTINE, ObjectKind.AGGREGATE, ObjectKind.COLLATION, ObjectKind.OPERATOR, ObjectKind.OPERATOR_CLASS, ObjectKind.OPERATOR_FAMILY, ObjectKind.FOREIGN_TABLE};
                this.supportFragmentKinds = SetsKt.setOf((Object[])objectArray);
            }

            public boolean getSupportServerObjects() {
                return this.supportServerObjects;
            }

            public boolean getSupportLevelByLevelIntrospection() {
                return Registry.Companion.is("database.introspection.postgres.is.enable.levels");
            }

            public boolean getSupportFragmentIntrospection() {
                return Registry.Companion.is("database.introspection.postgres.is.enable.fragment");
            }

            public Set<ObjectKind> getSupportFragmentKinds() {
                return this.supportFragmentKinds;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$ArgumentNameHolderWrapper;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$ArgumentNameHolder;", "r", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries$OneRoutineArgNames;", "<init>", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries$OneRoutineArgNames;)V", "getR", "()Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries$OneRoutineArgNames;", "argNames", "", "", "getArgNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "argModes", "getArgModes", "nArgs", "", "getNArgs", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.database.dialects.postgres"})
    public static final class ArgumentNameHolderWrapper
    implements PgBaseIntroQueries.ArgumentNameHolder {
        @NotNull
        private final PgIntroQueries.OneRoutineArgNames r;
        @Nullable
        private final String[] argNames;
        @Nullable
        private final String[] argModes;
        private final int nArgs;

        public ArgumentNameHolderWrapper(@NotNull PgIntroQueries.OneRoutineArgNames r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            this.r = r;
            this.argNames = this.r.argNames;
            this.argModes = this.r.argModes;
            this.nArgs = this.r.nArgs;
        }

        @NotNull
        public final PgIntroQueries.OneRoutineArgNames getR() {
            return this.r;
        }

        @Override
        @Nullable
        public String[] getArgNames() {
            return this.argNames;
        }

        @Override
        @Nullable
        public String[] getArgModes() {
            return this.argModes;
        }

        @Override
        public int getNArgs() {
            return this.nArgs;
        }

        @NotNull
        public final PgIntroQueries.OneRoutineArgNames component1() {
            return this.r;
        }

        @NotNull
        public final ArgumentNameHolderWrapper copy(@NotNull PgIntroQueries.OneRoutineArgNames r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return new ArgumentNameHolderWrapper(r);
        }

        public static /* synthetic */ ArgumentNameHolderWrapper copy$default(ArgumentNameHolderWrapper argumentNameHolderWrapper, PgIntroQueries.OneRoutineArgNames oneRoutineArgNames, int n, Object object) {
            if ((n & 1) != 0) {
                oneRoutineArgNames = argumentNameHolderWrapper.r;
            }
            return argumentNameHolderWrapper.copy(oneRoutineArgNames);
        }

        @NotNull
        public String toString() {
            return "ArgumentNameHolderWrapper(r=" + this.r + ")";
        }

        public int hashCode() {
            return this.r.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArgumentNameHolderWrapper)) {
                return false;
            }
            ArgumentNameHolderWrapper argumentNameHolderWrapper = (ArgumentNameHolderWrapper)other;
            return Intrinsics.areEqual((Object)this.r, (Object)argumentNameHolderWrapper.r);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000/\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000*\u0001\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u000eR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Companion;", "", "<init>", "()V", "QUERIES", "Lcom/intellij/database/dialects/postgres/introspector/PgIntroQueries;", "MY_NATURE", "com/intellij/database/dialects/postgres/introspector/PgIntrospector$Companion$MY_NATURE$1", "Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Companion$MY_NATURE$1;", "setVersionParameters", "", "version", "Lcom/intellij/database/util/Version;", "parameters", "", "", "intellij.database.dialects.postgres"})
    public static final class Companion {
        private Companion() {
        }

        public final void setVersionParameters(@NotNull Version version, @NotNull Map<String, Object> parameters) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 8, new IntRange(1, 4), parameters);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 9, new IntRange(0, 9), parameters);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 10, new IntRange(0, 0), parameters);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 11, new IntRange(0, 0), parameters);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 12, new IntRange(0, 0), parameters);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 14, new IntRange(0, 0), parameters);
            BaseIntrospectionFunctions.setMajorMinorVersionParameters(version, 15, new IntRange(0, 0), parameters);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u0014\u0010\u0018\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "isIncremental", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "supportsFragmentIntrospection", "getSupportsFragmentIntrospection", "()Z", "supportsMultilevelIntrospection", "getSupportsMultilevelIntrospection", "VERSION", "intellij.database.dialects.postgres"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @Override
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{9};
            return version.isOrGreater(nArray);
        }

        @Override
        public boolean isIncremental() {
            return true;
        }

        @Override
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new PgIntrospector(context, modelFactory);
        }

        @Override
        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Override
        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return PgBaseIntrospectorKt.canCheckOutdated(e);
        }

        public boolean getSupportsFragmentIntrospection() {
            return Registry.Companion.is("database.introspection.postgres.is.enable.fragment");
        }

        public boolean getSupportsMultilevelIntrospection() {
            return Registry.Companion.is("database.introspection.postgres.is.enable.levels");
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.postgres"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J\b\u0010\u0013\u001a\u00020\u000fH\u0014J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgDatabase;)V", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "retrieveExtensions", "", "detectDropped", "", "loadNew", "retrieveExtensionMembers", "retrieveEventTriggers", "intellij.database.dialects.postgres"})
    @SourceDebugExtension(value={"SMAP\nPgIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgIntrospector.kt\ncom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,741:1\n1#2:742\n178#3,5:743\n183#3,3:768\n519#4:748\n500#4,2:749\n503#4,15:753\n13500#5,2:751\n*S KotlinDebug\n*F\n+ 1 PgIntrospector.kt\ncom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyDatabaseRetriever\n*L\n179#1:743,5\n179#1:768,3\n180#1:748\n180#1:749,2\n180#1:753,15\n182#1:751,2\n*E\n"})
    protected final class MyDatabaseRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseDatabaseRetriever<PgDatabase> {
        public MyDatabaseRetriever(@NotNull DBTransaction tran, PgDatabase database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumBaseIntrospector)PgIntrospector.this, tran, (PgGPlumBaseDatabase)database);
        }

        @Override
        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add$default(super.steps(), 1, null, null, arg_0 -> MyDatabaseRetriever.steps$lambda$1(this, arg_0), 6, null);
        }

        @Override
        protected void retrieveExtensions(boolean detectDropped, boolean loadNew) {
            int[] nArray = new int[]{9, 1};
            boolean supported = PgIntrospector.this.getServerVersion().isOrGreater(nArray);
            super.retrieveExtensions(detectDropped && supported, loadNew && supported);
        }

        @Override
        protected void retrieveExtensionMembers() {
            int[] nArray = new int[]{9, 1};
            boolean supported = PgIntrospector.this.getServerVersion().isOrGreater(nArray);
            if (supported) {
                super.retrieveExtensionMembers();
            }
        }

        private final void retrieveEventTriggers(boolean detectDropped, boolean loadNew) {
            PgIntrospector.this.reportRetrieving("event triggers", "introspection.retrieve.event.triggers");
            this.inDatabase(arg_0 -> MyDatabaseRetriever.retrieveEventTriggers$lambda$8(PgIntrospector.this, detectDropped, this, loadNew, arg_0));
        }

        private static final Unit steps$lambda$1(MyDatabaseRetriever this$0, IntroModeCtx $this$add) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            Version version = this$0.getModel().getRoot().getServerVersion();
            if (version != null) {
                int[] nArray = new int[]{9, 3};
                bl = version.isOrGreater(nArray);
            } else {
                bl = false;
            }
            if (bl) {
                IntroGuidance $this$steps_u24lambda_u241_u24lambda_u240 = $this$add.getGuidanceForOthers();
                boolean bl2 = false;
                this$0.retrieveEventTriggers($this$steps_u24lambda_u241_u24lambda_u240.getDetectDropped(), $this$steps_u24lambda_u241_u24lambda_u240.getLoadNew());
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveEventTriggers$lambda$8$lambda$7$lambda$6$lambda$5(ModNamingIdentifyingFamily $eventTriggers, PgIntroQueries.OneEventTrigger et) {
            Object object;
            PgEventTrigger pgEventTrigger;
            PgEventTrigger $this$retrieveEventTriggers_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244;
            block3: {
                block2: {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)et, (String)"et");
                    Object e = $eventTriggers.renew(et.id, et.name);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"renew(...)");
                    Object e2 = e;
                    $this$retrieveEventTriggers_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244 = (PgEventTrigger)e2;
                    boolean bl = false;
                    $this$retrieveEventTriggers_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.setStateNumber(et.state_number);
                    pgEventTrigger = $this$retrieveEventTriggers_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244;
                    object = et.tags;
                    if (et.tags == null) break block2;
                    String[] stringArray = object;
                    PgEventTrigger pgEventTrigger2 = pgEventTrigger;
                    boolean bl2 = false;
                    Set set = SetsKt.setOf((Object[])Arrays.copyOf(it, ((void)it).length));
                    pgEventTrigger = pgEventTrigger2;
                    object = set;
                    if (set != null) break block3;
                }
                object = SetsKt.emptySet();
            }
            pgEventTrigger.setTags((Set<String>)object);
            $this$retrieveEventTriggers_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.setEvent(et.event);
            $this$retrieveEventTriggers_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.setCallRoutineRef(BasicIdReference.create(et.routine_id));
            $this$retrieveEventTriggers_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.setDisabled(et.is_disabled);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveEventTriggers$lambda$8(PgIntrospector this$0, boolean $detectDropped, MyDatabaseRetriever this$1, boolean $loadNew, PgDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = db.getEventTriggers();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily eventTriggers = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = this$0;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                if ($detectDropped) {
                    long[] $this$forEach$iv = this$1.performQuery(this$0.getQueries().getRetrieveExistentEventTriggers());
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it = element$iv = $this$forEach$iv[j];
                        boolean bl3 = false;
                        PgEventTrigger pgEventTrigger = (PgEventTrigger)eventTriggers.getByObjectId(it);
                        if (pgEventTrigger != null) {
                            ((BasicModMixinElement)pgEventTrigger).resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$1, QUERIES.getRetrieveEventTriggers(), 0, arg_0 -> MyDatabaseRetriever.retrieveEventTriggers$lambda$8$lambda$7$lambda$6$lambda$5(eventTriggers, arg_0), 2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002$\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001R\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004B%\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0019H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u0019H\u0002J\b\u0010&\u001a\u00020\u0019H\u0002J\b\u0010'\u001a\u00020\u0019H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyL1Retriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseSchemasRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "schemasToIntrospect", "", "<init>", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgDatabase;Ljava/util/List;)V", "introspectionLocalTimestamp", "Ljava/time/Instant;", "majorEffects", "Lcom/intellij/database/util/common/Long2ObjectAutoMap;", "Lcom/intellij/database/dialects/postgres/introspector/PgSchemaEffect;", "affectedMajors", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/intellij/database/model/basic/BasicMultiLevelObject;", "schemasIdx", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "process", "", "processInner", "detectAndRemoveDroppedObjects", "checkForTableToViewConversion", "schema", "existentViews", "Lit/unimi/dsi/fastutil/longs/LongSet;", "retrieveMajorNames", "errorSchemaNotExists", "", "schemaId", "", "retrieveMinorNames", "finalizeLevel1", "traceEffects", "intellij.database.dialects.postgres"})
    @SourceDebugExtension(value={"SMAP\nPgIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgIntrospector.kt\ncom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyL1Retriever\n+ 2 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,741:1\n411#2,2:742\n411#2,2:792\n774#3:744\n865#3,2:745\n1563#3:747\n1634#3,3:748\n1491#3:755\n1516#3,3:756\n1519#3,3:766\n1252#3,2:771\n1504#3:773\n1534#3,3:774\n1537#3,3:784\n1255#3:787\n1869#3,2:788\n1869#3,2:790\n37#4:751\n36#4,3:752\n382#5,7:759\n463#5:769\n413#5:770\n382#5,7:777\n1#6:794\n*S KotlinDebug\n*F\n+ 1 PgIntrospector.kt\ncom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyL1Retriever\n*L\n523#1:742,2\n706#1:792,2\n551#1:744\n551#1:745,2\n556#1:747\n556#1:748,3\n558#1:755\n558#1:756,3\n558#1:766,3\n558#1:771,2\n559#1:773\n559#1:774,3\n559#1:784,3\n558#1:787\n658#1:788,2\n682#1:790,2\n556#1:751\n556#1:752,3\n558#1:759,7\n558#1:769\n558#1:770\n559#1:777,7\n*E\n"})
    private final class MyL1Retriever
    extends BaseNativeIntrospector.AbstractDatabaseSchemasRetriever<PgDatabase, PgSchema> {
        @NotNull
        private final Instant introspectionLocalTimestamp;
        @NotNull
        private final Long2ObjectAutoMap<PgSchemaEffect> majorEffects;
        @NotNull
        private final Long2ObjectOpenHashMap<BasicMultiLevelObject> affectedMajors;
        @NotNull
        private final Long2ObjectOpenHashMap<PgSchema> schemasIdx;
        @NotNull
        private final IntrospectionMode mode;

        public MyL1Retriever(@NotNull DBTransaction tran, @NotNull PgDatabase database, List<? extends PgSchema> schemasToIntrospect2) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter(schemasToIntrospect2, (String)"schemasToIntrospect");
            super((BaseNativeIntrospector)PgIntrospector.this, tran, (BasicModDatabase)database, schemasToIntrospect2);
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            this.introspectionLocalTimestamp = instant;
            this.majorEffects = new Long2ObjectAutoMap(MyL1Retriever::majorEffects$lambda$0);
            this.affectedMajors = new Long2ObjectOpenHashMap();
            this.schemasIdx = new Long2ObjectOpenHashMap();
            long[] schemaIds = new long[this.getSchemas().size()];
            long commonL1Xid = 0L;
            commonL1Xid = Long.MAX_VALUE;
            boolean schemasAreEmpty = false;
            schemasAreEmpty = true;
            boolean allSchemasNotIntrospected = false;
            allSchemasNotIntrospected = true;
            Iterator iterator = ((Iterable)this.getSchemas()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i2 = n++;
                PgSchema schema = (PgSchema)iterator.next();
                ((Map)this.schemasIdx).put(schema.getObjectId(), schema);
                schemaIds[i2] = schema.getObjectId();
                commonL1Xid = Math.min(commonL1Xid, schema.getLastIntrospectionL1Xid());
                schemasAreEmpty = schemasAreEmpty && !ModelFun.isNotEmpty(schema);
                allSchemasNotIntrospected = allSchemasNotIntrospected && (schema.getLastIntrospectionLevel() == null || !ModelFun.isNotEmpty(schema));
            }
            boolean toInc = !schemasAreEmpty && !allSchemasNotIntrospected;
            this.mode = toInc ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL;
            this.setQueryParameter("schema_ids", schemaIds);
            PgIntrospector.this.setTx(this, commonL1Xid, "tx", "TXAGE");
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                IntrospectionQueryContext introspectionQueryContext = this_$iv;
                boolean bl = false;
                introspectionQueryContext.trace("L1 Retriever initializing\nCommon L1 Xid = " + commonL1Xid + "\nSchemas are empty = " + schemasAreEmpty + "\nAll schemas are not introspected = " + allSchemasNotIntrospected + "\nMode = " + this.mode);
            }
        }

        @Override
        public void process() {
            int schemasCnt = this.getSchemas().size();
            CharSequence charSequence = "Introspecting database (" + this.getDatabase() + ") at level 1: " + schemasCnt + " schemas completely";
            Object[] objectArray = new Object[]{schemasCnt};
            String string = DatabaseBundle.message("introspection.report.database.regular.full", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            PgIntrospector.this.doSectionWithStatus("Introspect.Database.L1.Full", charSequence, true, string, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    MyL1Retriever.access$processInner((MyL1Retriever)this.receiver);
                }
            }));
        }

        private final void processInner() {
            this.detectAndRemoveDroppedObjects();
            this.retrieveMajorNames();
            this.retrieveMinorNames();
            this.finalizeLevel1();
        }

        /*
         * WARNING - void declaration
         */
        private final void detectAndRemoveDroppedObjects() {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object value$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getSchemas();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PgSchema it = (PgSchema)element$iv$iv;
                boolean bl = false;
                if (!ModelFun.isNotEmpty(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List actualSchemas = (List)destination$iv$iv;
            PgIntrospector.this.reportStatusDetails("Determining dropped objects in the schemas: " + CollectionsKt.joinToString$default((Iterable)actualSchemas, null, null, null, (int)0, null, null, (int)63, null), "introspection.retrieve.droppedObjects");
            Iterable $this$map$iv = actualSchemas;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PgSchema bl = (PgSchema)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(it.getObjectId());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Long[] actualSchemaIds = thisCollection$iv.toArray(new Long[0]);
            List<PgIntroQueries.OneObjDescriptor> existentObjects = this.performQuery(PgIntrospector.this.getQueries().getListAllExistentObjects(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"schema_ids", (Object)actualSchemaIds)), new Object[0]);
            Object $this$groupBy$iv = existentObjects;
            boolean $i$f$groupBy = false;
            Iterable $i$f$mapTo22 = $this$groupBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                PgIntroQueries.OneObjDescriptor it = (PgIntroQueries.OneObjDescriptor)element$iv$iv;
                boolean bl = false;
                key$iv$iv = it.schemaId;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv3;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$groupByTo$iv$iv2;
                void it;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv3;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = map;
                boolean bl4 = false;
                Iterable $this$groupBy$iv2 = (Iterable)it.getValue();
                boolean $i$f$groupBy2 = false;
                Iterable iterable2 = $this$groupBy$iv2;
                Map destination$iv$iv4 = new LinkedHashMap();
                boolean $i$f$groupByTo2 = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                    void it2;
                    Object object3;
                    PgIntroQueries.OneObjDescriptor it3 = (PgIntroQueries.OneObjDescriptor)element$iv$iv;
                    boolean $i$a$-groupBy-PgIntrospector$MyL1Retriever$detectAndRemoveDroppedObjects$g$2$32 = false;
                    Character key$iv$iv2 = Character.valueOf(it3.kind);
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                    if (value$iv$iv$iv2 == null) {
                        boolean bl5 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                        object3 = answer$iv$iv$iv;
                    } else {
                        object3 = value$iv$iv$iv2;
                    }
                    List list$iv$iv = (List)object3;
                    PgIntroQueries.OneObjDescriptor $i$a$-groupBy-PgIntrospector$MyL1Retriever$detectAndRemoveDroppedObjects$g$2$32 = (PgIntroQueries.OneObjDescriptor)element$iv$iv;
                    List list = list$iv$iv;
                    boolean bl6 = false;
                    list.add(it2.oid);
                }
                Map map2 = destination$iv$iv4;
                object.put(k, map2);
            }
            Map g = destination$iv$iv3;
            for (PgSchema schema : actualSchemas) {
                Map schemaObjects = (Map)g.get(schema.getObjectId());
                LongSet existentViews = MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'v');
                this.checkForTableToViewConversion(schema, existentViews);
                ModNamingIdentifyingFamily<? extends PgLocalTable> modNamingIdentifyingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'r'));
                ModNamingIdentifyingFamily<? extends PgView> modNamingIdentifyingFamily2 = schema.getViews();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getViews(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily2, existentViews);
                ModNamingIdentifyingFamily<? extends PgMatView> modNamingIdentifyingFamily3 = schema.getMatViews();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getMatViews(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily3, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'm'));
                ModNamingIdentifyingFamily<? extends PgForeignTable> modNamingIdentifyingFamily4 = schema.getForeignTables();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getForeignTables(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily4, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'f'));
                ModNamingIdentifyingFamily<? extends PgSequence> modNamingIdentifyingFamily5 = schema.getSequences();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getSequences(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily5, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'S'));
                ModNamingIdentifyingFamily<? extends PgDefType> modNamingIdentifyingFamily6 = schema.getDefTypes();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getDefTypes(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily6, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'T'));
                ModNamingIdentifyingFamily<? extends PgCollation> modNamingIdentifyingFamily7 = schema.getCollations();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getCollations(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily7, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'C'));
                ModNamingIdentifyingFamily<? extends PgOperator> modNamingIdentifyingFamily8 = schema.getOperators();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"getOperators(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily8, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'O'));
                ModNamingIdentifyingFamily<? extends PgOperatorClass> modNamingIdentifyingFamily9 = schema.getOperatorClasses();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily9, (String)"getOperatorClasses(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily9, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'c'));
                ModNamingIdentifyingFamily<? extends PgOperatorFamily> modNamingIdentifyingFamily10 = schema.getOperatorFamilies();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily10, (String)"getOperatorFamilies(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily10, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'F'));
                ModNamingIdentifyingFamily<? extends PgAggregate> modNamingIdentifyingFamily11 = schema.getAggregates();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily11, (String)"getAggregates(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily11, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'a'));
                ModNamingIdentifyingFamily<? extends PgRoutine> modNamingIdentifyingFamily12 = schema.getRoutines();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily12, (String)"getRoutines(...)");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)modNamingIdentifyingFamily12, MyL1Retriever.detectAndRemoveDroppedObjects$existentFor(schemaObjects, 'R'));
            }
        }

        private final void checkForTableToViewConversion(PgSchema schema, LongSet existentViews) {
            for (PgLocalTable pgLocalTable : schema.getTables()) {
                PgView newView;
                if (!existentViews.contains(pgLocalTable.getObjectId())) continue;
                Intrinsics.checkNotNullExpressionValue((Object)schema.getViews().renew(pgLocalTable.getObjectId(), pgLocalTable.getName()), (String)"renew(...)");
                PgIntrospector.this.preventDuplicatedRelationForSchema(schema, newView, pgLocalTable);
            }
        }

        private final void retrieveMajorNames() {
            PgIntrospector.this.reportRetrieving("Major names", "introspection.retrieve.majorObjectNames");
            Ref.ObjectRef curSchema = new Ref.ObjectRef();
            Ref.ObjectRef curEffect = new Ref.ObjectRef();
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this, PgIntrospector.this.getQueries().getListAllMajorNames(), 0, arg_0 -> MyL1Retriever.retrieveMajorNames$lambda$8(curSchema, this, curEffect, arg_0), 2, null);
            curSchema.element = null;
            BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this, PgIntrospector.this.getQueries().getRetrieveRoutineArgNames(), 0, arg_0 -> MyL1Retriever.retrieveMajorNames$lambda$13(curSchema, this, curEffect, PgIntrospector.this, arg_0), 2, null);
        }

        private final Void errorSchemaNotExists(long schemaId) {
            throw new IllegalStateException("There's an object from schema [" + schemaId + "], but the schema was not in where clause");
        }

        private final void retrieveMinorNames() {
            Iterable $this$forEach$iv;
            PgIntrospector.this.reportRetrieving("Minor names", "introspection.retrieve.minorObjectNames");
            BasicIdentifiedElement curSchema = null;
            PgLikeStoredTable major = null;
            List columns = BaseNativeIntrospector.AbstractRetriever.performQueryForList$default(this, PgIntrospector.this.getQueries().getRetrieveColumnNames(), null, 0, 6, null);
            List touchedMajors = new ArrayList();
            Iterable iterable = columns;
            PgIntrospector pgIntrospector = PgIntrospector.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PgBaseLikeColumn oldColumn2;
                PgIntroQueries.OneColumnName c2 = (PgIntroQueries.OneColumnName)element$iv;
                boolean bl = false;
                BasicIdentifiedElement basicIdentifiedElement = curSchema;
                if (!(basicIdentifiedElement != null ? c2.schemaId == basicIdentifiedElement.getObjectId() : false) && (PgSchema)this.schemasIdx.get(c2.schemaId) == null) {
                    this.errorSchemaNotExists(c2.schemaId);
                    throw new KotlinNothingValueException();
                }
                basicIdentifiedElement = major;
                if (!(basicIdentifiedElement != null ? c2.majorOid == basicIdentifiedElement.getObjectId() : false)) {
                    PgLikeStoredTable pgLikeStoredTable = major = (switch (c2.kind) {
                        case 'r' -> (PgLikeStoredTable)curSchema.getTables().getByObjectId(c2.majorOid);
                        case 'v' -> (PgLikeStoredTable)curSchema.getViews().getByObjectId(c2.majorOid);
                        case 'm' -> (PgLikeStoredTable)curSchema.getMatViews().getByObjectId(c2.majorOid);
                        case 'f' -> (PgLikeStoredTable)curSchema.getForeignTables().getByObjectId(c2.majorOid);
                        default -> throw new IllegalStateException("Unexpected object kind '" + c2.kind + "' found - expected 'r' (table), 'v' (view), 'm' (materialized view), or 'f' (foreign table)");
                    });
                    Intrinsics.checkNotNull((Object)pgLikeStoredTable);
                    pgLikeStoredTable.getColumns().markChildrenAsSyncPending();
                    touchedMajors.add(major);
                }
                if ((oldColumn2 = (PgBaseLikeColumn)((PgBaseLikeTable)major).getColumns().find(arg_0 -> MyL1Retriever.retrieveMinorNames$lambda$15$lambda$14(new Function1(c2){
                    final /* synthetic */ PgIntroQueries.OneColumnName $c;
                    {
                        this.$c = $c;
                    }

                    public final Boolean invoke(PgBaseLikeColumn it) {
                        return ((BasicModTableOrViewColumn)it).getPosition() == this.$c.position;
                    }
                }, arg_0))) != null && !Intrinsics.areEqual((Object)oldColumn2.getName(), (Object)c2.name)) {
                    Map map = (Map)pgIntrospector.getRenameHandlingRequests().get(((PgBaseLikeTable)major).getObjectId());
                    Long l = c2.position;
                    String string = oldColumn2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    PgBaseIntrospector.RenameInfo renameInfo = new PgBaseIntrospector.RenameInfo(string, c2.name);
                    map.put(l, renameInfo);
                }
                ((PgBaseLikeTable)major).getColumns().renewAt(c2.position, c2.name);
            }
            $this$forEach$iv = touchedMajors;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                PgBaseLikeTable it = (PgBaseLikeTable)element$iv;
                boolean bl = false;
                it.getColumns().removeSyncPendingChildren();
                it.getColumns().sort();
            }
        }

        private final void finalizeLevel1() {
            PgIntrospector.this.reportStatusMessage("Finalizing level 1", "introspection.report.status.finishingTheSchema.L1");
            for (PgSchema schema : this.getSchemas()) {
                PgSchemaEffect effect = this.majorEffects.get(schema.getObjectId());
                if (effect.getSomething()) {
                    this.getAffectedSchemas().add(schema);
                }
                schema.setLastIntrospectionLevel(Level.L1);
                Long l = PgIntrospector.this.getIntrospectionXid();
                schema.setLastIntrospectionL1Xid(l != null ? l : 0L);
                schema.setLastIntrospectionLocalTimestamp(this.introspectionLocalTimestamp);
            }
            this.traceEffects();
        }

        private final void traceEffects() {
            IntrospectionQueryContext this_$iv = this;
            boolean $i$f$trace = false;
            if (IntrospectionQueryContext.access$getTracing(this_$iv)) {
                StringBuilder stringBuilder;
                IntrospectionQueryContext introspectionQueryContext = this_$iv;
                boolean bl = false;
                TextTable.Column[] columnArray = new TextTable.Column[]{new TextTable.Column("Schema", null, traceEffects.1.tt.1.INSTANCE, 2, null), new TextTable.Column("Tables", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getTables();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Views", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getViews();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("MatViews", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getMatViews();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("ForeignTables", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getForeignTables();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Sequences", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getSequences();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("DefTypes", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getDefTypes();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Collations", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getCollations();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Operators", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getOperators();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("OperatorClasses", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getOperatorClasses();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("OperatorFamilies", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getOperatorFamilies();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Aggregates", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getAggregates();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null), new TextTable.Column("Routines", null, (Function1)new Function1<PgSchema, CharSequence>(this){
                    final /* synthetic */ MyL1Retriever this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final CharSequence invoke(PgSchema it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        PgSchemaEffect pgSchemaEffect = (PgSchemaEffect)MyL1Retriever.access$getMajorEffects$p(this.this$0).getIfPresent(it.getObjectId());
                        if (pgSchemaEffect != null) {
                            void _true_$iv;
                            void $this$choose$iv;
                            boolean bl = pgSchemaEffect.getRoutines();
                            String string = "+";
                            String _false_$iv = "-";
                            boolean $i$f$choose = false;
                            object = $this$choose$iv != false ? _true_$iv : _false_$iv;
                        } else {
                            object = null;
                        }
                        return object;
                    }
                }, 2, null)};
                TextTable tt2 = new TextTable(columnArray);
                CharSequence text2 = tt2.processContent(this.getSchemas());
                StringBuilder $this$traceEffects_u24lambda_u2418_u24lambda_u2417 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                $this$traceEffects_u24lambda_u2418_u24lambda_u2417.append("Level 1 affected major objects:\n");
                $this$traceEffects_u24lambda_u2418_u24lambda_u2417.append(text2);
                introspectionQueryContext.trace(stringBuilder.toString());
            }
        }

        private static final PgSchemaEffect majorEffects$lambda$0(long it) {
            return new PgSchemaEffect();
        }

        private static final LongSet detectAndRemoveDroppedObjects$existentFor(Map<Character, ? extends List<Long>> schemaObjects, char kind) {
            if (schemaObjects == null) {
                LongSet longSet = LongSet.of();
                Intrinsics.checkNotNullExpressionValue((Object)longSet, (String)"of(...)");
                return longSet;
            }
            List<Long> list = schemaObjects.get(Character.valueOf(kind));
            if (list == null) {
                LongSet longSet = LongSet.of();
                Intrinsics.checkNotNullExpressionValue((Object)longSet, (String)"of(...)");
                return longSet;
            }
            List<Long> kindObjects = list;
            long[] lArray = CollectionsKt.toLongArray((Collection)kindObjects);
            LongSet longSet = LongSet.of((long[])Arrays.copyOf(lArray, lArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)longSet, (String)"of(...)");
            return longSet;
        }

        private static final Unit retrieveMajorNames$lambda$8(Ref.ObjectRef $curSchema, MyL1Retriever this$0, Ref.ObjectRef $curEffect, PgIntroQueries.OneMajorNameDescriptor majorName) {
            Intrinsics.checkNotNullParameter((Object)majorName, (String)"majorName");
            PgSchema pgSchema = (PgSchema)$curSchema.element;
            if (!(pgSchema != null ? majorName.schemaId == pgSchema.getObjectId() : false)) {
                PgSchema pgSchema2 = (PgSchema)this$0.schemasIdx.get(majorName.schemaId);
                if (pgSchema2 == null) {
                    this$0.errorSchemaNotExists(majorName.oid);
                    throw new KotlinNothingValueException();
                }
                $curSchema.element = pgSchema2;
                Long2ObjectAutoMap<PgSchemaEffect> long2ObjectAutoMap = this$0.majorEffects;
                Object object = $curSchema.element;
                Intrinsics.checkNotNull((Object)object);
                $curEffect.element = long2ObjectAutoMap.get(((PgSchema)object).getObjectId());
            }
            Object object = $curSchema.element;
            Intrinsics.checkNotNull((Object)object);
            PgSchema curSchema = (PgSchema)object;
            BasicModMultiLevelObject obj2 = switch (majorName.kind) {
                case 'r' -> curSchema.getTables().renew(majorName.oid, majorName.name);
                case 'v' -> curSchema.getViews().renew(majorName.oid, majorName.name);
                case 'm' -> curSchema.getMatViews().renew(majorName.oid, majorName.name);
                case 'f' -> curSchema.getForeignTables().renew(majorName.oid, majorName.name);
                case 'S' -> curSchema.getSequences().renew(majorName.oid, majorName.name);
                case 'T' -> curSchema.getDefTypes().renew(majorName.oid, majorName.name);
                case 'C' -> curSchema.getCollations().renew(majorName.oid, majorName.name);
                case 'O' -> curSchema.getOperators().renew(majorName.oid, majorName.name);
                case 'c' -> curSchema.getOperatorClasses().renew(majorName.oid, majorName.name);
                case 'F' -> curSchema.getOperatorFamilies().renew(majorName.oid, majorName.name);
                case 'a' -> curSchema.getAggregates().renew(majorName.oid, majorName.name);
                case 'R' -> curSchema.getRoutines().renew(majorName.oid, majorName.name);
                default -> throw new IllegalStateException("Unsupported object kind '" + majorName.kind + "' of object '" + majorName.name + "'");
            };
            if (obj2 == null) {
                return Unit.INSTANCE;
            }
            obj2.setDetailsLevel(LevelFun.max(obj2.getDetailsLevel(), Level.L1));
            Object object2 = $curEffect.element;
            Intrinsics.checkNotNull((Object)object2);
            ((PgSchemaEffect)object2).include(obj2);
            ((Map)this$0.affectedMajors).put(majorName.oid, obj2);
            return Unit.INSTANCE;
        }

        private static final DasType retrieveMajorNames$lambda$13$lambda$10$lambda$9(long it) {
            return null;
        }

        private static final DasType retrieveMajorNames$lambda$13$lambda$12$lambda$11(long it) {
            return null;
        }

        private static final Unit retrieveMajorNames$lambda$13(Ref.ObjectRef $curSchema, MyL1Retriever this$0, Ref.ObjectRef $curEffect, PgIntrospector this$1, PgIntroQueries.OneRoutineArgNames r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgBaseCatalogObject pgBaseCatalogObject = (PgSchema)$curSchema.element;
            if (!(pgBaseCatalogObject != null ? r.schemaId == pgBaseCatalogObject.getObjectId() : false)) {
                PgSchema pgSchema = (PgSchema)this$0.schemasIdx.get(r.schemaId);
                if (pgSchema == null) {
                    this$0.errorSchemaNotExists(r.schemaId);
                    throw new KotlinNothingValueException();
                }
                $curSchema.element = pgSchema;
                $curEffect.element = this$0.majorEffects.get(((PgSchema)$curSchema.element).getObjectId());
            }
            if ((pgBaseCatalogObject = (PgRoutine)((PgSchema)$curSchema.element).getRoutines().getByObjectId(r.majorOid)) != null) {
                PgBaseCatalogObject it = pgBaseCatalogObject;
                boolean bl = false;
                PgBaseIntroQueries.ArgumentNameHolder argumentNameHolder = new ArgumentNameHolderWrapper(r);
                PositioningNamingFamily positioningNamingFamily = it.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                this$1.processArgs(argumentNameHolder, (ModPositioningNamingFamily)positioningNamingFamily, (BasicModRoutine)((Object)it), (Function1<Long, DasType>)MyL1Retriever::retrieveMajorNames$lambda$13$lambda$10$lambda$9);
            } else {
                PgAggregate pgAggregate = (PgAggregate)((PgSchema)$curSchema.element).getAggregates().getByObjectId(r.majorOid);
                if (pgAggregate != null) {
                    PgAggregate it = pgAggregate;
                    boolean bl = false;
                    PgBaseIntroQueries.ArgumentNameHolder argumentNameHolder = new ArgumentNameHolderWrapper(r);
                    PositioningNamingFamily positioningNamingFamily = it.getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
                    this$1.processArgs(argumentNameHolder, (ModPositioningNamingFamily)positioningNamingFamily, it, (Function1<Long, DasType>)MyL1Retriever::retrieveMajorNames$lambda$13$lambda$12$lambda$11);
                } else {
                    throw new IllegalStateException("Failed to process routine arguments - routine or aggregate with majorOid=" + r.majorOid + " not found");
                }
            }
            return Unit.INSTANCE;
        }

        private static final boolean retrieveMinorNames$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$processInner(MyL1Retriever $this) {
            $this.processInner();
        }

        public static final /* synthetic */ Long2ObjectAutoMap access$getMajorEffects$p(MyL1Retriever $this) {
            return $this.majorEffects;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MyNativeRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseNativeRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgDatabase;)V", "getNativeDefinitionQuery", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.postgres"})
    protected final class MyNativeRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseNativeRetriever<PgDatabase> {
        public MyNativeRetriever(@NotNull DBTransaction tran, PgDatabase database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgGPlumBaseIntrospector)PgIntrospector.this, tran, (PgGPlumBaseDatabase)database);
        }

        @Override
        @Nullable
        protected String getNativeDefinitionQuery(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            String string = super.getNativeDefinitionQuery(kind);
            if (string == null) {
                string = Intrinsics.areEqual((Object)kind, (Object)ObjectKind.ROUTINE) ? "select pg_get_functiondef(?)" : null;
            }
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0006\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0019\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J#\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000fH\u0002J3\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u000fH\u0002J\b\u0010!\u001a\u00020\u0011H\u0002J\u0014\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\f0#H\u0014J\b\u0010%\u001a\u00020\u000fH\u0014J \u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011H\u0014J \u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010\b\u001a\u00020\u0002H\u0014J \u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u0002012\u0006\u0010\b\u001a\u00020\u00022\u0006\u00102\u001a\u000203H\u0014J\u0018\u00104\u001a\u00020\u000f2\u0006\u00100\u001a\u0002052\u0006\u00106\u001a\u000203H\u0014J\u0018\u00107\u001a\u00020\u000f2\u0006\u00100\u001a\u0002012\u0006\u00106\u001a\u000203H\u0014J0\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u000e\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020<0>2\u0006\u00100\u001a\u000201H\u0014J\u0010\u0010?\u001a\u00020\u00112\u0006\u0010@\u001a\u00020AH\u0014J\u0018\u0010B\u001a\u00020C2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010D\u001a\u00020EH\u0014J\u0018\u0010F\u001a\u00020\u000f2\u0006\u0010G\u001a\u00020H2\u0006\u00106\u001a\u00020IH\u0014J\u0018\u0010J\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0014J\u0018\u0010O\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0014J\u0012\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010R\u001a\u00020SH\u0014J$\u0010V\u001a\u00020\u000f2\u0012\u0010W\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020Y0\u00180X2\u0006\u0010Z\u001a\u00020[H\u0014J\u0018\u0010\\\u001a\u00020\u000f2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0014J\b\u0010a\u001a\u00020\u0011H\u0014J\u0010\u0010b\u001a\u00020\u00112\u0006\u0010c\u001a\u00020dH\u0014J \u0010e\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011H\u0002J\u0013\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010gJ\b\u0010h\u001a\u00020\u000fH\u0014J\b\u0010i\u001a\u00020\u000fH\u0014\u00a8\u0006j"}, d2={"Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector$PgGPlumBaseSchemaRetriever;", "Lcom/intellij/database/dialects/postgres/model/PgSchema;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntrospector;", "Lcom/intellij/database/dialects/postgres/model/PgRoot;", "Lcom/intellij/database/dialects/postgres/model/PgDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/postgres/introspector/PgIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/postgres/model/PgSchema;)V", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "setup", "", "majorModificationsFound", "", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "retrieveNamedFragments", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "fragmentNames", "", "", "(Lcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "retrieveDependentTables", "forFragments", "action", "Lkotlin/Function0;", "(Lcom/intellij/database/model/ObjectKind;[Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "doIntroSteps", "supportsAdvancedSequences", "getSequencesQuery", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneSequence;", "retrieveForeignTablesInfo", "retrieveCollations", "removeUnaffected", "detectDropped", "loadNew", "processDataType", "dataType", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDefType;", "oneType", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneDataType;", "processTable", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "oneTable", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "processModTable", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "t", "processModView", "processColumn", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "columns", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "hasReference", "con", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneConstraint;", "createRoutine", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "r", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneRoutine;", "processTrigger", "trigger", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneTrigger;", "processAggregate", "agg", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneAggregate;", "aggregate", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseAggregate;", "processFunSourceAttributes", "function", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRoutine;", "fs", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneFunctionSource;", "getFunSourceText", "Lcom/intellij/database/model/properties/CompositeText;", "removeComments", "existentComments", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "e", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "processIndex", "index", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseIndex;", "ind", "Lcom/intellij/database/dialects/postgresgreenplumbase/introspector/PgGPlumBaseIntroQueries$OneIndex;", "incrementalViewSources", "isTableKind", "kind", "", "retrieveSecurityPolicies", "retrieveDependentTableNames", "()[Ljava/lang/String;", "processLevel2Imp", "processLevel3Imp", "intellij.database.dialects.postgres"})
    @SourceDebugExtension(value={"SMAP\nPgIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgIntrospector.kt\ncom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 7 IntrospectorSqlHelper.kt\ncom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper\n+ 8 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/IdCache\n+ 9 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,741:1\n1#2:742\n774#3:743\n865#3,2:744\n1869#3,2:765\n1563#3:767\n1634#3,3:768\n774#3:771\n865#3,2:772\n774#3:774\n865#3,2:775\n1869#3:817\n1869#3,2:818\n1870#3:820\n11228#4:746\n11563#4,2:747\n11565#4:753\n11228#4:784\n11563#4,3:785\n37#5:749\n36#5,3:750\n139#6,2:754\n142#6,8:757\n519#6:814\n500#6,2:815\n503#6,15:821\n26#7:756\n428#8,7:777\n262#9,26:788\n289#9,7:836\n*S KotlinDebug\n*F\n+ 1 PgIntrospector.kt\ncom/intellij/database/dialects/postgres/introspector/PgIntrospector$MySchemaRetriever\n*L\n264#1:743\n264#1:744,2\n404#1:765,2\n411#1:767\n411#1:768,3\n471#1:771\n471#1:772,2\n481#1:774\n481#1:775,2\n433#1:817\n434#1:818,2\n433#1:820\n270#1:746\n270#1:747,2\n270#1:753\n448#1:784\n448#1:785,3\n270#1:749\n270#1:750,3\n368#1:754,2\n368#1:757,8\n430#1:814\n430#1:815,2\n430#1:821,15\n368#1:756\n444#1:777,7\n426#1:788,26\n426#1:836,7\n*E\n"})
    protected final class MySchemaRetriever
    extends PgGPlumBaseIntrospector.PgGPlumBaseSchemaRetriever<PgSchema> {
        public MySchemaRetriever(@NotNull DBTransaction transaction, PgSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((PgGPlumBaseIntrospector)PgIntrospector.this, transaction, (PgGPlumBaseSchema)schema);
        }

        @Override
        @NotNull
        protected List<IntroStep> steps() {
            Object[] objectArray = new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW};
            return PgBaseIntrospectorKt.add$default(super.steps(), 81, SetsKt.setOf((Object[])objectArray), null, arg_0 -> MySchemaRetriever.steps$lambda$1(PgIntrospector.this, this, arg_0), 4, null);
        }

        @Override
        public void setup(boolean majorModificationsFound, @Nullable IntrospectionMode mode) {
            this.setWithSources(this.calcWithSources());
        }

        @Override
        public void retrieveNamedFragments(@NotNull ObjectKind fragmentKind, @NotNull String[] fragmentNames) {
            Intrinsics.checkNotNullParameter((Object)fragmentKind, (String)"fragmentKind");
            Intrinsics.checkNotNullParameter((Object)fragmentNames, (String)"fragmentNames");
            this.setFragmentKind(fragmentKind);
            this.setFragmentNames(fragmentNames);
            BaseIntrospectionFunctions.setupModeParameters(this.getMode(), this.getParametersMap());
            this.getParametersMap().put("f_names", fragmentNames);
            this.doIntroSteps();
            if (Intrinsics.areEqual((Object)this.getFragmentKind(), (Object)ObjectKind.TABLE)) {
                this.retrieveDependentTables();
            }
        }

        private final void retrieveDependentTables() {
            String[] dependentTableNames = this.retrieveDependentTableNames();
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            this.forFragments(objectKind, dependentTableNames, (Function0<Unit>)((Function0)() -> MySchemaRetriever.retrieveDependentTables$lambda$2(this)));
        }

        private final void forFragments(ObjectKind fragmentKind, String[] fragmentNames, Function0<Unit> action) {
            block0: {
                ObjectKind origFragmentKind = this.getFragmentKind();
                String[] origFragmentNames = this.getFragmentNames();
                Object origFNames = this.getParametersMap().get("f_names");
                this.setFragmentKind(fragmentKind);
                this.setFragmentNames(fragmentNames);
                this.getParametersMap().put("f_names", this.getFragmentNames());
                action.invoke();
                this.setFragmentKind(origFragmentKind);
                this.setFragmentNames(origFragmentNames);
                Object object = origFNames;
                if (object == null) break block0;
                Object it = object;
                boolean bl = false;
                this.getParametersMap().put("f_names", it);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void doIntroSteps() {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.steps();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IntroStep it = (IntroStep)element$iv$iv;
                boolean bl = false;
                if (!it.getApplicableKinds().contains(this.getFragmentKind())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List applicableSteps = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            if (applicableSteps.isEmpty()) {
                IntrospectionQueryContext.logError$default(this, "Unsupported object kind (" + this.getFragmentKind() + ") for fragment intro", null, 2, null);
            }
            Object[] allFragmentNames = this.getFragmentNames();
            List<T>[] $this$map$iv = CollectionFun.splitIntoChunksOf(ArraysKt.toList((Object[])allFragmentNames), 50);
            boolean $i$f$map = false;
            List<T>[] $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var12_18 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                Collection $this$toTypedArray$iv = (Collection)it;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                collection.add(thisCollection$iv.toArray(new String[0]));
            }
            List batches = (List)destination$iv$iv2;
            for (IntroStep step : applicableSteps) {
                for (String[] batch : batches) {
                    this.getParametersMap().put("f_names", batch);
                    this.setFragmentNames(batch);
                    step.getPerform().invoke((Object)new IntroModeCtx.Frag(this.getFragmentKind()));
                }
            }
            this.getParametersMap().put("f_names", this.getFragmentNames());
            this.setFragmentNames((String[])allFragmentNames);
        }

        private final boolean supportsAdvancedSequences() {
            int[] nArray = new int[]{10, -10};
            return PgIntrospector.this.getServerVersion().isOrGreater(nArray);
        }

        @Override
        @NotNull
        protected SqlQuery<List<PgGPlumBaseIntroQueries.OneSequence>> getSequencesQuery() {
            return this.supportsAdvancedSequences() ? QUERIES.getRetrieveSequences10() : super.getSequencesQuery();
        }

        @Override
        protected void retrieveForeignTablesInfo() {
            int[] nArray = new int[]{9, 1};
            if (PgIntrospector.this.getServerVersion().isOrGreater(nArray)) {
                super.retrieveForeignTablesInfo();
            }
        }

        @Override
        protected void retrieveCollations(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            int[] nArray = new int[]{9, 1};
            boolean isSupported = PgIntrospector.this.getServerVersion().isOrGreater(nArray);
            super.retrieveCollations(removeUnaffected, detectDropped && isSupported, loadNew && isSupported);
        }

        @Override
        protected void processDataType(@NotNull PgBaseDefType dataType, @NotNull PgBaseIntroQueries.OneDataType oneType, @NotNull PgSchema schema) {
            Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
            Intrinsics.checkNotNullParameter((Object)oneType, (String)"oneType");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super.processDataType(dataType, oneType, (PgGPlumBaseSchema)schema);
            if (!(dataType instanceof PgDefType)) {
                return;
            }
            ((PgDefType)dataType).setSubCategory(PgDataTypeSubCategory.of(oneType.type_category));
        }

        @Override
        protected void processTable(@NotNull PgBaseLikeStoredTable table, @NotNull PgSchema schema, @NotNull PgBaseIntroQueries.OneTable oneTable) {
            boolean bl;
            long it;
            PgLikeStoredTable pgLikeStoredTable;
            Long l;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)oneTable, (String)"oneTable");
            super.processTable(table, (PgGPlumBaseSchema)schema, oneTable);
            if (table instanceof PgMatView) {
                BasicIdReference basicIdReference;
                l = oneTable.tablespace_id;
                long l2 = ((Number)l).longValue();
                pgLikeStoredTable = (PgMatView)table;
                boolean bl2 = false;
                bl = it != 0L;
                PgLikeStoredTable pgLikeStoredTable2 = pgLikeStoredTable;
                Long l3 = bl ? l : null;
                if (l3 != null) {
                    it = ((Number)l3).longValue();
                    pgLikeStoredTable = pgLikeStoredTable2;
                    boolean bl3 = false;
                    basicIdReference = BasicIdReference.create(it);
                    pgLikeStoredTable2 = pgLikeStoredTable;
                } else {
                    basicIdReference = null;
                }
                pgLikeStoredTable2.setTablespaceRef(basicIdReference);
            }
            if (table instanceof PgLocalTable) {
                BasicIdReference basicIdReference;
                l = oneTable.am_id;
                it = ((Number)l).longValue();
                pgLikeStoredTable = (PgLocalTable)table;
                boolean bl4 = false;
                bl = it != 0L;
                PgLikeStoredTable pgLikeStoredTable3 = pgLikeStoredTable;
                Long l4 = bl ? l : null;
                if (l4 != null) {
                    it = ((Number)l4).longValue();
                    pgLikeStoredTable = pgLikeStoredTable3;
                    boolean bl5 = false;
                    basicIdReference = BasicIdReference.create(it);
                    pgLikeStoredTable3 = pgLikeStoredTable;
                } else {
                    basicIdReference = null;
                }
                pgLikeStoredTable3.setAccessMethodRef(basicIdReference);
            }
        }

        @Override
        protected void processModTable(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super.processModTable(table, t);
            if (table instanceof PgTable) {
                ((PgTable)table).setPartitionExpression(t.partition_expression);
                if (table instanceof PgLocalTable) {
                    ((PgLocalTable)table).setPartitionKey(t.partition_key);
                }
            }
        }

        @Override
        protected void processModView(@NotNull PgBaseLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (!(table instanceof PgView)) {
                return;
            }
            ((PgView)table).setCheckOption(ArraysKt.contains((Object[])t.options, (Object)"check_option=local") ? PgCheckOption.LOCAL : (ArraysKt.contains((Object[])t.options, (Object)"check_option=cascaded") ? PgCheckOption.CASCADED : PgCheckOption.NONE));
        }

        @Override
        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns, @NotNull PgBaseLikeStoredTable table) {
            Object object;
            block5: {
                PgIdentityKind pgIdentityKind;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)col, (String)"col");
                    Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
                    Intrinsics.checkNotNullParameter(columns, (String)"columns");
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    super.processColumn(col, column2, columns, table);
                    if (!(column2 instanceof PgLocalTableColumn)) {
                        return;
                    }
                    object = col.identity_kind;
                    if (object == null) break block4;
                    char it = object.charValue();
                    boolean bl = false;
                    PgIdentityKind pgIdentityKind2 = PgIdentityKind.Companion.valueFor(it);
                    object = pgIdentityKind2;
                    if (pgIdentityKind2 != null) break block5;
                }
                PgIdentityKind it = pgIdentityKind = PgIdentityKind.ALWAYS;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)col.generated, (Object)"s") ? pgIdentityKind : null;
            }
            Object kind = object;
            ((PgLocalTableColumn)column2).setIdentityKind((PgIdentityKind)((Object)kind));
        }

        @Override
        protected boolean hasReference(@NotNull PgBaseIntroQueries.OneConstraint con) {
            Intrinsics.checkNotNullParameter((Object)con, (String)"con");
            return con.ref_table_id > 0L && con.index_id > 0L;
        }

        @Override
        @NotNull
        protected PgGPlumBaseRoutine createRoutine(@NotNull PgSchema schema, @NotNull PgBaseIntroQueries.OneRoutine r) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            PgGPlumBaseRoutine pgGPlumBaseRoutine = super.createRoutine((PgGPlumBaseSchema)schema, r);
            Intrinsics.checkNotNull((Object)pgGPlumBaseRoutine, (String)"null cannot be cast to non-null type com.intellij.database.dialects.postgres.model.PgRoutine");
            PgRoutine routine2 = (PgRoutine)pgGPlumBaseRoutine;
            routine2.setConcurrencyKind(PgRoutineConcurrencyKind.of(r.concurrency_kind));
            routine2.setWindow(r.kind == 'w');
            routine2.setRows(r.rows);
            return routine2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void processTrigger(@NotNull PgGPlumBaseTrigger trigger2, @NotNull PgGPlumBaseIntroQueries.OneTrigger t) {
            SqlCreateStatement createTrigger;
            Intrinsics.checkNotNullParameter((Object)trigger2, (String)"trigger");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super.processTrigger(trigger2, t);
            if (!(trigger2 instanceof PgTrigger)) {
                return;
            }
            ((PgTrigger)trigger2).setDeferrable(t.is_deferrable);
            ((PgTrigger)trigger2).setInitiallyDeferred(t.is_init_deferred);
            ((PgTrigger)trigger2).setColumnIndices(PgIntrospector.this.parseListOfLongs(t.columns));
            ((PgTrigger)trigger2).setConstraint(t.is_constraint);
            ((PgTrigger)trigger2).setOldTableName(t.old_table_name);
            ((PgTrigger)trigger2).setNewTableName(t.new_table_name);
            String string = t.source_code;
            if (string != null) {
                Object object;
                void this_$iv;
                String string2 = string;
                PgIntrospector pgIntrospector = PgIntrospector.this;
                String it = string2;
                boolean bl = false;
                BaseNativeIntrospector baseNativeIntrospector = pgIntrospector;
                String src$iv = it;
                boolean $i$f$parseStatement = false;
                try {
                    void this_$iv$iv;
                    object = BaseNativeIntrospector.access$getSqlHelper((BaseNativeIntrospector)this_$iv);
                    String src$iv$iv = src$iv;
                    boolean $i$f$statements = false;
                    object = this_$iv$iv.statements(src$iv$iv, SqlCreateStatement.class).first();
                }
                catch (ProcessCanceledException pce$iv) {
                    throw pce$iv;
                }
                catch (Exception e$iv) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        this_$iv.log.error((Throwable)e$iv);
                    }
                    this_$iv.log.warn("Failed to parse sources", (Throwable)e$iv);
                    object = null;
                }
                v1 = (SqlCreateStatement)object;
            } else {
                v1 = createTrigger = null;
            }
            if (createTrigger != null) {
                PgIntrospector.this.getSqlHelper().getBuilder().build(trigger2, createTrigger, PgIntrospector.this.getSqlHelper().getBuilderContext());
            }
        }

        @Override
        protected void processAggregate(@NotNull PgBaseIntroQueries.OneAggregate agg, @NotNull PgBaseAggregate aggregate) {
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Intrinsics.checkNotNullParameter((Object)aggregate, (String)"aggregate");
            super.processAggregate(agg, aggregate);
            PgAggregate cfr_ignored_0 = (PgAggregate)aggregate;
            ((PgAggregate)aggregate).setStateSize(agg.state_size);
            ((PgAggregate)aggregate).setFinalExtra(agg.final_extra);
            ((PgAggregate)aggregate).setMovingTransitionRef(PgIntrospector.this.createIdOrQNameRef(agg.moving_transition_id, agg.moving_transition_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setInverseTransitionRef(PgIntrospector.this.createIdOrQNameRef(agg.inverse_transition_id, agg.inverse_transition_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            PgAggregate pgAggregate = (PgAggregate)aggregate;
            DasType dasType = this.getMyTypes().get(agg.moving_state_type);
            if (dasType == null) {
                dasType = DasTypeSystemBase.UNKNOWN;
            }
            pgAggregate.setMovingStateStoredType(dasType);
            ((PgAggregate)aggregate).setMovingStateSize(agg.moving_state_size);
            ((PgAggregate)aggregate).setMovingFinalRef(PgIntrospector.this.createIdOrQNameRef(agg.moving_final_id, agg.moving_final_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setMovingFinalExtra(agg.moving_final_extra);
            ((PgAggregate)aggregate).setMovingInitialValue(agg.moving_initial_value);
            ((PgAggregate)aggregate).setCombineRef(PgIntrospector.this.createIdOrQNameRef(agg.combine_function_id, agg.combine_function_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setSerializationRef(PgIntrospector.this.createIdOrQNameRef(agg.serialization_function_id, agg.serialization_function_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setDeserializationRef(PgIntrospector.this.createIdOrQNameRef(agg.deserialization_function_id, agg.deserialization_function_name, ((PgIntrospector)PgIntrospector.this).getDbConnectionInfo().schemaName));
            ((PgAggregate)aggregate).setConcurrencyKind(PgRoutineConcurrencyKind.of(agg.concurrency_kind));
            ((PgAggregate)aggregate).setOwnerRef(BasicNameReference.create(agg.getOwnerName()));
        }

        @Override
        protected void processFunSourceAttributes(@NotNull PgBaseRoutine function, @NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            super.processFunSourceAttributes(function, fs);
            PgRoutine cfr_ignored_0 = (PgRoutine)function;
            ((PgRoutine)function).setWithSqlBody(fs.sqlbody_def != null);
        }

        @Override
        @Nullable
        protected CompositeText getFunSourceText(@NotNull PgBaseIntroQueries.OneFunctionSource fs) {
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            Object object = fs.sqlbody_def;
            return object != null && (object = BaseIntrospectionFunctions.toCompositeText((String)object, CompositeText.Kind.DECOMPILED_TEXT)) != null ? (CompositeText)object : super.getFunSourceText(fs);
        }

        @Override
        protected void removeComments(@NotNull Long2ObjectMap<Short[]> existentComments, @NotNull BasicModIdentifiedElement e) {
            Intrinsics.checkNotNullParameter(existentComments, (String)"existentComments");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.removeComments(existentComments, e);
            if (e instanceof PgLocalTable) {
                ModNamingIdentifyingFamily<? extends PgSecurityPolicy> modNamingIdentifyingFamily = ((PgLocalTable)e).getSecurityPolicies();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSecurityPolicies(...)");
                Iterable $this$forEach$iv = modNamingIdentifyingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PgSecurityPolicy it = (PgSecurityPolicy)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this.removeComments(existentComments, it);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void processIndex(@NotNull PgGPlumBaseIndex index, @NotNull PgGPlumBaseIntroQueries.OneIndex ind) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)ind, (String)"ind");
            super.processIndex(index, ind);
            PgIndex cfr_ignored_0 = (PgIndex)index;
            Iterable iterable = PgIntrospector.this.parseListOfLongs(ind.ancestors);
            PgIndex pgIndex = (PgIndex)index;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(BasicIdReference.create((long)it));
            }
            pgIndex.setAncestorRefs((List)destination$iv$iv);
            ((PgIndex)index).setNullsNotDistinct(ind.nulls_not_distinct);
        }

        @Override
        protected boolean incrementalViewSources() {
            int[] nArray = new int[]{9, 2};
            return PgIntrospector.this.getServerVersion().isOrGreater(nArray);
        }

        @Override
        protected boolean isTableKind(char kind) {
            return super.isTableKind(kind) || kind == 'p';
        }

        private final void retrieveSecurityPolicies(boolean removeUnaffected, boolean detectDropped, boolean loadNew) {
            ObjectKind objectKind = ObjectKind.SECURITY_POLICY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SECURITY_POLICY");
            PgIntrospector.this.reportRetrieving(objectKind);
            this.inSchema(arg_0 -> MySchemaRetriever.retrieveSecurityPolicies$lambda$25(removeUnaffected, this, PgIntrospector.this, detectDropped, loadNew, arg_0));
        }

        private final String[] retrieveDependentTableNames() {
            String[] stringArray = this.performQuerySafe(PgIntrospector.this.getQueries().getRetrieveDependentTableNames());
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            return stringArray;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void processLevel2Imp() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.steps();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IntroStep it = (IntroStep)element$iv$iv;
                boolean bl = false;
                if (!(it.getLevel() == Level.L2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List applicableSteps = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            for (IntroStep step : applicableSteps) {
                step.getPerform().invoke((Object)(this.getMode().increment ? (IntroModeCtx)new IntroModeCtx.IncWithL1(true) : (IntroModeCtx)IntroModeCtx.Full.INSTANCE));
            }
            ((PgSchema)this.getSchema()).setLastIntrospectionLevel(Level.L2);
            Long l = PgIntrospector.this.getIntrospectionXid();
            ((PgSchema)this.getSchema()).setLastIntrospectionL2Xid(l != null ? l : 0L);
            ((PgSchema)this.getSchema()).setLastIntrospectionLocalTimestamp(this.getIntrospectionBeginLocalTimestamp());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void processLevel3Imp() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.steps();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IntroStep it = (IntroStep)element$iv$iv;
                boolean bl = false;
                if (!(it.getLevel() == Level.L3)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List applicableSteps = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            for (IntroStep step : applicableSteps) {
                step.getPerform().invoke((Object)(this.getMode().increment ? (IntroModeCtx)new IntroModeCtx.IncWithL1(true) : (IntroModeCtx)IntroModeCtx.Full.INSTANCE));
            }
            ((PgSchema)this.getSchema()).setLastIntrospectionLevel(Level.L3);
            Long l = PgIntrospector.this.getIntrospectionXid();
            ((PgSchema)this.getSchema()).setLastIntrospectionL3Xid(l != null ? l : 0L);
            ((PgSchema)this.getSchema()).setLastIntrospectionLocalTimestamp(this.getIntrospectionBeginLocalTimestamp());
            this.getModel().setSchemaSourcesVersion((BasicSchema)this.getSchema(), ((PgSchema)this.getSchema()).getLastIntrospectionL3Xid());
        }

        private static final Unit steps$lambda$1(PgIntrospector this$0, MySchemaRetriever this$1, IntroModeCtx $this$add) {
            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
            IntroGuidance $this$steps_u24lambda_u241_u24lambda_u240 = $this$add.getGuidanceForMinors();
            boolean bl = false;
            int[] nArray = new int[]{9, 5};
            boolean isSupported = this$0.getServerVersion().isOrGreater(nArray);
            this$1.retrieveSecurityPolicies($this$steps_u24lambda_u241_u24lambda_u240.getRemoveUnaffected(), $this$steps_u24lambda_u241_u24lambda_u240.getDetectDropped() && isSupported, $this$steps_u24lambda_u241_u24lambda_u240.getLoadNew() && isSupported);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDependentTables$lambda$2(MySchemaRetriever this$0) {
            this$0.doIntroSteps();
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final Unit retrieveSecurityPolicies$lambda$25$lambda$24$lambda$23$lambda$22(IdCache $tableCache, ModNamingIdentifyingFamily $tables, PgIntroQueries.OneSecurityPolicy p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            var5_3 = $tableCache;
            id$iv = p.table_id;
            $i$f$get = false;
            var9_8 = this_$iv;
            id$iv$iv = id$iv;
            $i$f$getOrCache = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull(v0);
            if (((BasicIdentifiedElement)v0).getObjectId() == id$iv$iv) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var13_13 = id$iv$iv;
                var15_15 = this_$iv$iv;
                var16_17 = this_$iv$iv;
                $i$a$-getOrCache-IdCache$get$1$iv = false;
                var18_20 = (Function1)new Function1<ModIdentifyingFamily<? extends T>, T>(id$iv){
                    final /* synthetic */ long $id;
                    {
                        this.$id = $id;
                    }

                    public final T invoke(ModIdentifyingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)((BasicModIdentifiedElement)$this$family.getByObjectId(this.$id));
                    }
                };
                $this$retrieveSecurityPolicies_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2418 = $this$get_u24lambda_u240$iv;
                $i$a$-get-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$2$table$1 = false;
                var16_17.setV((BasicModIdentifiedElement)((PgLocalTable)it.invoke((Object)$tables)));
                v1 = this_$iv$iv.getV();
            }
            v2 = (PgLocalTable)v1;
            if (v2 == null) {
                return Unit.INSTANCE;
            }
            table = v2;
            v3 = table.getSecurityPolicies().renew(p.id, p.policyname);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"renew(...)");
            $this$retrieveSecurityPolicies_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421 = var4_24 = v3;
            $i$a$-apply-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$2$1 = false;
            $this$retrieveSecurityPolicies_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421.setStateNumber(p.state_number);
            $this$retrieveSecurityPolicies_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421.setPermissive(p.permissive);
            v4 = $this$retrieveSecurityPolicies_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421;
            v5 /* !! */  = p.roles;
            if (p.roles == null) ** GOTO lbl-1000
            $i$f$get = var7_25 = v5 /* !! */ ;
            var9_8 = v4;
            $i$a$-takeIf-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$2$1$1 = false;
            v4 = var9_8;
            v5 /* !! */  = Boolean.valueOf(it.length != 1 || it[0].longValue() != 0L) != false ? var7_25 : null;
            if (v5 /* !! */  != null) {
                it = v5 /* !! */ ;
                var9_8 = v4;
                $i$f$map = false;
                var11_26 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    $i$a$-getOrCache-IdCache$get$1$iv = ((Number)item$iv$iv).longValue();
                    var19_21 = destination$iv$iv;
                    $i$a$-map-PgIntrospector$MySchemaRetriever$retrieveSecurityPolicies$1$2$1$2$1$2 = false;
                    var19_21.add(BasicIdReference.create((long)it));
                }
                v6 = (List)destination$iv$iv;
                v4 = var9_8;
            } else lbl-1000:
            // 2 sources

            {
                v6 = CollectionsKt.emptyList();
            }
            v4.setRoleRefs(v6);
            var21_28 = p.cmd;
            if (var21_28 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var21_28.hashCode()) {
                case 97: {
                    if (var21_28.equals("a")) {
                        tmp = 1;
                    }
                    break;
                }
                case 114: {
                    if (var21_28.equals("r")) {
                        tmp = 2;
                    }
                    break;
                }
                case 100: {
                    if (var21_28.equals("d")) {
                        tmp = 3;
                    }
                    break;
                }
                case 119: {
                    if (var21_28.equals("w")) {
                        tmp = 4;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 2: {
                    v7 = PgSecurityPolicyOperationType.SELECT;
                    break;
                }
                case 1: {
                    v7 = PgSecurityPolicyOperationType.INSERT;
                    break;
                }
                case 4: {
                    v7 = PgSecurityPolicyOperationType.UPDATE;
                    break;
                }
                case 3: {
                    v7 = PgSecurityPolicyOperationType.DELETE;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v7 = PgSecurityPolicyOperationType.ALL;
                }
            }
            $this$retrieveSecurityPolicies_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421.setOperationType(v7);
            $this$retrieveSecurityPolicies_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421.setUsingExpression(p.qual);
            $this$retrieveSecurityPolicies_u24lambda_u2425_u24lambda_u2424_u24lambda_u2423_u24lambda_u2422_u24lambda_u2421.setCheckExpression(p.with_check);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveSecurityPolicies$lambda$25(boolean $removeUnaffected, MySchemaRetriever this$0, PgIntrospector this$1, boolean $detectDropped, boolean $loadNew, PgSchema schema) {
            void removeUnaffected$iv;
            void fragments$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends PgLocalTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            ModNamingIdentifyingFamily<? extends PgLocalTable> tables = modNamingIdentifyingFamily;
            boolean bl = $removeUnaffected;
            Iterable iterable = CollectionsKt.listOf(tables);
            String[] stringArray = this$0.getFragmentNamesOrNull();
            boolean $i$f$modifyFamilyFragmentsAndCleanupInner = false;
            List relevantInnerFamilies$iv = new ArrayList();
            if (fragments$iv == null) {
                for (ModNamingFamily family$iv : majorFamilies$iv) {
                    for (Object element$iv : family$iv) {
                        PgLocalTable x = (PgLocalTable)element$iv;
                        boolean bl2 = false;
                        Iterable innerFamilies$iv = CollectionsKt.listOf(x.getSecurityPolicies());
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            } else {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])fragments$iv);
                while (iterator.hasNext()) {
                    String fragment$iv = (String)iterator.next();
                    for (ModNamingFamily family$iv : majorFamilies$iv) {
                        Object element$iv;
                        if (family$iv.get(fragment$iv) == null) continue;
                        PgLocalTable x = (PgLocalTable)element$iv;
                        boolean bl3 = false;
                        Iterable innerFamilies$iv = CollectionsKt.listOf(x.getSecurityPolicies());
                        CollectionsKt.addAll((Collection)relevantInnerFamilies$iv, (Iterable)innerFamilies$iv);
                    }
                }
            }
            if (removeUnaffected$iv != false) {
                for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                    innerFamily$iv.markChildrenAsSyncPending();
                }
            }
            boolean bl4 = false;
            BaseNativeIntrospector this_$iv = this$1;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl5 = false;
                if ($detectDropped) {
                    LongOpenHashSet ids = new LongOpenHashSet(this$0.performQuery(this$1.getQueries().getRetrieveExistentSecurityPolices()));
                    Iterable $this$forEach$iv = tables;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PgLocalTable t = (PgLocalTable)element$iv;
                        boolean bl6 = false;
                        ModNamingIdentifyingFamily<? extends PgSecurityPolicy> modNamingIdentifyingFamily2 = t.getSecurityPolicies();
                        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getSecurityPolicies(...)");
                        Iterable $this$forEach$iv2 = modNamingIdentifyingFamily2;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            PgSecurityPolicy sp = (PgSecurityPolicy)element$iv2;
                            boolean bl7 = false;
                            if (!ids.contains(sp.getObjectId())) continue;
                            sp.resetSyncPending();
                        }
                    }
                }
                if ($loadNew) {
                    IdCache tableCache = new IdCache();
                    BaseNativeIntrospector.AbstractRetriever.performQueryHandleEachRow$default(this$0, this$1.getQueries().getRetrieveSecurityPolices(), 0, arg_0 -> MySchemaRetriever.retrieveSecurityPolicies$lambda$25$lambda$24$lambda$23$lambda$22(tableCache, tables, arg_0), 2, null);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u2417$iv$iv = stringBuilder = new StringBuilder();
                boolean bl8 = false;
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u2417$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)this_$iv$iv, message$iv$iv, null, 2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (ModNamingFamily innerFamily$iv : relevantInnerFamilies$iv) {
                if (removeUnaffected$iv != false) {
                    innerFamily$iv.removeSyncPendingChildren();
                }
                innerFamily$iv.sort();
            }
            return Unit.INSTANCE;
        }
    }
}

