/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.util.TokenPattern;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.impl.lexer.PreprocessingLexer;
import java.util.regex.MatchResult;
import org.jetbrains.annotations.Nullable;

class PreprocessorMatchState {
    private static final Logger LOG = Logger.getInstance(PreprocessingLexer.class);
    private final TokenPattern.Matcher myUserParamMatcher;
    private final String myStatementDelimiter;
    private boolean myDelimiterMatched;
    private CharSequence myBuffer;
    private int myStart = -1;
    private int myEnd = -1;

    PreprocessorMatchState(@Nullable TokenPattern userParamPattern, @Nullable String statementDelimiter) {
        this.myUserParamMatcher = userParamPattern != null ? userParamPattern.newMatcher() : null;
        this.myStatementDelimiter = StringUtil.isEmptyOrSpaces((String)statementDelimiter) ? null : statementDelimiter;
    }

    public void reset(CharSequence buffer) {
        if (this.myUserParamMatcher != null) {
            this.myUserParamMatcher.reset(buffer);
        }
        this.myBuffer = buffer;
        this.myDelimiterMatched = false;
        this.myStart = -1;
        this.myEnd = -1;
    }

    public void resetTo(int end) {
        this.myStart = this.myEnd = end;
    }

    private boolean findMatchOn(int offset, int limit, @Nullable TokenPattern.Matcher matcher) {
        if (matcher == null) {
            return false;
        }
        boolean found = matcher.find(offset, limit);
        if (found && matcher.start() == matcher.end()) {
            LOG.warn("Pattern matches empty text");
            found = false;
        }
        if (found) {
            this.myStart = matcher.start();
            this.myEnd = matcher.end();
            return true;
        }
        return false;
    }

    private boolean onlySpacesAndDelimitersUpToEol(int offset) {
        char ch;
        String delimiter = StringUtil.notNullize((String)this.myStatementDelimiter);
        int i2 = offset;
        while (i2 < this.myBuffer.length() && (ch = this.myBuffer.charAt(i2)) != '\n') {
            if (Character.isSpaceChar(ch)) {
                ++i2;
                continue;
            }
            if (StringUtil.startsWith((CharSequence)this.myBuffer, (int)i2, (CharSequence)delimiter)) {
                i2 += delimiter.length();
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean findDelimiterMatch(int offset) {
        this.myDelimiterMatched = false;
        if (this.myStatementDelimiter != null) {
            int start2 = Math.min(offset, this.myBuffer.length());
            int end = this.myBuffer.length();
            if (end - start2 >= this.myStatementDelimiter.length() && StringUtil.startsWith((CharSequence)this.myBuffer, (int)start2, (CharSequence)this.myStatementDelimiter) && this.onlySpacesAndDelimitersUpToEol(start2 + this.myStatementDelimiter.length())) {
                this.myDelimiterMatched = true;
                this.myStart = start2;
                this.myEnd = start2 + this.myStatementDelimiter.length();
            }
        }
        return this.myDelimiterMatched;
    }

    public boolean findMatchOn(int offset, int limit) {
        if (offset < limit) {
            if (this.findDelimiterMatch(offset)) {
                return true;
            }
            if (this.findMatchOn(offset, limit, this.myUserParamMatcher)) {
                return true;
            }
        }
        this.myStart = this.myEnd = Math.max(limit, offset);
        return false;
    }

    public int start() {
        return this.myStart;
    }

    public int end() {
        return this.myEnd;
    }

    boolean hasMatch() {
        return this.myStart < this.myEnd;
    }

    public MatchResult getMatch() {
        return this.myUserParamMatcher != null ? this.myUserParamMatcher.getResult() : null;
    }

    public boolean isDelimiterMatch() {
        return this.myDelimiterMatched;
    }
}

