/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.util.Strings;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.Db2IsJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.Db2JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.Db2LuwJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.Db2ZosJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.openapi.util.text.StringUtilRt;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Db2BaseJdbcHelper
extends JdbcHelperImpl {
    private static final Pattern DB2_VERSION_PATTERN = Pattern.compile("\\w\\w\\w(\\d\\d)(\\d\\d)(\\d+)");
    private static final Pattern DB2_ISERIES_VERSION_PATTERN = Pattern.compile(".+\\s+V(\\d+)R(\\d+)m(\\d+)");
    private static final Set<String> DB2_UNLIMITED_TYPES = JdbcNativeUtil.addAll(new HashSet(), "integer", "smallint", "boolean", "bigint", "double", "real", "date", "time", "xml");
    private static final Set<String> DB2_TWICE_TYPES = JdbcNativeUtil.addAll(new HashSet(), "graphic", "vargraphic", "dbclob");

    public Db2BaseJdbcHelper(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        if (dbmsName == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection, jdbcClassLoader);
    }

    protected Db2BaseJdbcHelper(@NotNull Db2BaseJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(1);
        }
        if (jdbcClassLoader == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(2);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    protected void setBigInteger(@NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (statement == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(3);
        }
        if (value == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(4);
        }
        statement.setObject(idx, value.longValue());
    }

    @Override
    public String getSchemaName(@NotNull ResultSetMetaData delegate, int column) throws SQLException {
        String name;
        if (delegate == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(5);
        }
        return (name = super.getSchemaName(delegate, column)) == null ? null : Strings.rtrim(name);
    }

    @Override
    public Object convertValue(JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        Class<?> c = o.getClass();
        String className = c.getName();
        if (className.equals("com.ibm.db2.jcc.am.ke") || className.equals("com.ibm.db2.jcc.am.bf") || className.equals("com.ibm.db2.jcc.am.dc")) {
            return JdbcNativeUtil.tryGetString(o);
        }
        return super.convertValue(exporter, o);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(6);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (DB2_UNLIMITED_TYPES.contains(t) || e.length == 0) {
            e.length = -1;
        } else if (t.equals("timestamp")) {
            e.length = e.scale;
            e.scale = 0;
        } else if (DB2_TWICE_TYPES.contains(t)) {
            e.length /= 2;
        }
        Db2BaseJdbcHelper.processForBitData(e);
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) {
        if (!JdbcNativeUtil.detectString(product, "db2")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        String version = StringUtilRt.notNullize((String)productVer);
        return version.startsWith("SQL") ? Db2LuwJdbcHelper.create(delegate, productVer, jdbcClassLoader) : (version.startsWith("QSQ") || JdbcNativeUtil.detectString(product, "AS/400") ? Db2IsJdbcHelper.create(delegate, productVer, jdbcClassLoader) : (version.startsWith("DSN") ? Db2ZosJdbcHelper.create(delegate, productVer, jdbcClassLoader) : Db2JdbcHelper.create(delegate, productVer, jdbcClassLoader)));
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(7);
        }
        return Db2BaseJdbcHelper.classNameContains(driver, "DB2Driver");
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, @Nullable Level level, @Nullable String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        if (level != null) {
            Db2BaseJdbcHelper.setIfEmpty(properties, "traceLevel", level == Level.OFF ? "0" : "-1");
        }
        if (logPath != null) {
            Db2BaseJdbcHelper.setIfEmpty(properties, "traceDirectory", logPath);
        }
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return Db2BaseJdbcHelper.extractVersion(version);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = DB2_VERSION_PATTERN.matcher(str);
        if (matcher.find()) {
            return Db2BaseJdbcHelper.extractVersion(matcher);
        }
        matcher = DB2_ISERIES_VERSION_PATTERN.matcher(str);
        if (matcher.find()) {
            return Db2BaseJdbcHelper.extractVersion(matcher);
        }
        return null;
    }

    @NotNull
    private static String extractVersion(@NotNull Matcher matcher) {
        String s;
        if (matcher == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(8);
        }
        if ((s = matcher.group(1)).startsWith("0")) {
            s = s.substring(1);
        }
        String string = s + "." + matcher.group(2) + "." + matcher.group(3);
        if (string == null) {
            Db2BaseJdbcHelper.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/Db2BaseJdbcHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/Db2BaseJdbcHelper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "extractVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBigInteger";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractVersion";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

