/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.io.ByteArrayOutputStream;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.BoundedIntDistribution;
import org.jetbrains.jetCheck.DataSerializer;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.NodeId;
import org.jetbrains.jetCheck.ShrinkStep;
import org.jetbrains.jetCheck.StructureElement;

class IntData
extends StructureElement {
    final int value;
    final IntDistribution distribution;

    IntData(NodeId id, int value, IntDistribution distribution) {
        super(id);
        this.value = value;
        this.distribution = distribution;
    }

    @Override
    @Nullable
    ShrinkStep shrink() {
        if (this.value == 0) {
            return null;
        }
        int minValue = 0;
        if (this.distribution instanceof BoundedIntDistribution) {
            minValue = Math.max(minValue, this.distribution.getMin());
        }
        return this.tryInt(minValue, () -> null, this::tryNegation);
    }

    private ShrinkStep tryNegation() {
        if (this.value < 0) {
            return this.tryInt(-this.value, () -> this.divisionLoop(-this.value), () -> this.divisionLoop(this.value));
        }
        return this.divisionLoop(this.value);
    }

    private ShrinkStep divisionLoop(int value) {
        if (value == 0) {
            return null;
        }
        int divided = value / 2;
        return this.tryInt(divided, () -> this.divisionLoop(divided), null);
    }

    private ShrinkStep tryInt(int value, @NotNull Supplier<ShrinkStep> success, @Nullable Supplier<ShrinkStep> fail) {
        return this.distribution.isValidValue(value) ? ShrinkStep.create(this.id, new IntData(this.id, value, this.distribution), __ -> (ShrinkStep)success.get(), fail) : (fail == null ? null : fail.get());
    }

    @Override
    @NotNull
    IntData replace(NodeId id, StructureElement replacement) {
        return this.id == id ? (IntData)replacement : this;
    }

    @Override
    @Nullable
    StructureElement findChildById(NodeId id) {
        return id == this.id ? this : null;
    }

    @Override
    void serialize(ByteArrayOutputStream out) {
        DataSerializer.writeINT(out, this.value);
    }

    @Override
    StructureElement removeUnneeded(Set<NodeId> unneeded) {
        return this;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof IntData && this.value == ((IntData)obj).value;
    }

    public int hashCode() {
        return this.value;
    }
}

