/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalRange;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangeExclusionState;
import com.intellij.openapi.vcs.ex.commit.ChunkCommitMessagePolicy;
import com.intellij.openapi.vcs.ex.commit.CommitChunkPanel;
import com.intellij.openapi.vcs.ex.commit.CommitChunkWorkflow;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.CommitProjectPanelAdapter;
import com.intellij.vcs.commit.CommitSessionInfo;
import com.intellij.vcs.commit.CommitWorkflowListener;
import com.intellij.vcs.commit.NonModalAmendCommitHandler;
import com.intellij.vcs.commit.NonModalCommitWorkflowHandler;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0094@\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020%H\u0002J\u0012\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020'H\u0014J\u000e\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/openapi/vcs/ex/commit/CommitChunkWorkFlowHandler;", "Lcom/intellij/vcs/commit/NonModalCommitWorkflowHandler;", "Lcom/intellij/openapi/vcs/ex/commit/CommitChunkWorkflow;", "Lcom/intellij/openapi/vcs/ex/commit/CommitChunkPanel;", "tracker", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;", "rangeProvider", "Lkotlin/Function0;", "Lcom/intellij/openapi/vcs/ex/LocalRange;", "<init>", "(Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;Lkotlin/jvm/functions/Function0;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker;", "getRangeProvider", "()Lkotlin/jvm/functions/Function0;", "workflow", "getWorkflow", "()Lcom/intellij/openapi/vcs/ex/commit/CommitChunkWorkflow;", "amendCommitHandler", "Lcom/intellij/vcs/commit/NonModalAmendCommitHandler;", "getAmendCommitHandler", "()Lcom/intellij/vcs/commit/NonModalAmendCommitHandler;", "ui", "getUi", "()Lcom/intellij/openapi/vcs/ex/commit/CommitChunkPanel;", "commitPanel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "getCommitPanel", "()Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitMessagePolicy", "Lcom/intellij/openapi/vcs/ex/commit/ChunkCommitMessagePolicy;", "updateWorkflow", "", "sessionInfo", "Lcom/intellij/vcs/commit/CommitSessionInfo;", "(Lcom/intellij/vcs/commit/CommitSessionInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCommitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "executorCalled", "", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "saveCommitMessageBeforeCommit", "setPopup", "popupDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCommitChunkComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitChunkComponent.kt\ncom/intellij/openapi/vcs/ex/commit/CommitChunkWorkFlowHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,424:1\n230#2,2:425\n*S KotlinDebug\n*F\n+ 1 CommitChunkComponent.kt\ncom/intellij/openapi/vcs/ex/commit/CommitChunkWorkFlowHandler\n*L\n285#1:425,2\n*E\n"})
final class CommitChunkWorkFlowHandler
extends NonModalCommitWorkflowHandler<CommitChunkWorkflow, CommitChunkPanel> {
    @NotNull
    private final ChangelistsLocalLineStatusTracker tracker;
    @NotNull
    private final Function0<LocalRange> rangeProvider;
    @NotNull
    private final CommitChunkWorkflow workflow;
    @NotNull
    private final NonModalAmendCommitHandler amendCommitHandler;
    @NotNull
    private final CommitChunkPanel ui;
    @NotNull
    private final CheckinProjectPanel commitPanel;
    @NotNull
    private final ChunkCommitMessagePolicy commitMessagePolicy;

    public CommitChunkWorkFlowHandler(@NotNull ChangelistsLocalLineStatusTracker tracker, @NotNull Function0<LocalRange> rangeProvider) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter(rangeProvider, (String)"rangeProvider");
        this.tracker = tracker;
        this.rangeProvider = rangeProvider;
        this.workflow = new CommitChunkWorkflow(this.tracker.getProject());
        this.amendCommitHandler = new NonModalAmendCommitHandler(this);
        this.ui = new CommitChunkPanel(this.tracker, this.getAmendCommitHandler());
        this.commitPanel = new CommitProjectPanelAdapter(this);
        this.commitMessagePolicy = new ChunkCommitMessagePolicy(this.getProject(), this.getUi().getCommitMessageUi());
        this.getUi().addExecutorListener(this, this);
        this.getWorkflow().addListener(this, this);
        this.getWorkflow().addVcsCommitListener(new NonModalCommitWorkflowHandler.CommitStateCleaner(){

            @Override
            public void onSuccess() {
                commitMessagePolicy.onAfterCommit();
                super.onSuccess();
            }
        }, this);
        this.getWorkflow().addVcsCommitListener(new NonModalCommitWorkflowHandler.PostCommitChecksRunner(), this);
        this.commitMessagePolicy.init();
        this.setupDumbModeTracking();
        this.setupCommitHandlersTracking();
        this.setupCommitChecksResultTracking();
        this.vcsesChanged();
    }

    @NotNull
    public final ChangelistsLocalLineStatusTracker getTracker() {
        return this.tracker;
    }

    @NotNull
    public final Function0<LocalRange> getRangeProvider() {
        return this.rangeProvider;
    }

    @Override
    @NotNull
    public CommitChunkWorkflow getWorkflow() {
        return this.workflow;
    }

    @Override
    @NotNull
    public NonModalAmendCommitHandler getAmendCommitHandler() {
        return this.amendCommitHandler;
    }

    @Override
    @NotNull
    public CommitChunkPanel getUi() {
        return this.ui;
    }

    @Override
    @NotNull
    protected CheckinProjectPanel getCommitPanel() {
        return this.commitPanel;
    }

    @Override
    @Nullable
    protected Object updateWorkflow(@NotNull CommitSessionInfo sessionInfo, @NotNull Continuation<? super Boolean> $completion) {
        this.getWorkflow().setState(this.getCommitState());
        this.getWorkflow().setRange((LocalRange)this.rangeProvider.invoke());
        return Boxing.boxBoolean((boolean)true);
    }

    private final ChangeListCommitState getCommitState() {
        Object element$iv2;
        List<Change> changes;
        block1: {
            changes = this.getIncludedChanges();
            List<ChangelistsLocalLineStatusTracker.RangeState> rangeStates = this.tracker.collectRangeStates$intellij_platform_vcs_impl();
            Iterable $this$first$iv = rangeStates;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                ChangelistsLocalLineStatusTracker.RangeState it = (ChangelistsLocalLineStatusTracker.RangeState)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getExcludedFromCommit(), (Object)RangeExclusionState.Included.INSTANCE)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        ChangelistsLocalLineStatusTracker.RangeState first = (ChangelistsLocalLineStatusTracker.RangeState)element$iv2;
        LocalChangeList localChangeList = ChangeListManager.getInstance((Project)this.getProject()).getChangeList(first.getChangelistId());
        Intrinsics.checkNotNull((Object)localChangeList);
        LocalChangeList changeList = localChangeList;
        String string = this.getUi().getCommitMessage().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new ChangeListCommitState(changeList, changes, string);
    }

    @Override
    public void executorCalled(@Nullable CommitExecutor executor) {
        this.tracker.excludeAllBlocks();
        this.tracker.setExcludedFromCommit((Range)this.rangeProvider.invoke(), false);
        super.executorCalled(executor);
    }

    @Override
    protected void saveCommitMessageBeforeCommit() {
        this.commitMessagePolicy.onBeforeCommit();
    }

    public final void setPopup(@NotNull Disposable popupDisposable) {
        Intrinsics.checkNotNullParameter((Object)popupDisposable, (String)"popupDisposable");
        this.getWorkflow().addListener(new CommitWorkflowListener(popupDisposable){
            final /* synthetic */ Disposable $popupDisposable;
            {
                this.$popupDisposable = $popupDisposable;
            }

            public void executionStarted() {
                Disposer.dispose((Disposable)this.$popupDisposable);
            }
        }, popupDisposable);
        Disposer.register((Disposable)popupDisposable, () -> CommitChunkWorkFlowHandler.setPopup$lambda$1(this));
        this.commitMessagePolicy.init();
        if (StringsKt.isBlank((CharSequence)this.getUi().getCommitMessageUi().getText())) {
            this.getUi().resetSize();
        }
    }

    private static final void setPopup$lambda$1(CommitChunkWorkFlowHandler this$0) {
        this$0.commitMessagePolicy.saveTempChunkCommitMessage(this$0.getUi().getCommitMessageUi().getText());
    }
}

