/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.multitoken;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.morfologik.WeightedSuggestion;
import org.languagetool.tools.StringTools;

public class MultitokenSpeller {
    private static final int MAX_LENGTH_DIFF = 3;
    private static final Pattern WHITESPACE_AND_SEP = Pattern.compile("\\p{Zs}+");
    private static final Pattern DASH_SPACE = Pattern.compile("- ");
    private static final Pattern SPACE_DASH = Pattern.compile(" -");
    private final SpellingCheckRule spellingRule;
    private final Language language;
    private HashMap<Character, HashMap<String, List<String>>> suggestionsMap;
    private HashMap<String, List<String>> suggestionsMapNoSpacesKey;

    public MultitokenSpeller(Language lang, List<String> filePaths) {
        this.language = lang;
        this.spellingRule = lang.getDefaultSpellingRule();
        this.initMultitokenSpeller(filePaths);
    }

    public List<String> getSuggestions(String originalWord) throws IOException {
        return this.getSuggestions(originalWord, false);
    }

    public List<String> getSuggestions(String originalWord, boolean areTokensAcceptedBySpeller) throws IOException {
        originalWord = WHITESPACE_AND_SEP.matcher(originalWord).replaceAll(" ");
        String word = DASH_SPACE.matcher(originalWord).replaceAll("-");
        if (this.discardRunOnWords(word = SPACE_DASH.matcher(word).replaceAll("-"))) {
            return Collections.emptyList();
        }
        String normalizedWord = MultitokenSpeller.getNormalizeKey(word);
        ArrayList<WeightedSuggestion> weightedCandidates = new ArrayList<WeightedSuggestion>();
        String normalizedWordNoSpaces = normalizedWord.replaceAll(" ", "");
        if (this.suggestionsMapNoSpacesKey.containsKey(normalizedWordNoSpaces)) {
            List<String> candidates = this.suggestionsMapNoSpacesKey.get(normalizedWordNoSpaces);
            if (this.stopSearching(candidates, originalWord)) {
                return Collections.emptyList();
            }
            for (String string2 : candidates) {
                weightedCandidates.add(new WeightedSuggestion(string2, 0));
            }
        }
        Character firstChar = Character.valueOf(normalizedWord.charAt(0));
        if (weightedCandidates.isEmpty() && this.suggestionsMap.containsKey(firstChar)) {
            for (Map.Entry entry2 : this.suggestionsMap.get(firstChar).entrySet()) {
                String[] wordParts;
                String normalizedCandidate = (String)entry2.getKey();
                List candidates = (List)entry2.getValue();
                if (this.stopSearching(candidates, originalWord)) {
                    return Collections.emptyList();
                }
                if (Math.abs(normalizedCandidate.length() - word.length()) > 3) continue;
                String[] candidateParts = normalizedCandidate.split(" ");
                List<Integer> distances = this.distancesPerWord(candidateParts, wordParts = normalizedWord.split(" "), normalizedCandidate, normalizedWord);
                int totalDistance = distances.stream().reduce(0, Integer::sum);
                if (totalDistance < 1) {
                    for (String candidate : candidates) {
                        weightedCandidates.add(new WeightedSuggestion(candidate, 0));
                    }
                    if (weightedCandidates.size() != 2) continue;
                    break;
                }
                if (normalizedCandidate.length() < 7) continue;
                boolean exceedsMaxDistancePerToken = false;
                for (int i = 0; i < distances.size(); ++i) {
                    int maxDistance;
                    int n = maxDistance = wordParts[i].length() > 5 && candidateParts[i].length() > 4 ? 2 : 1;
                    if (distances.get(i) <= maxDistance) continue;
                    exceedsMaxDistancePerToken = true;
                    break;
                }
                if (exceedsMaxDistancePerToken || totalDistance > this.maxEditDistance(normalizedCandidate, normalizedWord)) continue;
                for (String candidate : candidates) {
                    weightedCandidates.add(new WeightedSuggestion(candidate, totalDistance));
                }
            }
        }
        if (weightedCandidates.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(weightedCandidates);
        ArrayList<String> results = new ArrayList<String>();
        int n = ((WeightedSuggestion)weightedCandidates.get(0)).getWeight();
        if (areTokensAcceptedBySpeller && ((WeightedSuggestion)weightedCandidates.get(0)).getWord().toUpperCase().equals(originalWord)) {
            return Collections.emptyList();
        }
        if (areTokensAcceptedBySpeller && n > 1) {
            return Collections.emptyList();
        }
        for (WeightedSuggestion weightedCandidate : weightedCandidates) {
            if (weightedCandidate.getWeight() - n >= 1) continue;
            results.add(weightedCandidate.getWord());
        }
        return results;
    }

    private boolean stopSearching(List<String> candidates, String originalWord) {
        for (String candidate : candidates) {
            if (this.isException(originalWord, candidate)) {
                return true;
            }
            if (!candidate.equals(originalWord)) continue;
            return true;
        }
        for (String candidate : candidates) {
            if (!candidate.equals(candidate.toLowerCase()) || !StringTools.convertToTitleCaseIteratingChars(candidate).equals(originalWord)) continue;
            return true;
        }
        return false;
    }

    private int maxEditDistance(String normalizedCandidate, String normalizedWord) {
        int totalLength = normalizedWord.length();
        int correctLength = totalLength - this.numberOfCorrectChars(normalizedCandidate, normalizedWord);
        float firstCharWrong = this.firstCharacterDistances(normalizedCandidate, normalizedWord).stream().reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        if (correctLength <= 7) {
            return (int)(2.0f - firstCharWrong);
        }
        return (int)(2.0 + 0.25 * (double)(correctLength - 7) - 0.6 * (double)firstCharWrong);
    }

    private List<Integer> distancesPerWord(String[] parts1, String[] parts2, String s1, String s2) {
        ArrayList<Integer> distances = new ArrayList<Integer>();
        if (parts1.length == parts2.length && parts1.length > 1) {
            for (int i = 0; i < parts1.length; ++i) {
                distances.add(this.levenshteinDistance(parts1[i], parts2[i]));
            }
        } else {
            distances.add(this.levenshteinDistance(s1, s2));
        }
        return distances;
    }

    private List<Float> firstCharacterDistances(String s1, String s2) {
        String[] parts2;
        ArrayList<Float> distances = new ArrayList<Float>();
        String[] parts1 = s1.split(" ");
        if (parts1.length == (parts2 = s2.split(" ")).length && parts1.length == 2) {
            for (int i = 0; i < parts1.length; ++i) {
                distances.add(Float.valueOf(this.charDistance(parts1[i].charAt(0), parts2[i].charAt(0))));
            }
        } else {
            distances.add(Float.valueOf(0.0f));
        }
        return distances;
    }

    private float charDistance(char a, char b) {
        if (a == b) {
            return 0.0f;
        }
        if (a == 's' && b == 'z' || a == 'z' && b == 's') {
            return 0.2f;
        }
        if (a == 'b' && b == 'v' || a == 'v' && b == 'b') {
            return 0.2f;
        }
        if (a == 'i' && b == 'y' || a == 'y' && b == 'i') {
            return 0.0f;
        }
        return 1.0f;
    }

    private int levenshteinDistance(String s1, String s2) {
        if (s1.replaceAll(" ", "").equals(s2.replaceAll(" ", ""))) {
            return 0;
        }
        int distance = LevenshteinDistance.getDefaultInstance().apply(s1, s2);
        String ns1 = this.normalizeSimilarChars(s1);
        String ns2 = this.normalizeSimilarChars(s2);
        if (!s1.equals(ns1) || !s2.equals(ns2)) {
            distance = Math.min(distance, LevenshteinDistance.getDefaultInstance().apply(this.normalizeSimilarChars(s1), this.normalizeSimilarChars(s2)));
        }
        if (distance > 1 && StringTools.isAnagram(s1, s2)) {
            --distance;
        }
        if (distance > 0 && s1.length() == s2.length() && StringTools.isAnagram(s1, s2)) {
            distance = 1;
        }
        return distance;
    }

    private String normalizeSimilarChars(String s) {
        return s.replaceAll("y", "i").replaceAll("ko", "co").replaceAll("ka", "ca");
    }

    private int numberOfCorrectChars(String s1, String s2) {
        String[] parts1 = s1.split(" ");
        String[] parts2 = s2.split(" ");
        int correctTokens = 0;
        if (parts1.length == parts2.length && parts1.length > 1) {
            for (int i = 0; i < parts1.length; ++i) {
                if (!parts1[i].equals(parts2[i])) continue;
                correctTokens += parts1[i].length();
            }
        }
        return correctTokens;
    }

    private void initMultitokenSpeller(List<String> filePaths) {
        if (this.suggestionsMap != null) {
            return;
        }
        this.suggestionsMap = new HashMap();
        this.suggestionsMapNoSpacesKey = new HashMap();
        for (String filePath : filePaths) {
            try {
                InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(filePath);
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    Throwable throwable2 = null;
                    try {
                        String lineOriginal;
                        while ((lineOriginal = reader.readLine()) != null) {
                            if (lineOriginal.isEmpty() || lineOriginal.charAt(0) == '#') continue;
                            for (String line : this.language.prepareLineForSpeller(StringUtils.substringBefore((String)lineOriginal, (String)"#").trim())) {
                                String normalizedKey;
                                if (line.isEmpty() || !(normalizedKey = MultitokenSpeller.getNormalizeKey(line)).contains(" ")) continue;
                                Character firstChar = Character.valueOf(normalizedKey.charAt(0));
                                HashMap suggestionsMapByChar = this.suggestionsMap.computeIfAbsent(firstChar, k -> new HashMap());
                                MultitokenSpeller.addToMap(suggestionsMapByChar, normalizedKey, line);
                                MultitokenSpeller.addToMap(this.suggestionsMapNoSpacesKey, normalizedKey.replaceAll(" ", ""), line);
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void addToMap(Map<String, List<String>> map, String key2, String value) {
        List list = map.computeIfAbsent(key2, k -> new ArrayList());
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    private static String getNormalizeKey(String word) {
        return StringTools.removeDiacritics(word.toLowerCase()).replaceAll("-", " ");
    }

    private boolean discardRunOnWords(String underlinedError) throws IOException {
        String[] parts = underlinedError.split(" ");
        if (parts.length == 2) {
            if (StringTools.isCapitalizedWord(parts[1])) {
                return false;
            }
            if (parts[0].isEmpty() || parts[1].isEmpty()) {
                return true;
            }
            String sugg1a = parts[0].substring(0, parts[0].length() - 1);
            String sugg1b = parts[0].substring(parts[0].length() - 1) + parts[1];
            if (!this.spellingRule.isMisspelled(sugg1a) && !this.spellingRule.isMisspelled(sugg1b)) {
                return true;
            }
            String sugg2a = parts[0] + parts[1].charAt(0);
            String sugg2b = parts[1].substring(1);
            return !this.spellingRule.isMisspelled(sugg2a) && !this.spellingRule.isMisspelled(sugg2b);
        }
        return false;
    }

    protected boolean isException(String original, String candidate) {
        return false;
    }
}

